/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.designer.client.DesignerView;
import org.jbpm.designer.client.popup.ActivityDataIOEditor;
import org.jbpm.designer.client.shared.AssignmentData;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.type.Bpmn2Type;
import org.jbpm.designer.notification.DesignerNotificationEvent;
import org.jbpm.designer.service.DesignerAssetService;
import org.jbpm.designer.service.DesignerContent;
import org.kie.workbench.common.widgets.client.callbacks.CommandBuilder;
import org.kie.workbench.common.widgets.client.callbacks.CommandDrivenErrorCallback;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.file.CommandWithFileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.CopyPopup;
import org.uberfire.ext.editor.commons.client.file.FileNameAndCommitMessage;
import org.uberfire.ext.editor.commons.client.file.RenamePopup;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.util.URIUtil;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="jbpm.designer", supportedTypes={Bpmn2Type.class})
public class DesignerPresenter
extends KieEditor {
    @Inject
    private Caller<DesignerAssetService> assetService;
    @Inject
    private PlaceManager placeManager;
    @Inject
    SessionInfo sessionInfo;
    @Inject
    private Caller<VFSService> vfsServices;
    @Inject
    private Caller<DeleteService> deleteService;
    @Inject
    private Caller<CopyService> copyService;
    @Inject
    private Caller<RenameService> renameService;
    @Inject
    private Bpmn2Type resourceType;
    @Inject
    private User user;
    @Inject
    private ActivityDataIOEditor activityDataIOEditor;
    private DesignerView view;

    @Inject
    public DesignerPresenter(DesignerView view) {
        super((KieEditorView)view);
        this.view = view;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.resourceType);
    }

    @OnMayClose
    public boolean canClose() {
        return this.view.canClose();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    protected void makeMenuBar() {
        this.menus = this.menuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(new Command(){

            public void execute() {
                DesignerPresenter.this.onSave();
            }
        })).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.fileNameValidator).addRename((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.fileNameValidator).addDelete((Path)this.versionRecordManager.getPathToLatest()).addNewTopLevelMenu(this.versionRecordManager.buildMenu()).build();
    }

    @OnClose
    public void onClose() {
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return super.getWidget();
    }

    public void notifyOpenInXMLEditor(@Observes DesignerNotificationEvent event) {
        if (this.user.getIdentifier().equals(event.getUserId()) && event.getNotification() != null && event.getNotification().equals("openinxmleditor")) {
            this.view.askOpenInXMLEditor();
        }
    }

    private native void publishOpenInXMLEditorTab(DesignerPresenter var1);

    private native void publishProcessSourcesInfo(String var1);

    private native void publishActiveNodesInfo(String var1);

    private native void publishCompletedNodesInfo(String var1);

    private native void publishOpenInTab(DesignerPresenter var1);

    private native void publishSignalOnAssetDelete(DesignerPresenter var1);

    private native void publishSignalOnAssetCopy(DesignerPresenter var1);

    private native void publishSignalOnAssetRename(DesignerPresenter var1);

    private native void publishSignalOnAssetUpdate(DesignerPresenter var1);

    private native void publishSignalOnAssetExpectConcurrentUpdate(DesignerPresenter var1);

    private native void publishClosePlace(DesignerPresenter var1);

    private native void publishShowDataIOEditor(DesignerPresenter var1);

    public void closePlace() {
        if (this.view.getIsReadOnly()) {
            this.placeManager.forceClosePlace(this.place);
        }
    }

    public void assetCopyEvent(String uri) {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<ObservablePath>(){

            public void callback(final ObservablePath mypath) {
                CopyPopup popup = new CopyPopup((Path)mypath, (Validator)DesignerPresenter.this.fileNameValidator, new CommandWithFileNameAndCommitMessage(){

                    public void execute(FileNameAndCommitMessage details) {
                        DesignerPresenter.this.baseView.showLoading();
                        ((CopyService)DesignerPresenter.this.copyService.call(DesignerPresenter.this.getCopySuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)DesignerPresenter.this.baseView))).copy((Path)mypath, details.getNewFileName(), details.getCommitMessage());
                    }
                });
                popup.show();
            }
        })).get(URIUtil.encode((String)uri));
    }

    public void showDataIOEditor(String taskName, String datainput, String datainputset, String dataoutput, String dataoutputset, String processvars, String assignments, String datatypes, final JavaScriptObject jscallback) {
        final DesignerPresenter dp = this;
        this.activityDataIOEditor.setCallback(new ActivityDataIOEditor.GetDataCallback(){

            @Override
            public void getData(String data) {
                dp.getDataIOEditorData(data, jscallback);
            }
        });
        String inputvars = null;
        boolean hasInputVars = false;
        boolean isSingleInputVar = false;
        if (datainput != null) {
            inputvars = datainput;
            hasInputVars = true;
            isSingleInputVar = true;
        }
        if (datainputset != null) {
            inputvars = datainputset;
            hasInputVars = true;
            isSingleInputVar = false;
        }
        String outputvars = null;
        boolean hasOutputVars = false;
        boolean isSingleOutputVar = false;
        if (dataoutput != null) {
            outputvars = dataoutput;
            hasOutputVars = true;
            isSingleOutputVar = true;
        }
        if (dataoutputset != null) {
            outputvars = dataoutputset;
            hasOutputVars = true;
            isSingleOutputVar = false;
        }
        AssignmentData assignmentData = new AssignmentData(inputvars, outputvars, processvars, assignments, datatypes);
        this.activityDataIOEditor.setInputAssignmentRows(assignmentData.getAssignmentRows(Variable.VariableType.INPUT));
        this.activityDataIOEditor.setOutputAssignmentRows(assignmentData.getAssignmentRows(Variable.VariableType.OUTPUT));
        this.activityDataIOEditor.setDataTypes(assignmentData.getDataTypes(), assignmentData.getDataTypeDisplayNames());
        this.activityDataIOEditor.setProcessVariables(assignmentData.getProcessVariableNames());
        this.activityDataIOEditor.configureDialog(taskName, hasInputVars, isSingleInputVar, hasOutputVars, isSingleOutputVar);
        this.activityDataIOEditor.show();
    }

    private native void getDataIOEditorData(String var1, JavaScriptObject var2);

    public void assetRenameEvent(String uri) {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<ObservablePath>(){

            public void callback(ObservablePath mypath) {
                RenamePopup popup = new RenamePopup((Path)mypath, (Validator)DesignerPresenter.this.fileNameValidator, new CommandWithFileNameAndCommitMessage(){

                    public void execute(FileNameAndCommitMessage details) {
                        DesignerPresenter.this.baseView.showLoading();
                        ((RenameService)DesignerPresenter.this.renameService.call(DesignerPresenter.this.getRenameSuccessCallback(), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)DesignerPresenter.this.baseView))).rename((Path)DesignerPresenter.this.versionRecordManager.getPathToLatest(), details.getNewFileName(), details.getCommitMessage());
                    }
                });
                popup.show();
            }
        })).get(URIUtil.encode((String)uri));
    }

    private void refreshTitle() {
        this.baseView.refreshTitle(this.getTitleText());
    }

    public void assetDeleteEvent(String uri) {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(Path mypath) {
                ((DeleteService)DesignerPresenter.this.deleteService.call(DesignerPresenter.this.getDeleteSuccessCallback(mypath), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)DesignerPresenter.this.baseView))).delete(mypath, "");
            }
        })).get(URIUtil.encode((String)uri));
    }

    public boolean assetUpdatedEvent() {
        if (this.concurrentUpdateSessionInfo != null) {
            ConcurrentChangePopup.newConcurrentUpdate((Path)this.concurrentUpdateSessionInfo.getPath(), (User)this.concurrentUpdateSessionInfo.getIdentity(), (Command)new Command(){

                public void execute() {
                    DesignerPresenter.this.view.raiseEventSave();
                }
            }, (Command)new Command(){

                public void execute() {
                    DesignerPresenter.this.view.raiseEventSaveCancel();
                }
            }, (Command)new Command(){

                public void execute() {
                    DesignerPresenter.this.view.raiseEventReload();
                }
            }).show();
            this.concurrentUpdateSessionInfo = null;
            return true;
        }
        return false;
    }

    private RemoteCallback<Void> getDeleteSuccessCallback(final Path path) {
        return new RemoteCallback<Void>(){

            public void callback(Void response) {
                DesignerPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemDeletedSuccessfully()));
                DesignerPresenter.this.placeManager.forceClosePlace((PlaceRequest)new PathPlaceRequest(path));
            }
        };
    }

    private RemoteCallback<Path> getCopySuccessCallback() {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                DesignerPresenter.this.baseView.hideBusyIndicator();
                DesignerPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemCopiedSuccessfully()));
            }
        };
    }

    private RemoteCallback<Path> getRenameSuccessCallback() {
        return new RemoteCallback<Path>(){

            public void callback(Path path) {
                DesignerPresenter.this.baseView.hideBusyIndicator();
                DesignerPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemRenamedSuccessfully()));
                DesignerPresenter.this.placeManager.forceClosePlace(DesignerPresenter.this.place);
                DesignerPresenter.this.placeManager.goTo(path);
            }
        };
    }

    public void openInTab(String filename, String uri) {
        PathPlaceRequest placeRequestImpl = new PathPlaceRequest(PathFactory.newPathBasedOn((String)filename, (String)uri, (Path)this.versionRecordManager.getCurrentPath()));
        placeRequestImpl.addParameter("uuid", uri);
        placeRequestImpl.addParameter("profile", "jbpm");
        this.placeManager.goTo((PlaceRequest)placeRequestImpl);
    }

    public void openInXMLEditorTab(String uri) {
        ((VFSService)this.vfsServices.call((RemoteCallback)new RemoteCallback<Path>(){

            public void callback(Path mypath) {
                PathPlaceRequest placeRequestImpl = new PathPlaceRequest(mypath, "GuvnorTextEditor");
                DesignerPresenter.this.placeManager.forceClosePlace(DesignerPresenter.this.place);
                DesignerPresenter.this.placeManager.goTo((PlaceRequest)placeRequestImpl);
            }
        })).get(URIUtil.encode((String)uri));
    }

    private void disableMenus() {
    }

    protected void loadContent() {
        this.publishOpenInTab(this);
        this.publishOpenInXMLEditorTab(this);
        this.publishSignalOnAssetDelete(this);
        this.publishSignalOnAssetCopy(this);
        this.publishSignalOnAssetRename(this);
        this.publishSignalOnAssetUpdate(this);
        this.publishSignalOnAssetExpectConcurrentUpdate(this);
        this.publishClosePlace(this);
        this.publishShowDataIOEditor(this);
        if (this.versionRecordManager.getCurrentPath() != null) {
            ((DesignerAssetService)this.assetService.call((RemoteCallback)new RemoteCallback<String>(){

                public void callback(final String editorID) {
                    String url = GWT.getHostPageBaseURL().replaceFirst("/" + GWT.getModuleName() + "/", "");
                    ((DesignerAssetService)DesignerPresenter.this.assetService.call((RemoteCallback)new RemoteCallback<Map<String, String>>(){

                        public void callback(final Map<String, String> editorParameters) {
                            ((DesignerAssetService)DesignerPresenter.this.assetService.call((RemoteCallback)new RemoteCallback<DesignerContent>(){

                                public void callback(DesignerContent content) {
                                    DesignerPresenter.this.setup(editorParameters, editorID, content.getOverview());
                                }
                            })).loadContent((Path)DesignerPresenter.this.versionRecordManager.getCurrentPath());
                        }
                    }, (ErrorCallback)new CommandDrivenErrorCallback((HasBusyIndicator)DesignerPresenter.this.view, new CommandBuilder().addNoSuchFileException((HasBusyIndicator)DesignerPresenter.this.view, DesignerPresenter.this.menus).addFileSystemNotFoundException((HasBusyIndicator)DesignerPresenter.this.view, DesignerPresenter.this.menus).build()){

                        public boolean error(Message message, Throwable throwable) {
                            DesignerPresenter.this.placeManager.forceClosePlace(DesignerPresenter.this.place);
                            return super.error(message, throwable);
                        }
                    })).getEditorParameters((Path)DesignerPresenter.this.versionRecordManager.getCurrentPath(), editorID, url, DesignerPresenter.this.place);
                }
            })).getEditorID();
        }
    }

    private void setup(Map<String, String> editorParameters, String editorID, Overview overview) {
        if (editorParameters != null) {
            String activeNodes;
            this.resetEditorPages(overview);
            if (editorParameters.containsKey("readonly")) {
                this.isReadOnly = Boolean.valueOf(editorParameters.get("readonly"));
            }
            if (editorParameters.containsKey("processsource")) {
                String processSources = editorParameters.get("processsource");
                if (processSources != null && processSources.length() > 0) {
                    this.publishProcessSourcesInfo(editorParameters.get("processsource"));
                }
                editorParameters.remove("processsource");
            }
            if (editorParameters.containsKey("activenodes")) {
                activeNodes = editorParameters.get("activenodes");
                if (activeNodes != null && activeNodes.length() > 0) {
                    this.publishActiveNodesInfo(editorParameters.get("activenodes"));
                }
                editorParameters.remove("activenodes");
            }
            if (editorParameters.containsKey("completednodes")) {
                activeNodes = editorParameters.get("completednodes");
                if (activeNodes != null && activeNodes.length() > 0) {
                    this.publishCompletedNodesInfo(editorParameters.get("completednodes"));
                }
                editorParameters.remove("completednodes");
            }
            editorParameters.put("ts", Long.toString(System.currentTimeMillis()));
            editorParameters.put("sessionId", this.sessionInfo.getId());
            this.view.setup(editorID, editorParameters);
        }
    }

    protected void save() {
        this.view.raiseEventCheckSave();
    }

    public void reload() {
        this.concurrentUpdateSessionInfo = null;
        this.view.raiseEventReload();
    }
}

