/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.github.gwtbootstrap.client.ui.Button;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.widget.ListWidget;
import org.jboss.errai.ui.client.widget.Table;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.designer.client.popup.ActivityDataIOEditor;
import org.jbpm.designer.client.popup.AssignmentListItemWidget;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated(value="ActivityDataIOEditorWidget.html#widget")
public class ActivityDataIOEditorWidget
extends Composite {
    private static Set<String> hiddenPropertyNames = new HashSet<String>();
    ActivityDataIOEditor.ListBoxValues dataTypeListBoxValues;
    ActivityDataIOEditor.ListBoxValues processVarListBoxValues;
    private Variable.VariableType variableType = Variable.VariableType.INPUT;
    boolean isSingleVar = false;
    @Inject
    @DataField
    private Button addVarButton;
    @DataField
    private final Element table = DOM.createTable();
    @DataField
    private final Element tabletitle = DOM.createLabel();
    @DataField
    private final Element processvarorconstantth = DOM.createTH();
    @Inject
    @DataField
    @Table(root="tbody")
    private ListWidget<AssignmentRow, AssignmentListItemWidget> assignments;
    List<AssignmentRow> hiddenPropertyRows = new ArrayList<AssignmentRow>();
    @Inject
    private Event<NotificationEvent> notification;

    @PostConstruct
    public void init() {
        this.addVarButton.setText(DesignerEditorConstants.INSTANCE.Add());
    }

    public void setIsSingleVar(boolean isSingleVar) {
        this.isSingleVar = isSingleVar;
        if (this.variableType.equals((Object)Variable.VariableType.INPUT)) {
            this.processvarorconstantth.setInnerText(DesignerEditorConstants.INSTANCE.Source());
            if (isSingleVar) {
                this.tabletitle.setInnerText(DesignerEditorConstants.INSTANCE.Data_Input_and_Assignment());
            } else {
                this.tabletitle.setInnerText(DesignerEditorConstants.INSTANCE.Data_Inputs_and_Assignments());
            }
        } else {
            this.processvarorconstantth.setInnerText(DesignerEditorConstants.INSTANCE.Target());
            if (isSingleVar) {
                this.tabletitle.setInnerText(DesignerEditorConstants.INSTANCE.Data_Output_and_Assignment());
            } else {
                this.tabletitle.setInnerText(DesignerEditorConstants.INSTANCE.Data_Outputs_and_Assignments());
            }
        }
    }

    public void setVariableType(Variable.VariableType variableType) {
        this.variableType = variableType;
    }

    @EventHandler(value={"addVarButton"})
    public void handleAddVarButton(ClickEvent e) {
        if (this.isSingleVar && this.assignments.getValue().size() > 0) {
            this.notification.fire((Object)new NotificationEvent(DesignerEditorConstants.INSTANCE.Only_single_entry_allowed(), NotificationEvent.NotificationType.ERROR));
        } else {
            this.addAssignment();
        }
    }

    public void addAssignment() {
        List as = this.assignments.getValue();
        if (as.isEmpty()) {
            this.table.getStyle().setDisplay(Style.Display.TABLE);
        }
        AssignmentRow newAssignment = new AssignmentRow();
        newAssignment.setVariableType(this.variableType);
        as.add(newAssignment);
        AssignmentListItemWidget widget = (AssignmentListItemWidget)this.assignments.getWidget(this.assignments.getValue().size() - 1);
        widget.setDataTypes(this.dataTypeListBoxValues);
        widget.setProcessVariables(this.processVarListBoxValues);
        widget.setParentWidget(this);
    }

    public void removeAssignment(AssignmentRow assignmentRow) {
        this.assignments.getValue().remove(assignmentRow);
        if (this.assignments.getValue().isEmpty()) {
            this.table.getStyle().setDisplay(Style.Display.NONE);
        }
    }

    public void setData(List<AssignmentRow> assignmentRows) {
        int i;
        this.hiddenPropertyRows.clear();
        for (i = assignmentRows.size() - 1; i >= 0; --i) {
            AssignmentRow row = assignmentRows.get(i);
            if (row.getName() == null || row.getName().isEmpty() || !hiddenPropertyNames.contains(row.getName())) continue;
            assignmentRows.remove(i);
            this.hiddenPropertyRows.add(0, row);
        }
        if (assignmentRows.isEmpty()) {
            this.table.getStyle().setDisplay(Style.Display.NONE);
        } else {
            this.table.getStyle().setDisplay(Style.Display.TABLE);
        }
        this.assignments.setValue(assignmentRows);
        for (i = 0; i < assignmentRows.size(); ++i) {
            ((AssignmentListItemWidget)this.assignments.getWidget(i)).setParentWidget(this);
        }
    }

    public List<AssignmentRow> getData() {
        ArrayList<AssignmentRow> rows = new ArrayList<AssignmentRow>();
        if (!this.assignments.getValue().isEmpty()) {
            rows.addAll(this.assignments.getValue());
        }
        if (!this.hiddenPropertyRows.isEmpty()) {
            rows.addAll(this.hiddenPropertyRows);
        }
        return rows;
    }

    public Variable.VariableType getVariableType() {
        return this.variableType;
    }

    public void setDataTypes(ActivityDataIOEditor.ListBoxValues dataTypeListBoxValues) {
        this.dataTypeListBoxValues = dataTypeListBoxValues;
        for (int i = 0; i < this.assignments.getValue().size(); ++i) {
            ((AssignmentListItemWidget)this.assignments.getWidget(i)).setDataTypes(dataTypeListBoxValues);
        }
    }

    public void setProcessVariables(ActivityDataIOEditor.ListBoxValues processVarListBoxValues) {
        this.processVarListBoxValues = processVarListBoxValues;
        for (int i = 0; i < this.assignments.getValue().size(); ++i) {
            ((AssignmentListItemWidget)this.assignments.getWidget(i)).setProcessVariables(processVarListBoxValues);
        }
    }

    static {
        hiddenPropertyNames.add("GroupId");
        hiddenPropertyNames.add("Skippable");
        hiddenPropertyNames.add("Comment");
        hiddenPropertyNames.add("Description");
        hiddenPropertyNames.add("Priority");
        hiddenPropertyNames.add("Content");
        hiddenPropertyNames.add("TaskName");
        hiddenPropertyNames.add("Locale");
        hiddenPropertyNames.add("CreatedBy");
        hiddenPropertyNames.add("NotCompletedReassign");
        hiddenPropertyNames.add("NotStartedReassign");
        hiddenPropertyNames.add("NotCompletedNotify");
        hiddenPropertyNames.add("NotStartedNotify");
    }
}

