/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ValueListBox;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.marshalling.client.Marshalling;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidget;
import org.jbpm.designer.client.popup.AssignmentListItemWidget;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.AssignmentData;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;

@Dependent
public class ActivityDataIOEditor
extends BaseModal {
    GetDataCallback callback = null;
    boolean hasInputVars = true;
    boolean isSingleInputVar = false;
    boolean hasOutputVars = true;
    boolean isSingleOutputVar = false;
    @Inject
    private ActivityDataIOEditorWidget inputAssignmentsWidget;
    @Inject
    private ActivityDataIOEditorWidget outputAssignmentsWidget;
    private Button btnSave;
    private Button btnCancel;
    private List<String> dataTypes = new ArrayList<String>();
    private List<String> dataTypeDisplayNames = new ArrayList<String>();
    ListBoxValues dataTypeListBoxValues = new ListBoxValues();
    ListBoxValues processVarListBoxValues = new ListBoxValues();

    @PostConstruct
    public void init() {
        this.setTitle(DesignerEditorConstants.INSTANCE.Data_IO());
        this.inputAssignmentsWidget.setVariableType(Variable.VariableType.INPUT);
        this.add((Widget)this.inputAssignmentsWidget);
        this.outputAssignmentsWidget.setVariableType(Variable.VariableType.OUTPUT);
        this.add((Widget)this.outputAssignmentsWidget);
        this.btnSave = new Button(DesignerEditorConstants.INSTANCE.Save());
        this.btnSave.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ActivityDataIOEditor.this.callback != null) {
                    AssignmentData data = new AssignmentData(ActivityDataIOEditor.this.inputAssignmentsWidget.getData(), ActivityDataIOEditor.this.outputAssignmentsWidget.getData(), ActivityDataIOEditor.this.dataTypes, ActivityDataIOEditor.this.dataTypeDisplayNames);
                    String sData = Marshalling.toJSON((Object)data);
                    ActivityDataIOEditor.this.callback.getData(sData);
                }
                ActivityDataIOEditor.this.hide();
            }
        });
        this.add((Widget)this.btnSave);
        this.btnCancel = new Button(DesignerEditorConstants.INSTANCE.Cancel());
        this.btnCancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ActivityDataIOEditor.this.hide();
            }
        });
        this.add((Widget)this.btnCancel);
    }

    public void configureDialog(String taskName, boolean hasInputVars, boolean isSingleInputVar, boolean hasOutputVars, boolean isSingleOutputVar) {
        if (taskName != null && !taskName.isEmpty()) {
            this.setTitle(taskName + " " + DesignerEditorConstants.INSTANCE.Data_IO());
        } else {
            this.setTitle(DesignerEditorConstants.INSTANCE.Data_IO());
        }
        this.hasInputVars = hasInputVars;
        this.isSingleInputVar = isSingleInputVar;
        this.hasOutputVars = hasOutputVars;
        this.isSingleOutputVar = isSingleOutputVar;
        if (this.hasInputVars) {
            this.inputAssignmentsWidget.setVisible(true);
        } else {
            this.inputAssignmentsWidget.setVisible(false);
        }
        if (this.hasOutputVars) {
            this.outputAssignmentsWidget.setVisible(true);
        } else {
            this.outputAssignmentsWidget.setVisible(false);
        }
        this.inputAssignmentsWidget.setIsSingleVar(this.isSingleInputVar);
        this.outputAssignmentsWidget.setIsSingleVar(this.isSingleOutputVar);
    }

    public void onShow(Event e) {
        double width = (double)Window.getClientWidth() * 0.6;
        this.setWidth(width + "px");
        double maxHeight = (double)Window.getClientHeight() * 0.6;
        this.setMaxHeigth(maxHeight + "px");
        double widgetWidth = width - 25.0;
        if (this.inputAssignmentsWidget.isVisible()) {
            this.inputAssignmentsWidget.setWidth(widgetWidth + "px");
        }
        if (this.outputAssignmentsWidget.isVisible()) {
            this.outputAssignmentsWidget.setWidth(widgetWidth + "px");
        }
    }

    public void onHide(Event e) {
    }

    public void setCallback(GetDataCallback callback) {
        this.callback = callback;
    }

    public void setInputAssignmentRows(List<AssignmentRow> inputAssignmentRows) {
        this.inputAssignmentsWidget.setData(inputAssignmentRows);
    }

    public void setOutputAssignmentRows(List<AssignmentRow> outputAssignmentRows) {
        this.outputAssignmentsWidget.setData(outputAssignmentRows);
    }

    public void setDataTypes(List<String> dataTypes, List<String> dataTypeDisplayNames) {
        this.dataTypes = dataTypes;
        this.dataTypeDisplayNames = dataTypeDisplayNames;
        ArrayList<String> displayDataTypes = new ArrayList<String>();
        displayDataTypes.add("");
        displayDataTypes.add(AssignmentListItemWidget.CUSTOM_PROMPT);
        displayDataTypes.addAll(dataTypeDisplayNames);
        this.dataTypeListBoxValues.addValues(displayDataTypes);
        this.inputAssignmentsWidget.setDataTypes(this.dataTypeListBoxValues);
        this.outputAssignmentsWidget.setDataTypes(this.dataTypeListBoxValues);
    }

    public void setProcessVariables(List<String> processVariables) {
        ArrayList<String> displayProcessVariables = new ArrayList<String>();
        displayProcessVariables.add("");
        displayProcessVariables.add(AssignmentListItemWidget.CONSTANT_PROMPT);
        displayProcessVariables.addAll(processVariables);
        this.processVarListBoxValues.addValues(displayProcessVariables);
        this.inputAssignmentsWidget.setProcessVariables(this.processVarListBoxValues);
        this.outputAssignmentsWidget.setProcessVariables(this.processVarListBoxValues);
    }

    class ListBoxValues {
        List<String> acceptableValuesWithCustomValues = new ArrayList<String>();
        List<String> acceptableValuesWithoutCustomValues = new ArrayList<String>();
        List<String> customValues = new ArrayList<String>();

        ListBoxValues() {
        }

        void update(ValueListBox<String> listBox, boolean showCustomValues) {
            if (showCustomValues) {
                String currentValue = (String)listBox.getValue();
                String currentEditValuePrompt = this.getEditValuePrompt();
                String newEditValuePrompt = AssignmentListItemWidget.EDIT_PREFIX + currentValue + " ...";
                if (this.isCustomValue(currentValue)) {
                    int editPromptIndex;
                    if (newEditValuePrompt.equals(currentEditValuePrompt)) {
                        return;
                    }
                    if (currentEditValuePrompt != null) {
                        this.acceptableValuesWithCustomValues.remove(currentEditValuePrompt);
                    }
                    editPromptIndex = (editPromptIndex = this.acceptableValuesWithCustomValues.indexOf(currentValue)) > -1 ? ++editPromptIndex : (this.acceptableValuesWithCustomValues.size() > 1 ? 2 : this.acceptableValuesWithCustomValues.size());
                    this.acceptableValuesWithCustomValues.add(editPromptIndex, newEditValuePrompt);
                } else if (currentEditValuePrompt != null) {
                    this.acceptableValuesWithCustomValues.remove(currentEditValuePrompt);
                }
                listBox.setAcceptableValues(this.acceptableValuesWithCustomValues);
            } else {
                listBox.setAcceptableValues(this.acceptableValuesWithoutCustomValues);
            }
        }

        void addValues(List<String> acceptableValues) {
            this.clear();
            if (acceptableValues != null) {
                this.acceptableValuesWithCustomValues.addAll(acceptableValues);
                for (int i = 0; i < acceptableValues.size(); ++i) {
                    String value = acceptableValues.get(i);
                    if (this.acceptableValuesWithoutCustomValues.contains(value) || value.endsWith("...")) continue;
                    this.acceptableValuesWithoutCustomValues.add(value);
                }
            }
        }

        private void clear() {
            this.customValues.clear();
            this.acceptableValuesWithCustomValues.clear();
            this.acceptableValuesWithoutCustomValues.clear();
        }

        private String getEditValuePrompt() {
            if (this.acceptableValuesWithCustomValues.size() > 0) {
                for (int i = 0; i < this.acceptableValuesWithCustomValues.size(); ++i) {
                    String value = this.acceptableValuesWithCustomValues.get(i);
                    if (!value.startsWith(AssignmentListItemWidget.EDIT_PREFIX)) continue;
                    return value;
                }
            }
            return null;
        }

        void addValue(String newValue, String oldValue) {
            if (oldValue != null && !oldValue.isEmpty()) {
                if (this.acceptableValuesWithCustomValues.contains(oldValue)) {
                    this.acceptableValuesWithCustomValues.remove(oldValue);
                }
                if (this.customValues.contains(oldValue)) {
                    this.customValues.remove(oldValue);
                }
            }
            if (newValue != null && !newValue.isEmpty()) {
                if (!this.acceptableValuesWithCustomValues.contains(newValue)) {
                    int index = 1;
                    if (this.acceptableValuesWithCustomValues.size() < 1) {
                        index = this.acceptableValuesWithCustomValues.size();
                    }
                    this.acceptableValuesWithCustomValues.add(index, newValue);
                }
                if (!this.customValues.contains(newValue)) {
                    this.customValues.add(newValue);
                }
            }
        }

        boolean isCustomValue(String value) {
            if (value == null || value.isEmpty()) {
                return false;
            }
            return this.customValues.contains(value);
        }
    }

    public static interface GetDataCallback {
        public void getData(String var1);
    }
}

