/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.popup;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.ValueListBox;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.Composite;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.widget.HasModel;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.designer.client.popup.ActivityDataIOEditor;
import org.jbpm.designer.client.popup.ActivityDataIOEditorWidget;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.shared.AssignmentData;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;

@Templated(value="ActivityDataIOEditorWidget.html#assignment")
public class AssignmentListItemWidget
extends Composite
implements HasModel<AssignmentRow> {
    @Inject
    @AutoBound
    private DataBinder<AssignmentRow> assignment;
    @Inject
    @Bound
    @DataField
    private TextBox name;
    @DataField
    private ValueListBox<String> dataType = new ValueListBox((Renderer)new Renderer<String>(){

        public String render(String object) {
            String s = "";
            if (object != null) {
                s = object.toString();
            }
            return s;
        }

        public void render(String object, Appendable appendable) throws IOException {
            String s = this.render(object);
            appendable.append(s);
        }
    });
    @Inject
    @DataField
    private TextBox customDataType;
    @DataField
    private ValueListBox<String> processVar = new ValueListBox((Renderer)new Renderer<String>(){

        public String render(String object) {
            String s = "";
            if (object != null) {
                s = object.toString();
            }
            return s;
        }

        public void render(String object, Appendable appendable) throws IOException {
            String s = this.render(object);
            appendable.append(s);
        }
    });
    Map<ValueListBox<String>, ActivityDataIOEditor.ListBoxValues> mapListBoxToListBoxValues = new HashMap<ValueListBox<String>, ActivityDataIOEditor.ListBoxValues>();
    Map<ValueListBox<String>, Boolean> mapListBoxToShowCustomValues = new HashMap<ValueListBox<String>, Boolean>();
    Map<TextBox, String> mapTextBoxToCurrentValue = new HashMap<TextBox, String>();
    public static final String EDIT_PREFIX = DesignerEditorConstants.INSTANCE.Edit() + " ";
    public static final String EDIT_SUFFIX = " ...";
    public static final String CUSTOM_PROMPT = DesignerEditorConstants.INSTANCE.Custom() + " ...";
    public static final String ENTER_TYPE_PROMPT = DesignerEditorConstants.INSTANCE.Enter_type() + " ...";
    public static final String CONSTANT_PROMPT = DesignerEditorConstants.INSTANCE.Constant() + " ...";
    public static final String ENTER_CONSTANT_PROMPT = DesignerEditorConstants.INSTANCE.Enter_constant() + " ...";
    @Inject
    @DataField
    private TextBox constant;
    @Inject
    @DataField
    private Button deleteButton;
    private ActivityDataIOEditorWidget parentWidget;

    public void setParentWidget(ActivityDataIOEditorWidget parentWidget) {
        this.parentWidget = parentWidget;
    }

    private void initEditableListBox(final ValueListBox<String> listBox, final TextBox textBox, final boolean bQuoteStringValues, final String customPrompt, String placeholder) {
        textBox.setVisible(false);
        textBox.setPlaceholder(placeholder);
        listBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> valueChangeEvent) {
                String newValue = (String)valueChangeEvent.getValue();
                if (customPrompt.equals(newValue)) {
                    AssignmentListItemWidget.this.setModelValue((ValueListBox<String>)listBox, "");
                    AssignmentListItemWidget.this.setModelValue(textBox, "");
                    listBox.setVisible(false);
                    textBox.setVisible(true);
                    textBox.setFocus(true);
                } else if (newValue.startsWith("*")) {
                    AssignmentListItemWidget.this.setModelValue((ValueListBox<String>)listBox, "");
                    AssignmentListItemWidget.this.setModelValue(textBox, "");
                } else if (newValue.startsWith(EDIT_PREFIX)) {
                    String quotedValue = AssignmentListItemWidget.this.getModelValue((ValueListBox<String>)listBox);
                    String unquotedValue = AssignmentData.createUnquotedConstant(quotedValue);
                    AssignmentListItemWidget.this.setModelValue(textBox, unquotedValue);
                    listBox.setVisible(false);
                    textBox.setVisible(true);
                    textBox.setFocus(true);
                } else if (AssignmentListItemWidget.this.getListBoxValues((ValueListBox<String>)listBox).isCustomValue(newValue)) {
                    String textValue = newValue;
                    if (bQuoteStringValues) {
                        String unquotedValue;
                        textValue = unquotedValue = AssignmentData.createUnquotedConstant(newValue);
                    }
                    AssignmentListItemWidget.this.setModelValue((ValueListBox<String>)listBox, newValue);
                    AssignmentListItemWidget.this.setModelValue(textBox, textValue);
                } else if (newValue != null) {
                    AssignmentListItemWidget.this.setModelValue((ValueListBox<String>)listBox, newValue);
                    AssignmentListItemWidget.this.setModelValue(textBox, "");
                }
                AssignmentListItemWidget.this.updateListBoxValues((ValueListBox<String>)listBox);
            }
        });
        listBox.addDomHandler((com.google.gwt.event.shared.EventHandler)new FocusHandler(){

            public void onFocus(FocusEvent focusEvent) {
                AssignmentListItemWidget.this.updateListBoxValues((ValueListBox<String>)listBox);
            }
        }, FocusEvent.getType());
        textBox.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent focusEvent) {
                AssignmentListItemWidget.this.setCurrentTextValue(textBox, textBox.getValue());
            }
        });
        textBox.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent blurEvent) {
                String value = textBox.getValue();
                if (value != null) {
                    if (!bQuoteStringValues) {
                        value = value.trim();
                    }
                    if (!value.isEmpty()) {
                        String oldValue = AssignmentListItemWidget.this.getCurrentTextValue(textBox);
                        AssignmentListItemWidget.this.addValueToListBoxValues((ValueListBox<String>)listBox, value, oldValue, bQuoteStringValues);
                    }
                    if (bQuoteStringValues) {
                        value = AssignmentData.createQuotedConstant(value);
                    }
                    AssignmentListItemWidget.this.setModelValue(textBox, value);
                    AssignmentListItemWidget.this.setModelValue((ValueListBox<String>)listBox, value);
                    AssignmentListItemWidget.this.setCurrentTextValue(textBox, value);
                }
                textBox.setVisible(false);
                listBox.setVisible(true);
            }
        });
    }

    protected void updateListBoxValues(ValueListBox<String> listBox) {
        boolean showCustomValues = this.mapListBoxToShowCustomValues.get(listBox);
        this.getListBoxValues(listBox).update(listBox, showCustomValues);
    }

    protected String getCurrentTextValue(TextBox textBox) {
        String value = this.mapTextBoxToCurrentValue.get(textBox);
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected void setCurrentTextValue(TextBox textBox, String value) {
        if (value == null) {
            value = "";
        }
        this.mapTextBoxToCurrentValue.put(textBox, value);
    }

    protected ActivityDataIOEditor.ListBoxValues getListBoxValues(ValueListBox<String> listBox) {
        return this.mapListBoxToListBoxValues.get(listBox);
    }

    protected void addValueToListBoxValues(ValueListBox<String> listBox, String newValue, String oldValue, boolean bQuoteStringValues) {
        if (bQuoteStringValues) {
            newValue = AssignmentData.createQuotedConstant(newValue);
            oldValue = AssignmentData.createQuotedConstant(oldValue);
        }
        this.getListBoxValues(listBox).addValue(newValue, oldValue);
    }

    protected void setModelValue(TextBox textBox, String value) {
        textBox.setValue((Object)value);
        if (textBox == this.customDataType) {
            ((AssignmentRow)this.assignment.getModel()).setCustomDataType(value);
        } else if (textBox == this.constant) {
            ((AssignmentRow)this.assignment.getModel()).setConstant(value);
        }
    }

    protected void setModelValue(ValueListBox<String> listBox, String value) {
        listBox.setValue((Object)value);
        if (listBox == this.dataType) {
            ((AssignmentRow)this.assignment.getModel()).setDataType(value);
        } else if (listBox == this.processVar) {
            ((AssignmentRow)this.assignment.getModel()).setProcessVar(value);
        }
    }

    protected String getModelValue(ValueListBox<String> listBox) {
        if (listBox == this.dataType) {
            String value = ((AssignmentRow)this.assignment.getModel()).getCustomDataType();
            if (value == null || value.isEmpty()) {
                value = ((AssignmentRow)this.assignment.getModel()).getDataType();
            }
            return value;
        }
        if (listBox == this.processVar) {
            String value = ((AssignmentRow)this.assignment.getModel()).getConstant();
            if (value == null || value.isEmpty()) {
                value = ((AssignmentRow)this.assignment.getModel()).getProcessVar();
            }
            return value;
        }
        return "";
    }

    @PostConstruct
    private void init() {
        this.initEditableListBox(this.dataType, this.customDataType, false, CUSTOM_PROMPT, ENTER_TYPE_PROMPT);
        this.initEditableListBox(this.processVar, this.constant, true, CONSTANT_PROMPT, ENTER_CONSTANT_PROMPT);
        this.name.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent blurEvent) {
                String value = AssignmentListItemWidget.this.name.getValue();
                if (value != null) {
                    AssignmentListItemWidget.this.name.setValue((Object)value.trim());
                }
            }
        });
        this.name.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                int iChar = event.getNativeKeyCode();
                if (iChar == 32) {
                    event.preventDefault();
                }
            }
        });
        this.customDataType.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                int iChar = event.getNativeKeyCode();
                if (iChar == 32) {
                    event.preventDefault();
                }
            }
        });
    }

    @PreDestroy
    private void cleanUp() {
    }

    public AssignmentRow getModel() {
        return (AssignmentRow)this.assignment.getModel();
    }

    public void setModel(AssignmentRow model) {
        this.assignment.setModel((Object)model);
        this.initAssignmentControls();
    }

    public void setDataTypes(ActivityDataIOEditor.ListBoxValues dataTypeListBoxValues) {
        this.mapTextBoxToCurrentValue.put(this.customDataType, "");
        this.mapListBoxToListBoxValues.put(this.dataType, dataTypeListBoxValues);
        this.mapListBoxToShowCustomValues.put(this.dataType, true);
        String cdt = ((AssignmentRow)this.assignment.getModel()).getCustomDataType();
        if (cdt != null && !cdt.isEmpty()) {
            this.addValueToListBoxValues(this.dataType, cdt, "", false);
        }
    }

    public void setProcessVariables(ActivityDataIOEditor.ListBoxValues processVarListBoxValues) {
        this.mapTextBoxToCurrentValue.put(this.constant, "");
        this.mapListBoxToListBoxValues.put(this.processVar, processVarListBoxValues);
        boolean showCustomValues = false;
        if (((AssignmentRow)this.assignment.getModel()).getVariableType() == Variable.VariableType.INPUT) {
            showCustomValues = true;
        }
        this.mapListBoxToShowCustomValues.put(this.processVar, showCustomValues);
        String con = ((AssignmentRow)this.assignment.getModel()).getConstant();
        if (con != null && !con.isEmpty()) {
            this.addValueToListBoxValues(this.processVar, con, "", true);
        }
    }

    @EventHandler(value={"deleteButton"})
    public void handleDeleteButton(ClickEvent e) {
        this.parentWidget.removeAssignment((AssignmentRow)this.assignment.getModel());
    }

    private void initAssignmentControls() {
        String cdt;
        this.deleteButton.setIcon(IconType.REMOVE);
        if (((AssignmentRow)this.assignment.getModel()).getVariableType() == Variable.VariableType.OUTPUT) {
            this.constant.setVisible(false);
        }
        if ((cdt = ((AssignmentRow)this.assignment.getModel()).getCustomDataType()) != null && !cdt.isEmpty()) {
            this.customDataType.setValue((Object)cdt);
            this.dataType.setValue((Object)cdt);
        } else if (((AssignmentRow)this.assignment.getModel()).getDataType() != null) {
            this.dataType.setValue((Object)((AssignmentRow)this.assignment.getModel()).getDataType());
        }
        String con = ((AssignmentRow)this.assignment.getModel()).getConstant();
        if (con != null && !con.isEmpty()) {
            con = AssignmentData.createQuotedConstant(con);
            this.constant.setValue((Object)con);
            this.processVar.setValue((Object)con);
        } else if (((AssignmentRow)this.assignment.getModel()).getProcessVar() != null) {
            this.processVar.setValue((Object)((AssignmentRow)this.assignment.getModel()).getProcessVar());
        }
    }
}

