/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.shared;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jbpm.designer.client.shared.Assignment;
import org.jbpm.designer.client.shared.AssignmentRow;
import org.jbpm.designer.client.shared.Variable;
import org.jbpm.designer.client.shared.util.StringUtils;

@Portable
public class AssignmentData {
    private List<Variable> inputVariables = new ArrayList<Variable>();
    private List<Variable> outputVariables = new ArrayList<Variable>();
    private List<Variable> processVariables = new ArrayList<Variable>();
    private List<Assignment> assignments = new ArrayList<Assignment>();
    private List<String> dataTypes = new ArrayList<String>();
    private List<String> dataTypeDisplayNames = new ArrayList<String>();
    private Map<String, String> mapDisplayNameToDataType = new HashMap<String, String>();
    private Map<String, String> mapDataTypeToDisplayName = new HashMap<String, String>();
    private Map<String, String> mapSimpleDataTypeToDisplayName = new HashMap<String, String>();
    private List<String> disallowedPropertyNames = new ArrayList<String>();

    public AssignmentData() {
    }

    public AssignmentData(String sInputVariables, String sOutputVariables, String sProcessVariables, String sAssignments, String sDataTypes, String sDisallowedPropertyNames) {
        this.setDataTypes(sDataTypes);
        this.setProcessVariables(sProcessVariables);
        this.setInputVariables(sInputVariables);
        this.setOutputVariables(sOutputVariables);
        this.setAssignments(sAssignments);
        this.setDisallowedPropertyNames(sDisallowedPropertyNames);
    }

    public AssignmentData(List<AssignmentRow> inputAssignmentRows, List<AssignmentRow> outputAssignmentRows, List<String> dataTypes, List<String> dataTypeDisplayNames) {
        this.setDataTypes(dataTypes, dataTypeDisplayNames);
        if (inputAssignmentRows != null) {
            for (AssignmentRow row : inputAssignmentRows) {
                this.convertAssignmentRow(row);
            }
        }
        if (outputAssignmentRows != null) {
            for (AssignmentRow row : outputAssignmentRows) {
                this.convertAssignmentRow(row);
            }
        }
    }

    protected void convertAssignmentRow(AssignmentRow assignmentRow) {
        String processVarName;
        String constant;
        if (assignmentRow.getName() == null || assignmentRow.getName().isEmpty()) {
            return;
        }
        if (this.findVariable(assignmentRow.getName(), assignmentRow.getVariableType()) == null) {
            Variable var = new Variable(assignmentRow.getName(), assignmentRow.getVariableType(), this.getDataTypeFromDisplayName(assignmentRow.getDataType()), assignmentRow.getCustomDataType());
            this.addVariable(var);
        }
        if ((constant = assignmentRow.getConstant()) != null && !constant.isEmpty()) {
            processVarName = null;
            constant = StringUtils.createUnquotedConstant(constant);
        } else {
            processVarName = assignmentRow.getProcessVar();
            if (processVarName != null && !processVarName.isEmpty()) {
                HashSet<String> processVarsNames = new HashSet<String>();
                for (Variable var : this.processVariables) {
                    processVarsNames.add(var.getName());
                }
                if (!processVarsNames.contains(processVarName)) {
                    Variable processVar = new Variable(processVarName, Variable.VariableType.PROCESS, assignmentRow.getDataType(), assignmentRow.getCustomDataType());
                    this.processVariables.add(processVar);
                }
            }
        }
        if ((constant == null || constant.isEmpty()) && (processVarName == null || processVarName.isEmpty())) {
            return;
        }
        Assignment assignment = new Assignment(this, assignmentRow.getName(), assignmentRow.getVariableType(), processVarName, constant);
        this.assignments.add(assignment);
    }

    public List<Variable> getInputVariables() {
        return this.inputVariables;
    }

    public String getInputVariablesString() {
        return this.getStringForList(this.inputVariables);
    }

    public void setInputVariables(String sInputVariables) {
        this.inputVariables.clear();
        if (sInputVariables != null && !sInputVariables.isEmpty()) {
            String[] inputs;
            for (String input : inputs = sInputVariables.split(",")) {
                Variable var;
                if (input.isEmpty() || (var = Variable.deserialize(input, Variable.VariableType.INPUT, this.dataTypes)) == null || var.getName() == null || var.getName().isEmpty()) continue;
                this.inputVariables.add(var);
            }
        }
    }

    public List<Variable> getOutputVariables() {
        return this.outputVariables;
    }

    public String getOutputVariablesString() {
        return this.getStringForList(this.outputVariables);
    }

    public void setOutputVariables(String sOutputVariables) {
        this.outputVariables.clear();
        if (sOutputVariables != null && !sOutputVariables.isEmpty()) {
            String[] outputs;
            for (String output : outputs = sOutputVariables.split(",")) {
                Variable var;
                if (output.isEmpty() || (var = Variable.deserialize(output, Variable.VariableType.OUTPUT, this.dataTypes)) == null || var.getName() == null || var.getName().isEmpty()) continue;
                this.outputVariables.add(var);
            }
        }
    }

    public List<Variable> getProcessVariables() {
        return this.processVariables;
    }

    public String getProcessVariablesString() {
        return this.getStringForList(this.processVariables);
    }

    public void setProcessVariables(String sProcessVariables) {
        this.processVariables.clear();
        if (sProcessVariables != null && !sProcessVariables.isEmpty()) {
            String[] processVars;
            HashSet<String> procVarNames = new HashSet<String>();
            for (String processVar : processVars = sProcessVariables.split(",")) {
                Variable var;
                if (processVar.isEmpty() || (var = Variable.deserialize(processVar, Variable.VariableType.PROCESS, this.dataTypes)) == null || var.getName() == null || var.getName().isEmpty() || procVarNames.contains(var.getName())) continue;
                procVarNames.add(var.getName());
                this.processVariables.add(var);
            }
        }
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public String getAssignmentsString() {
        return this.getStringForList(this.assignments);
    }

    public void setAssignments(String sAssignments) {
        this.assignments.clear();
        if (sAssignments != null && !sAssignments.isEmpty()) {
            String[] as;
            for (String a : as = sAssignments.split(",")) {
                Assignment ass;
                if (a.isEmpty() || (ass = Assignment.deserialize(this, a)) == null || ass.getName() == null || ass.getName().isEmpty()) continue;
                this.assignments.add(ass);
            }
        }
    }

    public List<String> getDataTypes() {
        return this.dataTypes;
    }

    protected void setDataTypes(String dataTypes) {
        this.dataTypes.clear();
        this.dataTypeDisplayNames.clear();
        this.mapDisplayNameToDataType.clear();
        this.mapDataTypeToDisplayName.clear();
        this.mapSimpleDataTypeToDisplayName.clear();
        if (dataTypes != null && !dataTypes.isEmpty()) {
            String[] dts;
            for (String dt : dts = dataTypes.split(",")) {
                if ((dt = dt.trim()).isEmpty() || dt.startsWith("*")) continue;
                String dtName = "";
                String dtDisplayName = "";
                String dtSimpleType = "";
                if (dt.contains(":")) {
                    dtDisplayName = dt.substring(0, dt.indexOf(58)).trim();
                    dtName = dt.substring(dt.indexOf(58) + 1).trim();
                } else {
                    dtDisplayName = dt.trim();
                    dtName = dt.trim();
                }
                dtSimpleType = dtDisplayName.indexOf(32) > 0 ? dtDisplayName.substring(0, dtDisplayName.indexOf(32)) : dtDisplayName;
                if (!dtName.isEmpty()) {
                    this.dataTypeDisplayNames.add(dtDisplayName);
                    this.dataTypes.add(dtName);
                    this.mapDisplayNameToDataType.put(dtDisplayName, dtName);
                    this.mapDataTypeToDisplayName.put(dtName, dtDisplayName);
                }
                if (dtSimpleType.isEmpty()) continue;
                this.mapSimpleDataTypeToDisplayName.put(dtSimpleType, dtDisplayName);
            }
        }
    }

    protected void setDataTypes(List<String> dataTypes, List<String> dataTypeDisplayNames) {
        this.dataTypes.clear();
        this.dataTypeDisplayNames.clear();
        this.mapDisplayNameToDataType.clear();
        this.mapDataTypeToDisplayName.clear();
        this.mapSimpleDataTypeToDisplayName.clear();
        this.dataTypes = dataTypes;
        this.dataTypeDisplayNames = dataTypeDisplayNames;
        for (int i = 0; i < dataTypeDisplayNames.size(); ++i) {
            if (i < dataTypes.size()) {
                this.mapDisplayNameToDataType.put(dataTypeDisplayNames.get(i), dataTypes.get(i));
                this.mapDataTypeToDisplayName.put(dataTypes.get(i), dataTypeDisplayNames.get(i));
                continue;
            }
            this.mapDisplayNameToDataType.put(dataTypeDisplayNames.get(i), dataTypeDisplayNames.get(i));
            this.mapDataTypeToDisplayName.put(dataTypeDisplayNames.get(i), dataTypeDisplayNames.get(i));
        }
    }

    public List<String> getDisallowedPropertyNames() {
        return this.disallowedPropertyNames;
    }

    protected void setDisallowedPropertyNames(String disallowedPropertyNames) {
        this.disallowedPropertyNames.clear();
        if (disallowedPropertyNames != null && !disallowedPropertyNames.isEmpty()) {
            String[] hps;
            for (String hp : hps = disallowedPropertyNames.split(",")) {
                if ((hp = hp.trim()).isEmpty()) continue;
                this.disallowedPropertyNames.add(hp);
            }
        }
    }

    public Variable findProcessVariable(String processVarName) {
        if (processVarName == null || processVarName.isEmpty()) {
            return null;
        }
        for (Variable var : this.processVariables) {
            if (!processVarName.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    public Variable findVariable(String variableName, Variable.VariableType variableType) {
        block4: {
            block3: {
                if (variableName == null || variableName.isEmpty()) {
                    return null;
                }
                if (variableType != Variable.VariableType.INPUT) break block3;
                for (Variable var : this.inputVariables) {
                    if (!variableName.equals(var.getName())) continue;
                    return var;
                }
                break block4;
            }
            if (variableType != Variable.VariableType.OUTPUT) break block4;
            for (Variable var : this.outputVariables) {
                if (!variableName.equals(var.getName())) continue;
                return var;
            }
        }
        return null;
    }

    public void addVariable(Variable variable) {
        if (variable.getName() == null || variable.getName().isEmpty()) {
            return;
        }
        if (this.findVariable(variable.getName(), variable.getVariableType()) != null) {
            return;
        }
        if (variable.getVariableType() == Variable.VariableType.INPUT) {
            this.inputVariables.add(variable);
        } else if (variable.getVariableType() == Variable.VariableType.OUTPUT) {
            this.outputVariables.add(variable);
        } else if (variable.getVariableType() == Variable.VariableType.PROCESS) {
            this.processVariables.add(variable);
        }
    }

    public List<String> getDataTypeDisplayNames() {
        return this.dataTypeDisplayNames;
    }

    public String getDataTypeFromDisplayName(String dataTypeDisplayName) {
        if (this.mapDisplayNameToDataType.get(dataTypeDisplayName) != null) {
            return this.mapDisplayNameToDataType.get(dataTypeDisplayName);
        }
        return dataTypeDisplayName;
    }

    public String getDisplayNameFromDataType(String dataType) {
        if (this.mapDataTypeToDisplayName.get(dataType) != null) {
            return this.mapDataTypeToDisplayName.get(dataType);
        }
        return dataType;
    }

    public String getDataTypeDisplayNameForUserString(String userValue) {
        if (this.mapDataTypeToDisplayName.containsKey(userValue)) {
            return this.mapDataTypeToDisplayName.get(userValue);
        }
        if (this.mapSimpleDataTypeToDisplayName.containsKey(userValue)) {
            return this.mapSimpleDataTypeToDisplayName.get(userValue);
        }
        return null;
    }

    public String getDataTypesString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.dataTypes.size(); ++i) {
            String dataTypeDisplayName = this.dataTypes.get(i);
            String dataType = this.dataTypes.get(i);
            sb.append(dataTypeDisplayName).append(':').append(dataType).append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getDisallowedPropertyNamesString() {
        return this.getStringForList(this.disallowedPropertyNames);
    }

    public List<String> getProcessVariableNames() {
        ArrayList<String> processVarNames = new ArrayList<String>();
        for (Variable processVar : this.processVariables) {
            processVarNames.add(processVar.getName());
        }
        return processVarNames;
    }

    public List<AssignmentRow> getAssignmentRows(Variable.VariableType varType) {
        AssignmentRow row;
        ArrayList<AssignmentRow> rows = new ArrayList<AssignmentRow>();
        ArrayList<Variable> handledVariables = new ArrayList<Variable>();
        for (Assignment assignment : this.assignments) {
            if (assignment.getVariableType() != varType) continue;
            String dataType = this.getDisplayNameFromDataType(assignment.getDataType());
            row = new AssignmentRow(assignment.getName(), assignment.getVariableType(), dataType, assignment.getCustomDataType(), assignment.getProcessVarName(), assignment.getConstant());
            rows.add(row);
            handledVariables.add(assignment.getVariable());
        }
        List<Variable> vars = null;
        vars = varType == Variable.VariableType.INPUT ? this.inputVariables : this.outputVariables;
        for (Variable var : vars) {
            if (handledVariables.contains(var)) continue;
            row = new AssignmentRow(var.getName(), var.getVariableType(), var.getDataType(), var.getCustomDataType(), null, null);
            rows.add(row);
        }
        return rows;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"inputVariables\":\"").append(this.getInputVariablesString()).append("\"").append(",\n");
        sb.append("\"outputVariables\":\"").append(this.getOutputVariablesString()).append("\"").append(",\n");
        sb.append("\"processVariables\":\"").append(this.getProcessVariablesString()).append("\"").append(",\n");
        sb.append("\"assignments\":\"").append(this.getAssignmentsString()).append("\"").append(",\n");
        sb.append("\"dataTypes\":\"").append(this.getDataTypesString()).append("\"").append(",\n");
        sb.append("\"disallowedPropertyNames\":\"").append(this.getDisallowedPropertyNamesString()).append("\"");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssignmentData)) {
            return false;
        }
        AssignmentData that = (AssignmentData)o;
        if (this.getInputVariables() != null ? !this.getInputVariables().equals(that.getInputVariables()) : that.getInputVariables() != null) {
            return false;
        }
        if (this.getOutputVariables() != null ? !this.getOutputVariables().equals(that.getOutputVariables()) : that.getOutputVariables() != null) {
            return false;
        }
        if (this.getProcessVariables() != null ? !this.getProcessVariables().equals(that.getProcessVariables()) : that.getProcessVariables() != null) {
            return false;
        }
        if (this.getAssignments() != null ? !this.getAssignments().equals(that.getAssignments()) : that.getAssignments() != null) {
            return false;
        }
        if (this.getDataTypes() != null ? !this.getDataTypes().equals(that.getDataTypes()) : that.getDataTypes() != null) {
            return false;
        }
        if (this.getDataTypeDisplayNames() != null ? !this.getDataTypeDisplayNames().equals(that.getDataTypeDisplayNames()) : that.getDataTypeDisplayNames() != null) {
            return false;
        }
        return this.getDisallowedPropertyNames() != null ? this.getDisallowedPropertyNames().equals(that.getDisallowedPropertyNames()) : that.getDisallowedPropertyNames() == null;
    }

    public int hashCode() {
        int result = this.getInputVariables() != null ? this.getInputVariables().hashCode() : 0;
        result = 31 * result + (this.getOutputVariables() != null ? this.getOutputVariables().hashCode() : 0);
        result = 31 * result + (this.getProcessVariables() != null ? this.getProcessVariables().hashCode() : 0);
        result = 31 * result + (this.getAssignments() != null ? this.getAssignments().hashCode() : 0);
        result = 31 * result + (this.getDataTypes() != null ? this.getDataTypes().hashCode() : 0);
        result = 31 * result + (this.getDataTypeDisplayNames() != null ? this.getDataTypeDisplayNames().hashCode() : 0);
        result = 31 * result + (this.getDisallowedPropertyNames() != null ? this.getDisallowedPropertyNames().hashCode() : 0);
        return result;
    }

    private String getStringForList(List<? extends Object> objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object.toString()).append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

