/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import java.util.ArrayList;
import java.util.List;

public class ListBoxValues {
    protected List<String> acceptableValuesWithCustomValues = new ArrayList<String>();
    protected List<String> acceptableValuesWithoutCustomValues = new ArrayList<String>();
    protected List<String> customValues = new ArrayList<String>();
    protected String customPrompt;
    protected String editPrefix;
    public static final String EDIT_SUFFIX = " ...";
    ValueTester valueTester = null;

    public ListBoxValues(String customPrompt, String editPrefix, ValueTester valueTester) {
        this.customPrompt = customPrompt;
        this.editPrefix = editPrefix;
        this.valueTester = valueTester;
    }

    public String getEditPrefix() {
        return this.editPrefix;
    }

    public void addValues(List<String> acceptableValues) {
        this.clear();
        this.acceptableValuesWithoutCustomValues.addAll(acceptableValues);
        this.acceptableValuesWithCustomValues.add("");
        this.acceptableValuesWithCustomValues.add(this.customPrompt);
        this.acceptableValuesWithCustomValues.addAll(acceptableValues);
    }

    public void addCustomValue(String newValue, String oldValue) {
        if (oldValue != null && !oldValue.isEmpty()) {
            if (this.acceptableValuesWithCustomValues.contains(oldValue)) {
                this.acceptableValuesWithCustomValues.remove(oldValue);
            }
            if (this.customValues.contains(oldValue)) {
                this.customValues.remove(oldValue);
            }
        }
        if (newValue != null && !newValue.isEmpty()) {
            if (!this.acceptableValuesWithCustomValues.contains(newValue)) {
                int index = 1;
                if (this.acceptableValuesWithCustomValues.size() < 1) {
                    index = this.acceptableValuesWithCustomValues.size();
                }
                this.acceptableValuesWithCustomValues.add(index, newValue);
            }
            if (!this.customValues.contains(newValue)) {
                this.customValues.add(newValue);
            }
        }
    }

    public List<String> update(String currentValue) {
        String currentEditValuePrompt = this.getEditValuePrompt(this.editPrefix);
        String newEditValuePrompt = this.editPrefix + currentValue + EDIT_SUFFIX;
        if (this.isCustomValue(currentValue)) {
            int editPromptIndex;
            if (newEditValuePrompt.equals(currentEditValuePrompt)) {
                return this.acceptableValuesWithCustomValues;
            }
            if (currentEditValuePrompt != null) {
                this.acceptableValuesWithCustomValues.remove(currentEditValuePrompt);
            }
            editPromptIndex = (editPromptIndex = this.acceptableValuesWithCustomValues.indexOf(currentValue)) > -1 ? ++editPromptIndex : (this.acceptableValuesWithCustomValues.size() > 1 ? 2 : this.acceptableValuesWithCustomValues.size());
            this.acceptableValuesWithCustomValues.add(editPromptIndex, newEditValuePrompt);
        } else if (currentEditValuePrompt != null) {
            this.acceptableValuesWithCustomValues.remove(currentEditValuePrompt);
        }
        return this.acceptableValuesWithCustomValues;
    }

    public List<String> getAcceptableValuesWithCustomValues() {
        return this.acceptableValuesWithCustomValues;
    }

    public List<String> getAcceptableValuesWithoutCustomValues() {
        return this.acceptableValuesWithoutCustomValues;
    }

    public boolean isCustomValue(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return this.customValues.contains(value);
    }

    protected void clear() {
        this.customValues.clear();
        this.acceptableValuesWithCustomValues.clear();
        this.acceptableValuesWithoutCustomValues.clear();
    }

    protected String getEditValuePrompt(String editPrefix) {
        if (this.acceptableValuesWithCustomValues.size() > 0) {
            for (int i = 0; i < this.acceptableValuesWithCustomValues.size(); ++i) {
                String value = this.acceptableValuesWithCustomValues.get(i);
                if (!value.startsWith(editPrefix)) continue;
                return value;
            }
        }
        return null;
    }

    public String getNonCustomValueForUserString(String userValue) {
        if (this.valueTester != null) {
            return this.valueTester.getNonCustomValueForUserString(userValue);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("acceptableValuesWithoutCustomValues:\n");
        for (String value : this.acceptableValuesWithoutCustomValues) {
            sb.append('\t').append(value).append(",\n");
        }
        sb.append('\n');
        sb.append("acceptableValuesWithCustomValues:\n");
        for (String value : this.acceptableValuesWithCustomValues) {
            sb.append('\t').append(value).append(",\n");
        }
        return sb.toString();
    }

    public static interface ValueTester {
        public String getNonCustomValueForUserString(String var1);
    }
}

