/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.util;

import com.google.gwt.regexp.shared.RegExp;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.designer.client.util.AbstractValidatingTextBox;

public class DataIOEditorNameTextBox
extends AbstractValidatingTextBox {
    Set<String> invalidValues = null;
    boolean isCaseSensitive = false;
    String invalidValueErrorMessage = null;
    protected String invalidCharacterTypedMessage;
    protected String invalidCharactersInNameErrorMessage;
    protected RegExp regExp = null;

    public void setInvalidValues(Set<String> invalidValues, boolean isCaseSensitive, String invalidValueErrorMessage) {
        if (isCaseSensitive) {
            this.invalidValues = invalidValues;
        } else {
            this.invalidValues = new HashSet<String>();
            for (String value : invalidValues) {
                this.invalidValues.add(value.toLowerCase());
            }
        }
        this.isCaseSensitive = isCaseSensitive;
        this.invalidValueErrorMessage = invalidValueErrorMessage;
    }

    public void setRegExp(String pattern, String invalidCharactersInNameErrorMessage, String invalidCharacterTypedMessage) {
        this.regExp = RegExp.compile((String)pattern);
        this.invalidCharactersInNameErrorMessage = invalidCharactersInNameErrorMessage;
        this.invalidCharacterTypedMessage = invalidCharacterTypedMessage;
    }

    @Override
    public String isValidValue(String value, boolean isOnFocusLost) {
        boolean isValid;
        String err;
        if (this.invalidValues != null && !this.invalidValues.isEmpty() && isOnFocusLost && (err = this.testForInvalidValue(value)) != null && !err.isEmpty()) {
            return err;
        }
        if (this.regExp != null && !(isValid = this.regExp.test(value))) {
            String invalidChars = this.getInvalidCharsInName(value);
            return (isOnFocusLost ? this.invalidCharactersInNameErrorMessage : this.invalidCharacterTypedMessage) + ": " + invalidChars;
        }
        return null;
    }

    protected String testForInvalidValue(String value) {
        if (value == null || value.isEmpty() || this.invalidValues == null) {
            return null;
        }
        String testValue = !this.isCaseSensitive ? value.toLowerCase() : value;
        if (this.invalidValues.contains(testValue)) {
            return this.invalidValueErrorMessage;
        }
        return null;
    }

    @Override
    protected String makeValidValue(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        if (this.testForInvalidValue(value) != null) {
            return "";
        }
        StringBuilder validValue = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!this.isValidChar(c)) continue;
            validValue.append(c);
        }
        return validValue.toString();
    }

    protected String getInvalidCharsInName(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        StringBuilder invalidChars = new StringBuilder(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (this.isValidChar(c)) continue;
            invalidChars.append(c);
        }
        return invalidChars.toString();
    }

    protected boolean isValidChar(char c) {
        if (this.regExp != null) {
            return this.regExp.test("" + c);
        }
        return true;
    }
}

