/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.gwtbootstrap3.client.ui.Modal;
import org.jbpm.designer.client.DesignerWidgetPresenter;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

public class DesignerWidgetView
extends Composite
implements DesignerWidgetPresenter.View,
RequiresResize {
    private Frame inlineFrame = (Frame)GWT.create(Frame.class);
    private String editorID = "";
    private Map<String, String> editorParameters;
    private DesignerEditorConstants constants = DesignerEditorConstants.INSTANCE;

    public DesignerWidgetView() {
        this.setupInlineFrame();
        this.initWidget((Widget)this.inlineFrame);
    }

    private void setupInlineFrame() {
        this.inlineFrame.setWidth("85%");
        this.inlineFrame.setHeight("600");
        this.inlineFrame.getElement().setPropertyBoolean("webkitallowfullscreen", true);
        this.inlineFrame.getElement().setPropertyBoolean("mozallowfullscreen", true);
        this.inlineFrame.getElement().setPropertyBoolean("allowfullscreen", true);
        this.inlineFrame.getElement().getStyle().setBorderWidth(0.0, Style.Unit.PX);
        this.inlineFrame.getElement().getStyle().setOverflowX(Style.Overflow.AUTO);
        this.inlineFrame.getElement().getStyle().setOverflowY(Style.Overflow.AUTO);
        this.inlineFrame.getElement().getStyle().setOverflow(Style.Overflow.AUTO);
        this.inlineFrame.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.inlineFrame.getElement().getStyle().setHeight(680.0, Style.Unit.PX);
    }

    @Override
    public void setEditorID(String editorID) {
        this.editorID = editorID;
        this.inlineFrame.getElement().setId(editorID);
        this.inlineFrame.getElement().setAttribute("name", editorID);
    }

    @Override
    public void setEditorParamters(Map<String, String> editorParameters) {
        this.editorParameters = editorParameters;
        String locale = LocaleInfo.getCurrentLocale().getLocaleName();
        if (locale == null || locale.equals("default")) {
            locale = "en";
        }
        String paramsStr = "";
        for (String paramsKey : this.editorParameters.keySet()) {
            paramsStr = paramsStr + "&" + paramsKey + "=" + editorParameters.get(paramsKey);
        }
        paramsStr = paramsStr + "&ms=" + System.currentTimeMillis();
        this.inlineFrame.getElement().setAttribute("src", GWT.getModuleBaseURL() + "inlineeditor.jsp?locale=" + locale + paramsStr);
    }

    @Override
    public String getEditorID() {
        return this.editorID;
    }

    @Override
    public boolean confirmClose() {
        return Window.confirm((String)this.constants.ConfirmCloseBusinessProcessEditor());
    }

    public native void setProcessSaved(String var1);

    public native void turnOffValidation(String var1);

    public native boolean getIsReadOnly(String var1);

    public native boolean getIsViewLocked(String var1);

    public native void setProcessUnSaved(String var1);

    public native boolean canSaveDesignerModel(String var1);

    public native boolean isProcessValidating(String var1);

    public native void raiseEventSave(String var1);

    public native void raiseEventUpdate(String var1);

    public native void raiseEventCheckSave(boolean var1, String var2, String var3);

    public native void raiseAskOpenInXMLEditor(String var1);

    public native void raiseEventSaveCancel(String var1);

    public native void raiseEventUpdateLock(String var1);

    public native void raiseEventReload(String var1);

    public void onResize() {
        int height = this.getParent().getOffsetHeight();
        int width = this.getParent().getOffsetWidth();
        this.setPixelSize(width, height);
        this.inlineFrame.setWidth("100%");
        this.inlineFrame.setHeight(Math.max(0, height - 5) + "px");
    }

    public void setSize(int width, int height) {
        if (this.getParent().getParent().getParent() instanceof Modal) {
            Modal modal = (Modal)this.getParent().getParent().getParent();
            modal.setWidth(width + "px");
            modal.setHeight(height + "px");
            modal.getElement().getStyle().setMarginLeft((double)(width / 2 * -1), Style.Unit.PX);
            modal.getElement().getStyle().setMarginTop((double)(height / 2 * -1), Style.Unit.PX);
            this.getParent().getParent().removeStyleName("modal-body");
            super.setSize(width + "px", height - 51 + "px");
        }
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

