/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.client.handlers;

import com.google.gwt.core.client.Callback;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jbpm.designer.client.resources.i18n.DesignerEditorConstants;
import org.jbpm.designer.client.type.Bpmn2Type;
import org.jbpm.designer.service.DesignerAssetService;
import org.kie.workbench.common.profile.api.preferences.Profile;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewCaseDefinitionHandler
extends DefaultNewResourceHandler {
    private Caller<DesignerAssetService> designerAssetService;
    private Bpmn2Type resourceType;
    private TextBox caseIdPrefixTextBox = new TextBox();

    public NewCaseDefinitionHandler() {
    }

    @Inject
    public NewCaseDefinitionHandler(Caller<DesignerAssetService> designerAssetService, PlaceManager placeManager, Bpmn2Type resourceType) {
        this.designerAssetService = designerAssetService;
        this.placeManager = placeManager;
        this.resourceType = resourceType;
    }

    protected NewCaseDefinitionHandler(Caller<DesignerAssetService> designerAssetService, PlaceManager placeManager, Bpmn2Type resourceType, Event<NewResourceSuccessEvent> newResourceSuccessEvent) {
        this(designerAssetService, placeManager, resourceType);
        this.newResourceSuccessEvent = newResourceSuccessEvent;
    }

    public String getDescription() {
        return DesignerEditorConstants.INSTANCE.CaseDefinition();
    }

    public IsWidget getIcon() {
        return this.resourceType.getIcon();
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    @PostConstruct
    private void setupExtensions() {
        this.extensions.add(Pair.newPair((Object)DesignerEditorConstants.INSTANCE.CaseIdPrefix(), (Object)this.caseIdPrefixTextBox));
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        String caseIdPrefix = this.caseIdPrefixTextBox.getValue();
        this.caseIdPrefixTextBox.clear();
        ((DesignerAssetService)this.designerAssetService.call(path -> {
            presenter.complete();
            this.notifySuccess();
            this.newResourceSuccessEvent.fire((Object)new NewResourceSuccessEvent(path));
            this.placeManager.goTo(path);
        }, (ErrorCallback)new DefaultErrorCallback())).createCaseDefinition(pkg.getPackageMainResourcesPath(), this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType), caseIdPrefix);
    }

    public void acceptContext(Callback<Boolean, Void> callback) {
        if (this.context == null) {
            callback.onSuccess((Object)false);
        } else {
            Optional workspaceProject = this.context.getActiveWorkspaceProject();
            if (workspaceProject.isPresent()) {
                ((DesignerAssetService)this.designerAssetService.call(arg_0 -> callback.onSuccess(arg_0), (ErrorCallback)new DefaultErrorCallback())).isCaseProject(((WorkspaceProject)workspaceProject.get()).getRootPath());
            } else {
                callback.onSuccess((Object)false);
            }
        }
    }

    public List<Profile> getProfiles() {
        return Arrays.asList(Profile.FULL);
    }

    public boolean isProjectAsset() {
        return false;
    }
}

