/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import org.drools.KnowledgeBase;
import org.drools.SystemEventListenerFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.process.workitem.wsht.WSHumanTaskHandler;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;

public class EvaluationExample2 {
    public static final void main(String[] args) {
        try {
            KnowledgeBase kbase = EvaluationExample2.readKnowledgeBase();
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"test", (int)1000);
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new WSHumanTaskHandler());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("employee", "krisv");
            params.put("reason", "Yearly performance evaluation");
            ksession.startProcess("com.sample.evaluation", params);
            SystemEventListenerFactory.setSystemEventListener((org.drools.SystemEventListener)new SystemEventListener());
            TaskClient taskClient = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("MinaConnector", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
            taskClient.connect("127.0.0.1", 9123);
            Thread.sleep(1000L);
            BlockingTaskSummaryResponseHandler taskSummaryHandler = new BlockingTaskSummaryResponseHandler();
            taskClient.getTasksAssignedAsPotentialOwner("krisv", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryHandler);
            TaskSummary task1 = (TaskSummary)taskSummaryHandler.getResults().get(0);
            System.out.println("Krisv executing task " + task1.getName() + "(" + task1.getId() + ": " + task1.getDescription() + ")");
            BlockingTaskOperationResponseHandler taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.start(task1.getId(), "krisv", (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.complete(task1.getId(), "krisv", null, (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            Thread.sleep(1000L);
            taskSummaryHandler = new BlockingTaskSummaryResponseHandler();
            ArrayList<String> groups = new ArrayList<String>();
            groups.add("PM");
            taskClient.getTasksAssignedAsPotentialOwner("john", groups, "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryHandler);
            TaskSummary task2 = (TaskSummary)taskSummaryHandler.getResults().get(0);
            System.out.println("John executing task " + task2.getName() + "(" + task2.getId() + ": " + task2.getDescription() + ")");
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.claim(task2.getId(), "john", groups, (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.start(task2.getId(), "john", (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.complete(task2.getId(), "john", null, (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            Thread.sleep(1000L);
            taskSummaryHandler = new BlockingTaskSummaryResponseHandler();
            groups = new ArrayList();
            groups.add("HR");
            taskClient.getTasksAssignedAsPotentialOwner("mary", groups, "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryHandler);
            TaskSummary task3 = (TaskSummary)taskSummaryHandler.getResults().get(0);
            System.out.println("Mary delegating task " + task3.getName() + "(" + task3.getId() + ": " + task3.getDescription() + ") to krisv");
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.claim(task3.getId(), "mary", groups, (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.delegate(task3.getId(), "mary", "krisv", (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            System.out.println("Administrator delegating task back to mary");
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.delegate(task3.getId(), "Administrator", "mary", (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            taskSummaryHandler = new BlockingTaskSummaryResponseHandler();
            taskClient.getTasksAssignedAsPotentialOwner("mary", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryHandler);
            TaskSummary task3b = (TaskSummary)taskSummaryHandler.getResults().get(0);
            System.out.println("Mary executing task " + task3b.getName() + "(" + task3b.getId() + ": " + task3b.getDescription() + ")");
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.start(task3b.getId(), "mary", (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.complete(task3b.getId(), "mary", null, (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            Thread.sleep(1000L);
            logger.close();
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"evaluation/Evaluation2.bpmn"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }

    private static class SystemEventListener
    implements org.drools.SystemEventListener {
        private SystemEventListener() {
        }

        public void debug(String arg0) {
        }

        public void debug(String arg0, Object arg1) {
        }

        public void exception(Throwable arg0) {
        }

        public void exception(String arg0, Throwable arg1) {
        }

        public void info(String arg0) {
        }

        public void info(String arg0, Object arg1) {
        }

        public void warning(String arg0) {
        }

        public void warning(String arg0, Object arg1) {
        }
    }
}

