/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.humantask;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.KnowledgeBase;
import org.drools.SystemEventListenerFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.process.workitem.wsht.CommandBasedWSHumanTaskHandler;
import org.jbpm.task.AccessType;
import org.jbpm.task.User;
import org.jbpm.task.UserInfo;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.ContentData;
import org.jbpm.task.service.DefaultEscalatedDeadlineHandler;
import org.jbpm.task.service.DefaultUserInfo;
import org.jbpm.task.service.EscalatedDeadlineHandler;
import org.jbpm.task.service.TaskClient;
import org.jbpm.task.service.TaskClientConnector;
import org.jbpm.task.service.TaskClientHandler;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.mina.BaseMinaHandler;
import org.jbpm.task.service.mina.MinaTaskClientConnector;
import org.jbpm.task.service.mina.MinaTaskClientHandler;
import org.jbpm.task.service.mina.MinaTaskServer;
import org.jbpm.task.service.responsehandlers.BlockingTaskOperationResponseHandler;
import org.jbpm.task.service.responsehandlers.BlockingTaskSummaryResponseHandler;
import org.subethamail.wiser.Wiser;

public class HumanTaskDeadlineExample {
    private static Wiser wiser;

    public static final void main(String[] args) {
        try {
            HumanTaskDeadlineExample.setupTaskServer();
            KnowledgeBase kbase = HumanTaskDeadlineExample.readKnowledgeBase();
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)ksession);
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new CommandBasedWSHumanTaskHandler((KnowledgeRuntime)ksession));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userId", "krisv");
            params.put("s", "Need a new laptop computer");
            ksession.startProcess("UserTask", params);
            SystemEventListenerFactory.setSystemEventListener((org.drools.SystemEventListener)new SystemEventListener());
            TaskClient taskClient = new TaskClient((TaskClientConnector)new MinaTaskClientConnector("MinaConnector", (BaseMinaHandler)new MinaTaskClientHandler(SystemEventListenerFactory.getSystemEventListener())));
            taskClient.connect("127.0.0.1", 9123);
            Thread.sleep(1000L);
            Thread.sleep(6000L);
            Thread.sleep(4000L);
            BlockingTaskSummaryResponseHandler taskSummaryHandler = new BlockingTaskSummaryResponseHandler();
            taskClient.getTasksAssignedAsPotentialOwner("mike", "en-UK", (TaskClientHandler.TaskSummaryResponseHandler)taskSummaryHandler);
            TaskSummary task1 = (TaskSummary)taskSummaryHandler.getResults().get(0);
            BlockingTaskOperationResponseHandler taskOperationHandler = new BlockingTaskOperationResponseHandler();
            taskClient.start(task1.getId(), "mike", (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            taskOperationHandler = new BlockingTaskOperationResponseHandler();
            HashMap<String, String> results = new HashMap<String, String>();
            results.put("comment", "Agreed, existing laptop needs replacing");
            results.put("outcome", "Accept");
            ContentData contentData = new ContentData();
            contentData.setAccessType(AccessType.Inline);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(results);
                out.close();
                contentData = new ContentData();
                contentData.setContent(bos.toByteArray());
                contentData.setAccessType(AccessType.Inline);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            taskClient.complete(task1.getId(), "mike", contentData, (TaskClientHandler.TaskOperationResponseHandler)taskOperationHandler);
            taskOperationHandler.waitTillDone(1000L);
            Thread.sleep(1000L);
            logger.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        wiser.stop();
        System.exit(0);
    }

    private static KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"humantask/HumanTaskDeadline.bpmn"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }

    private static void setupTaskServer() throws InterruptedException {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.task");
        EscalatedDeadlineHandler handler = HumanTaskDeadlineExample.buildDeadlineHnadler();
        TaskService taskService = new TaskService(emf, SystemEventListenerFactory.getSystemEventListener(), handler);
        MinaTaskServer taskServer = new MinaTaskServer(taskService, 9123);
        Thread serverThread = new Thread((Runnable)taskServer);
        serverThread.start();
        Thread.sleep(1000L);
        TaskServiceSession taskSession = taskService.createSession();
        taskSession.addUser(new User("john"));
        taskSession.addUser(new User("mike"));
        taskSession.addUser(new User("Administrator"));
        taskSession.dispose();
    }

    protected static EscalatedDeadlineHandler buildDeadlineHnadler() {
        wiser = new Wiser();
        wiser.setHostname("localhost");
        wiser.setPort(2345);
        wiser.start();
        Properties emailProperties = new Properties();
        emailProperties.setProperty("from", "jbpm@domain.com");
        emailProperties.setProperty("replyTo", "jbpm@domain.com");
        emailProperties.setProperty("mail.smtp.host", "localhost");
        emailProperties.setProperty("mail.smtp.port", "2345");
        Properties userInfoProperties = new Properties();
        userInfoProperties.setProperty("john", "john@domain.com:en-UK:John");
        userInfoProperties.setProperty("mike", "mike@domain.com:en-UK:Mike");
        userInfoProperties.setProperty("Administrator", "admin@domain.com:en-UK:Admin");
        DefaultEscalatedDeadlineHandler handler = new DefaultEscalatedDeadlineHandler(emailProperties);
        handler.setUserInfo((UserInfo)new DefaultUserInfo(userInfoProperties));
        return handler;
    }

    private static class SystemEventListener
    implements org.drools.SystemEventListener {
        private SystemEventListener() {
        }

        public void debug(String arg0) {
        }

        public void debug(String arg0, Object arg1) {
        }

        public void exception(Throwable arg0) {
        }

        public void exception(String arg0, Throwable arg1) {
        }

        public void info(String arg0) {
        }

        public void info(String arg0, Object arg1) {
        }

        public void warning(String arg0) {
        }

        public void warning(String arg0, Object arg1) {
        }
    }
}

