/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.evaluation;

import java.util.HashMap;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.process.workitem.wsht.WSHumanTaskHandler;

public class EvaluationExample {
    public static final void main(String[] args) {
        try {
            KnowledgeBase kbase = EvaluationExample.readKnowledgeBase();
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            final KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"test", (int)1000);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (logger != null) {
                        logger.close();
                    }
                }
            });
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new WSHumanTaskHandler());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("employee", "krisv");
            params.put("reason", "Yearly performance evaluation");
            ksession.startProcess("com.sample.evaluation", params);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"evaluation/Evaluation.bpmn"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }
}

