/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.request;

import java.util.HashMap;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.event.process.DefaultProcessEventListener;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.process.ProcessStartedEvent;
import org.drools.io.ResourceFactory;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.runtime.rule.FactHandle;
import org.jbpm.examples.request.Person;
import org.jbpm.examples.request.Request;
import org.jbpm.examples.request.UIWorkItemHandler;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;

public class ProcessTest {
    public static final void main(String[] args) {
        try {
            KnowledgeBase kbase = ProcessTest.readKnowledgeBase();
            final StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"test", (int)1000);
            UIWorkItemHandler handler = new UIWorkItemHandler();
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
            handler.setVisible(true);
            ksession.getWorkItemManager().registerWorkItemHandler("Email", new WorkItemHandler(){

                public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                    System.out.println("Sending email ...");
                    manager.completeWorkItem(workItem.getId(), null);
                }

                public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                }
            });
            Person person = new Person("john", "John Doe");
            Request request = new Request("12345");
            request.setPersonId("john");
            request.setAmount(1000L);
            ksession.insert((Object)person);
            FactHandle handle = ksession.insert((Object)request);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("request", request.getId());
            WorkflowProcessInstance processInstance = (WorkflowProcessInstance)ksession.startProcess("com.sample.requestHandling", params);
            ksession.insert((Object)processInstance);
            ksession.fireAllRules();
            ksession.signalEvent("Investigate", null, processInstance.getId());
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newClassPathResource((String)"request/adhoc.drl"), ResourceType.DRL);
            kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
            ksession.fireAllRules();
            DynamicNodeInstance dynamicNodeInstance = (DynamicNodeInstance)processInstance.getNodeInstances().iterator().next();
            DynamicUtils.addDynamicSubProcess((DynamicNodeInstance)dynamicNodeInstance, (KnowledgeRuntime)ksession, (String)"com.sample.contactCustomer", null);
            logger.close();
            ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

                public void beforeProcessStarted(ProcessStartedEvent event) {
                    ksession.insert((Object)event);
                }
            });
            ksession.startProcess("com.sample.requestHandling");
            ksession.fireAllRules();
            ksession.startProcess("com.sample.requestHandling");
            ksession.fireAllRules();
            ksession.startProcess("com.sample.requestHandling");
            ksession.fireAllRules();
            ksession.startProcess("com.sample.requestHandling");
            ksession.fireAllRules();
            ksession.startProcess("com.sample.requestHandling");
            ksession.fireAllRules();
            request.setCanceled(true);
            ksession.update(handle, (Object)request);
            ksession.fireAllRules();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"request/requestHandling.bpmn"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"request/contactCustomer.bpmn"), ResourceType.BPMN2);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"request/validation.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"request/eventProcessing.drl"), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"request/exceptions.drl"), ResourceType.DRL);
        return kbuilder.newKnowledgeBase();
    }
}

