/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.process.workitem.wsht.HornetQHTWorkItemHandler;
import org.jbpm.task.AsyncTaskService;
import org.jbpm.task.query.TaskSummary;
import org.jbpm.task.service.SyncTaskServiceWrapper;
import org.jbpm.task.service.hornetq.AsyncHornetQTaskClient;
import org.kie.KnowledgeBase;
import org.kie.SystemEventListenerFactory;
import org.kie.builder.KnowledgeBuilder;
import org.kie.builder.KnowledgeBuilderFactory;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.io.ResourceFactory;
import org.kie.io.ResourceType;
import org.kie.logger.KnowledgeRuntimeLogger;
import org.kie.logger.KnowledgeRuntimeLoggerFactory;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItemHandler;

public class EvaluationExample2 {
    public static final void main(String[] args) {
        try {
            KnowledgeBase kbase = EvaluationExample2.readKnowledgeBase();
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            KnowledgeRuntimeLogger logger = KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)ksession, (String)"test", (int)1000);
            HornetQHTWorkItemHandler hornetQHTWorkItemHandler = new HornetQHTWorkItemHandler((KnowledgeRuntime)ksession);
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)hornetQHTWorkItemHandler);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("employee", "krisv");
            params.put("reason", "Yearly performance evaluation");
            ksession.startProcess("com.sample.evaluation", params);
            SystemEventListenerFactory.setSystemEventListener((org.kie.SystemEventListener)new SystemEventListener());
            SyncTaskServiceWrapper taskClient = new SyncTaskServiceWrapper((AsyncTaskService)new AsyncHornetQTaskClient("EvaluationExample2-testClient"));
            taskClient.connect("127.0.0.1", 5153);
            Thread.sleep(1000L);
            TaskSummary task1 = (TaskSummary)taskClient.getTasksAssignedAsPotentialOwner("krisv", "en-UK").get(0);
            System.out.println("Krisv executing task " + task1.getName() + "(" + task1.getId() + ": " + task1.getDescription() + ")");
            taskClient.start(task1.getId(), "krisv");
            taskClient.complete(task1.getId(), "krisv", null);
            Thread.sleep(1000L);
            ArrayList<String> groups = new ArrayList<String>();
            groups.add("PM");
            TaskSummary task2 = (TaskSummary)taskClient.getTasksAssignedAsPotentialOwner("john", groups, "en-UK").get(0);
            System.out.println("John executing task " + task2.getName() + "(" + task2.getId() + ": " + task2.getDescription() + ")");
            taskClient.claim(task2.getId(), "john", groups);
            taskClient.start(task2.getId(), "john");
            taskClient.complete(task2.getId(), "john", null);
            Thread.sleep(1000L);
            groups = new ArrayList();
            groups.add("HR");
            TaskSummary task3 = (TaskSummary)taskClient.getTasksAssignedAsPotentialOwner("mary", groups, "en-UK").get(0);
            System.out.println("Mary delegating task " + task3.getName() + "(" + task3.getId() + ": " + task3.getDescription() + ") to krisv");
            taskClient.claim(task3.getId(), "mary", groups);
            taskClient.delegate(task3.getId(), "mary", "krisv");
            System.out.println("Administrator delegating task back to mary");
            taskClient.delegate(task3.getId(), "Administrator", "mary");
            Thread.sleep(1000L);
            TaskSummary task3b = (TaskSummary)taskClient.getTasksAssignedAsPotentialOwner("mary", "en-UK").get(0);
            System.out.println("Mary executing task " + task3b.getName() + "(" + task3b.getId() + ": " + task3b.getDescription() + ")");
            taskClient.start(task3b.getId(), "mary");
            taskClient.complete(task3b.getId(), "mary", null);
            taskClient.disconnect();
            hornetQHTWorkItemHandler.dispose();
            Thread.sleep(1000L);
            logger.close();
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"evaluation/Evaluation2.bpmn"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }

    private static class SystemEventListener
    implements org.kie.SystemEventListener {
        private SystemEventListener() {
        }

        public void debug(String arg0) {
        }

        public void debug(String arg0, Object arg1) {
        }

        public void exception(Throwable arg0) {
        }

        public void exception(String arg0, Throwable arg1) {
        }

        public void info(String arg0) {
        }

        public void info(String arg0, Object arg1) {
        }

        public void warning(String arg0) {
        }

        public void warning(String arg0, Object arg1) {
        }
    }
}

