/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.checklist.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.jbpm.examples.checklist.ChecklistContextConstraint;
import org.jbpm.examples.checklist.ChecklistItem;
import org.jbpm.examples.checklist.ChecklistManager;
import org.jbpm.examples.checklist.impl.CreateItemDialog;
import org.jbpm.examples.checklist.impl.DefaultChecklistManager;
import org.jbpm.runtime.manager.impl.DefaultRuntimeEnvironment;
import org.jbpm.test.JBPMHelper;
import org.kie.api.io.ResourceType;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.RuntimeEnvironment;
import org.kie.internal.task.api.UserGroupCallback;

public class ChecklistUI
extends JFrame {
    private static final long serialVersionUID = 510L;
    private static ImageIcon[] ICONS = new ImageIcon[]{new ImageIcon(ChecklistUI.class.getResource("/checklist/check32.png")), new ImageIcon(ChecklistUI.class.getResource("/checklist/inprogress32.png")), new ImageIcon(ChecklistUI.class.getResource("/checklist/abort32.png"))};
    private ChecklistManager checklistManager;
    List<ChecklistItem> items = null;
    private JComboBox contexts;
    private JTable itemTable;
    private JTextField userNameTextField;

    public ChecklistUI() {
        this.setSize(new Dimension(400, 300));
        this.setTitle("Checklist");
        this.setDefaultCloseOperation(3);
        this.initializeComponent();
        JBPMHelper.startH2Server();
        JBPMHelper.setupDataSource();
        DefaultRuntimeEnvironment environment = new DefaultRuntimeEnvironment();
        environment.setUserGroupCallback(new UserGroupCallback(){

            public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
                ArrayList<String> result = new ArrayList<String>();
                if ("actor4".equals(userId)) {
                    result.add("group1");
                }
                return result;
            }

            public boolean existsUser(String arg0) {
                return true;
            }

            public boolean existsGroup(String arg0) {
                return true;
            }
        });
        environment.addAsset(ResourceFactory.newClassPathResource((String)"checklist/SampleChecklistProcess.bpmn"), ResourceType.BPMN2);
        this.checklistManager = new DefaultChecklistManager((RuntimeEnvironment)environment);
    }

    private void initializeComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.getRootPane().setLayout(new BorderLayout());
        this.getRootPane().add((Component)panel, "Center");
        JButton createButton = new JButton("Create");
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChecklistUI.this.create();
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        panel.add((Component)createButton, c);
        this.contexts = new JComboBox();
        this.contexts.setPreferredSize(new Dimension(80, 24));
        this.contexts.setSize(new Dimension(80, 24));
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.contexts, c);
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChecklistUI.this.refresh();
            }
        });
        c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)refreshButton, c);
        this.itemTable = new JTable(1, 5);
        this.itemTable.setRowHeight(30);
        this.itemTable.setShowHorizontalLines(false);
        this.itemTable.setShowVerticalLines(false);
        this.itemTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = e.getFirstIndex();
                if (index >= 0) {
                    ChecklistItem item = ChecklistUI.this.items.get(index);
                    if (item.getStatus() == ChecklistItem.Status.Created) {
                        String actorId = ChecklistUI.this.getActorId();
                        try {
                            ChecklistUI.this.checklistManager.claimTask(actorId, item.getTaskId());
                            ChecklistUI.this.checklistManager.completeTask(actorId, item.getTaskId());
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        ChecklistUI.this.refresh();
                    } else if (item.getStatus() == ChecklistItem.Status.Reserved) {
                        String actorId = ChecklistUI.this.getActorId();
                        if (item.getActors().equals(actorId)) {
                            try {
                                ChecklistUI.this.checklistManager.completeTask(actorId, item.getTaskId());
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            ChecklistUI.this.refresh();
                        }
                    }
                }
            }
        });
        c = new GridBagConstraints();
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.itemTable, c);
        JLabel nameLabel = new JLabel("Logged in as:");
        c = new GridBagConstraints();
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        panel.add((Component)nameLabel, c);
        this.userNameTextField = new JTextField("actor1");
        this.userNameTextField.setPreferredSize(new Dimension(80, 20));
        this.userNameTextField.setSize(new Dimension(80, 20));
        c = new GridBagConstraints();
        c.gridy = 2;
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 17;
        panel.add((Component)this.userNameTextField, c);
        JButton createItemButton = new JButton("+");
        createItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ChecklistUI.this.createNewItem();
            }
        });
        c = new GridBagConstraints();
        c.gridy = 2;
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 13;
        panel.add((Component)createItemButton, c);
        panel.doLayout();
    }

    private String getActorId() {
        return this.userNameTextField.getText();
    }

    private void refresh() {
        Long processInstanceId = this.getSelectedProcessInstance();
        if (processInstanceId != null) {
            List<ChecklistContextConstraint> contexts = null;
            this.items = this.checklistManager.getTasks(processInstanceId, contexts);
        } else {
            this.items = new ArrayList<ChecklistItem>();
        }
        DefaultTableModel tableModel = new DefaultTableModel(this.items.size(), 4);
        for (int i = 0; i < this.items.size(); ++i) {
            ChecklistItem item = this.items.get(i);
            String orderingNb = item.getOrderingNb();
            if (orderingNb == null) {
                orderingNb = "";
            } else if (orderingNb.endsWith("+")) {
                orderingNb = "*";
            }
            tableModel.setValueAt((Object)item.getStatus(), i, 0);
            tableModel.setValueAt("(" + orderingNb + ")", i, 1);
            tableModel.setValueAt(item.getName(), i, 2);
            tableModel.setValueAt(item.getActors(), i, 3);
        }
        this.itemTable.setModel(tableModel);
        this.itemTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 6L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel label = new JLabel();
                if (value != null) {
                    label.setHorizontalAlignment(0);
                    switch ((ChecklistItem.Status)((Object)value)) {
                        case Completed: {
                            label.setIcon(ICONS[0]);
                            break;
                        }
                        case Aborted: {
                            label.setIcon(ICONS[2]);
                            break;
                        }
                        case InProgress: {
                            label.setIcon(ICONS[1]);
                            break;
                        }
                        case Created: {
                            label.setIcon(ICONS[1]);
                            break;
                        }
                        case Reserved: {
                            label.setIcon(ICONS[1]);
                            break;
                        }
                        case Pending: {
                            break;
                        }
                    }
                }
                return label;
            }
        });
        this.itemTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.itemTable.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.itemTable.getColumnModel().getColumn(2).setPreferredWidth(230);
        this.itemTable.getColumnModel().getColumn(3).setPreferredWidth(120);
    }

    private void create() {
        long processInstanceId = this.checklistManager.createContext("org.jbpm.examples.checklist.sample1");
        String contextName = processInstanceId + "";
        this.contexts.addItem(contextName);
        this.contexts.setSelectedItem(contextName);
        this.refresh();
    }

    private Long getSelectedProcessInstance() {
        Object selected = this.contexts.getSelectedItem();
        if (selected != null) {
            try {
                return new Long((String)selected);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private void createNewItem() {
        if (this.getSelectedProcessInstance() != null) {
            CreateItemDialog dialog = new CreateItemDialog(this, this.getActorId());
            dialog.setVisible(true);
            String name = dialog.getItemName();
            if (name != null) {
                ChecklistItem item = this.getSelectedItem();
                String orderingNb = null;
                orderingNb = item != null ? item.getOrderingNb() + "+" : this.items.get(this.items.size() - 1).getOrderingNb() + "+";
                String[] actors = null;
                String actorIds = dialog.getActors();
                actors = actorIds.trim().length() == 0 ? new String[]{} : actorIds.split(",");
                String[] groups = null;
                String groupIds = dialog.getGroups();
                groups = groupIds.trim().length() == 0 ? new String[]{} : groupIds.split(",");
                this.checklistManager.addTask(dialog.getActors(), actors, groups, name, orderingNb, this.getSelectedProcessInstance());
                this.refresh();
            }
        }
    }

    private ChecklistItem getSelectedItem() {
        int index = this.itemTable.getSelectedRow();
        if (index >= 0) {
            return this.items.get(index);
        }
        return null;
    }

    public static void main(String[] args) {
        new ChecklistUI().setVisible(true);
    }
}

