/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.test.JBPMHelper;
import org.kie.api.KieServices;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;

public class EvaluationExample2 {
    public static final void main(String[] args) {
        try {
            RuntimeManager manager = EvaluationExample2.getRuntimeManager("evaluation/Evaluation2.bpmn");
            RuntimeEngine runtime = manager.getRuntimeEngine(null);
            KieSession ksession = runtime.getKieSession();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("employee", "krisv");
            params.put("reason", "Yearly performance evaluation");
            ksession.startProcess("com.sample.evaluation", params);
            TaskService taskService = runtime.getTaskService();
            TaskSummary task1 = (TaskSummary)taskService.getTasksAssignedAsPotentialOwner("krisv", "en-UK").get(0);
            System.out.println("Krisv executing task " + task1.getName() + "(" + task1.getId() + ": " + task1.getDescription() + ")");
            taskService.start(task1.getId().longValue(), "krisv");
            taskService.complete(task1.getId().longValue(), "krisv", null);
            TaskSummary task2 = (TaskSummary)taskService.getTasksAssignedAsPotentialOwner("john", "en-UK").get(0);
            System.out.println("John executing task " + task2.getName() + "(" + task2.getId() + ": " + task2.getDescription() + ")");
            System.out.println(taskService.getTasksAssignedAsPotentialOwner("john", "en-UK").size());
            taskService.claim(task2.getId().longValue(), "john");
            taskService.start(task2.getId().longValue(), "john");
            taskService.complete(task2.getId().longValue(), "john", null);
            TaskSummary task3 = (TaskSummary)taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK").get(0);
            System.out.println("Mary delegating task " + task3.getName() + "(" + task3.getId() + ": " + task3.getDescription() + ") to krisv");
            taskService.claim(task3.getId().longValue(), "mary");
            taskService.delegate(task3.getId().longValue(), "mary", "krisv");
            System.out.println("Administrator delegating task back to mary");
            taskService.delegate(task3.getId().longValue(), "Administrator", "mary");
            TaskSummary task3b = (TaskSummary)taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK").get(0);
            System.out.println("Mary executing task " + task3b.getName() + "(" + task3b.getId() + ": " + task3b.getDescription() + ")");
            taskService.start(task3b.getId().longValue(), "mary");
            taskService.complete(task3b.getId().longValue(), "mary", null);
            System.out.println("Process instance completed");
            manager.disposeRuntimeEngine(runtime);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(0);
    }

    private static RuntimeManager getRuntimeManager(String process) {
        JBPMHelper.startH2Server();
        JBPMHelper.setupDataSource();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback(new UserGroupCallback(){

            public List<String> getGroupsForUser(String userId, List<String> groupIds, List<String> allExistingGroupIds) {
                ArrayList<String> result = new ArrayList<String>();
                if ("mary".equals(userId)) {
                    result.add("HR");
                } else if ("john".equals(userId)) {
                    result.add("PM");
                }
                return result;
            }

            public boolean existsUser(String arg0) {
                return true;
            }

            public boolean existsGroup(String arg0) {
                return true;
            }
        }).addAsset(KieServices.Factory.get().getResources().newClassPathResource(process), ResourceType.BPMN2).get();
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
    }
}

