/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.NoResultException;
import org.drools.core.command.impl.GenericCommand;
import org.jbpm.shared.services.impl.JpaPersistenceContext;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.FindObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.internal.command.Context;
import org.kie.internal.executor.api.ErrorInfo;
import org.kie.internal.executor.api.ExecutorQueryService;
import org.kie.internal.executor.api.RequestInfo;
import org.kie.internal.executor.api.STATUS;

public class ExecutorQueryServiceImpl
implements ExecutorQueryService {
    @Inject
    private TransactionalCommandService commandService;

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public List<RequestInfo> getPendingRequests() {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("now", new Date());
        return (List)this.commandService.execute((Command)new QueryNameCommand("PendingRequests", params));
    }

    public List<RequestInfo> getPendingRequestById(Long id) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", id);
        return (List)this.commandService.execute((Command)new QueryNameCommand("PendingRequestById", params));
    }

    public RequestInfo getRequestById(Long id) {
        return (RequestInfo)this.commandService.execute((Command)new FindObjectCommand((Object)id, org.jbpm.executor.entities.RequestInfo.class));
    }

    public List<RequestInfo> getRunningRequests() {
        return (List)this.commandService.execute((Command)new QueryNameCommand("RunningRequests"));
    }

    public List<RequestInfo> getQueuedRequests() {
        return (List)this.commandService.execute((Command)new QueryNameCommand("QueuedRequests"));
    }

    public List<RequestInfo> getFutureQueuedRequests() {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("now", new Date());
        return (List)this.commandService.execute((Command)new QueryNameCommand("FutureQueuedRequests", params));
    }

    public List<RequestInfo> getCompletedRequests() {
        return (List)this.commandService.execute((Command)new QueryNameCommand("CompletedRequests"));
    }

    public List<RequestInfo> getInErrorRequests() {
        return (List)this.commandService.execute((Command)new QueryNameCommand("InErrorRequests"));
    }

    public List<RequestInfo> getCancelledRequests() {
        return (List)this.commandService.execute((Command)new QueryNameCommand("CancelledRequests"));
    }

    public List<ErrorInfo> getAllErrors() {
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetAllErrors"));
    }

    public List<ErrorInfo> getErrorsByRequestId(Long requestId) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("id", requestId);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetErrorsByRequestId", params));
    }

    public List<RequestInfo> getAllRequests() {
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetAllRequests"));
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        HashMap<String, List<STATUS>> params = new HashMap<String, List<STATUS>>();
        params.put("statuses", statuses);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByStatus", params));
    }

    public List<RequestInfo> getRequestByBusinessKey(String businessKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("businessKey", businessKey);
        return (List)this.commandService.execute((Command)new QueryNameCommand("GetRequestsByBusinessKey", params));
    }

    public RequestInfo getRequestForProcessing() {
        RequestInfo request = (RequestInfo)this.commandService.execute((Command)new LockAndUpdateRequestInfoCommand());
        return request;
    }

    private class LockAndUpdateRequestInfoCommand
    implements GenericCommand<RequestInfo> {
        private static final long serialVersionUID = 8670412133363766161L;

        private LockAndUpdateRequestInfoCommand() {
        }

        public RequestInfo execute(Context context) {
            HashMap<String, Comparable<Date>> params = new HashMap<String, Comparable<Date>>();
            params.put("now", new Date());
            params.put("firstResult", Integer.valueOf(0));
            params.put("maxResults", Integer.valueOf(1));
            RequestInfo request = null;
            try {
                JpaPersistenceContext ctx = (JpaPersistenceContext)context;
                request = (RequestInfo)ctx.queryAndLockWithParametersInTransaction("PendingRequestsForProcessing", params, true, RequestInfo.class);
                if (request != null) {
                    request.setStatus(STATUS.RUNNING);
                    ctx.merge((Object)request);
                }
            }
            catch (NoResultException e) {
                // empty catch block
            }
            return request;
        }
    }
}

