/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.wih;

import java.util.List;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandlerCmdCallback;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutorService;
import org.kie.internal.executor.api.RequestInfo;
import org.kie.internal.executor.api.STATUS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWorkItemHandler
implements WorkItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(AsyncWorkItemHandler.class);
    private ExecutorService executorService;
    private String commandClass;

    public AsyncWorkItemHandler(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public AsyncWorkItemHandler(ExecutorService executorService, String commandClass) {
        this(executorService);
        this.commandClass = commandClass;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        if (this.executorService == null || !this.executorService.isActive()) {
            throw new IllegalStateException("Executor is not set or is not active");
        }
        String businessKey = this.buildBusinessKey(workItem);
        logger.debug("Executing work item {} with built business key {}", (Object)workItem, (Object)businessKey);
        String cmdClass = (String)workItem.getParameter("CommandClass");
        if (cmdClass == null) {
            cmdClass = this.commandClass;
        }
        logger.debug("Command class for this execution is {}", (Object)cmdClass);
        CommandContext ctxCMD = new CommandContext();
        ctxCMD.setData("businessKey", (Object)businessKey);
        ctxCMD.setData("workItem", (Object)workItem);
        ctxCMD.setData("processInstanceId", (Object)this.getProcessInstanceId(workItem));
        ctxCMD.setData("deploymentId", (Object)((WorkItemImpl)workItem).getDeploymentId());
        ctxCMD.setData("callbacks", (Object)AsyncWorkItemHandlerCmdCallback.class.getName());
        if (workItem.getParameter("Retries") != null) {
            ctxCMD.setData("retries", (Object)Integer.parseInt(workItem.getParameter("Retries").toString()));
        }
        logger.trace("Command context {}", (Object)ctxCMD);
        Long requestId = this.executorService.scheduleRequest(cmdClass, ctxCMD);
        logger.debug("Request scheduled successfully with id {}", (Object)requestId);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        String businessKey = this.buildBusinessKey(workItem);
        logger.info("Looking up for not cancelled and not done requests for business key {}", (Object)businessKey);
        List requests = this.executorService.getRequestsByBusinessKey(businessKey);
        if (requests != null) {
            for (RequestInfo request : requests) {
                if (request.getStatus() == STATUS.CANCELLED || request.getStatus() == STATUS.DONE || request.getStatus() == STATUS.ERROR) continue;
                logger.info("About to cancel request with id {} and business key {} request state {}", new Object[]{request.getId(), businessKey, request.getStatus()});
                this.executorService.cancelRequest(request.getId());
            }
        }
    }

    protected String buildBusinessKey(WorkItem workItem) {
        StringBuffer businessKey = new StringBuffer();
        businessKey.append(this.getProcessInstanceId(workItem));
        businessKey.append(":");
        businessKey.append(workItem.getId());
        return businessKey.toString();
    }

    protected long getProcessInstanceId(WorkItem workItem) {
        return ((WorkItemImpl)workItem).getProcessInstanceId();
    }
}

