/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.mem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.jbpm.executor.impl.mem.InMemoryExecutorStoreService;
import org.kie.api.executor.ErrorInfo;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.api.runtime.query.QueryContext;
import org.kie.internal.executor.api.ExecutorQueryService;

public class InMemoryExecutorQueryServiceImpl
implements ExecutorQueryService {
    private InMemoryExecutorStoreService storeService;

    public void setStoreService(InMemoryExecutorStoreService storeService) {
        this.storeService = storeService;
    }

    public InMemoryExecutorQueryServiceImpl(boolean active) {
    }

    public List<RequestInfo> getPendingRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.QUEUED, STATUS.RETRYING));
    }

    public List<RequestInfo> getPendingRequestById(Long id) {
        ArrayList<RequestInfo> requests = new ArrayList<RequestInfo>();
        RequestInfo request = this.storeService.findRequest(id);
        if (request != null && request.getStatus() == STATUS.QUEUED) {
            requests.add(request);
        }
        return requests;
    }

    public RequestInfo getRequestById(Long id) {
        return this.storeService.findRequest(id);
    }

    public List<RequestInfo> getRequestByBusinessKey(String businessKey, QueryContext queryContext) {
        Map<Long, RequestInfo> requests = this.storeService.getRequests();
        List requestsByBusinessKey = (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByKey(businessKey));
        return this.applyPaginition(requestsByBusinessKey, queryContext);
    }

    public List<RequestInfo> getRequestByCommand(String command, QueryContext queryContext) {
        Map<Long, RequestInfo> requests = this.storeService.getRequests();
        List requestsByCommand = (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByCommand(command));
        return this.applyPaginition(requestsByCommand, queryContext);
    }

    public List<ErrorInfo> getErrorsByRequestId(Long id) {
        return this.storeService.findRequest(id).getErrorInfo();
    }

    public List<RequestInfo> getQueuedRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.QUEUED));
    }

    public List<RequestInfo> getCompletedRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getProcessedRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.DONE));
    }

    public List<RequestInfo> getInErrorRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getProcessedRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsWitError());
    }

    public List<RequestInfo> getCancelledRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getProcessedRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.CANCELLED));
    }

    public List<ErrorInfo> getAllErrors() {
        return new ArrayList<ErrorInfo>(this.storeService.getErrors().values());
    }

    public List<RequestInfo> getAllRequests() {
        HashMap<Long, RequestInfo> requests = new HashMap<Long, RequestInfo>(this.storeService.getRequests());
        requests.putAll(this.storeService.getProcessedRequests());
        return new ArrayList<RequestInfo>(requests.values());
    }

    public List<RequestInfo> getRunningRequests() {
        Map<Long, RequestInfo> requests = this.storeService.getRequests();
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(STATUS.RUNNING));
    }

    public List<RequestInfo> getFutureQueuedRequests() {
        return this.getQueuedRequests();
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses) {
        HashMap<Long, RequestInfo> requests = new HashMap<Long, RequestInfo>(this.storeService.getRequests());
        requests.putAll(this.storeService.getProcessedRequests());
        return (List)CollectionUtils.select(requests.values(), (Predicate)new GetRequestsByStatus(statuses));
    }

    public RequestInfo getRequestForProcessing() {
        return this.storeService.getAndLockFirst();
    }

    public List<RequestInfo> getPendingRequests(QueryContext queryContext) {
        return this.applyPaginition(this.getPendingRequests(), queryContext);
    }

    public List<RequestInfo> getQueuedRequests(QueryContext queryContext) {
        return this.applyPaginition(this.getQueuedRequests(), queryContext);
    }

    public List<RequestInfo> getCompletedRequests(QueryContext queryContext) {
        return this.applyPaginition(this.getCompletedRequests(), queryContext);
    }

    public List<RequestInfo> getInErrorRequests(QueryContext queryContext) {
        return this.applyPaginition(this.getInErrorRequests(), queryContext);
    }

    public List<RequestInfo> getCancelledRequests(QueryContext queryContext) {
        return this.applyPaginition(this.getCancelledRequests(), queryContext);
    }

    public List<ErrorInfo> getAllErrors(QueryContext queryContext) {
        return this.applyPaginition(this.getAllErrors(), queryContext);
    }

    public List<RequestInfo> getAllRequests(QueryContext queryContext) {
        return this.applyPaginition(this.getAllRequests(), queryContext);
    }

    public List<RequestInfo> getRunningRequests(QueryContext queryContext) {
        return this.applyPaginition(this.getRunningRequests(), queryContext);
    }

    public List<RequestInfo> getFutureQueuedRequests(QueryContext queryContext) {
        return this.applyPaginition(this.getFutureQueuedRequests(), queryContext);
    }

    public List<RequestInfo> getRequestsByStatus(List<STATUS> statuses, QueryContext queryContext) {
        return this.applyPaginition(this.getRequestsByStatus(statuses), queryContext);
    }

    protected <T> List<T> applyPaginition(List<T> input, QueryContext queryContext) {
        int end = queryContext.getOffset() + queryContext.getCount();
        if (input.size() < queryContext.getOffset()) {
            return new ArrayList();
        }
        if (input.size() >= end) {
            return Collections.unmodifiableList(new ArrayList<T>(input.subList(queryContext.getOffset(), end)));
        }
        if (input.size() < end) {
            return Collections.unmodifiableList(new ArrayList<T>(input.subList(queryContext.getOffset(), input.size())));
        }
        return Collections.unmodifiableList(input);
    }

    public RequestInfo getRequestForProcessing(Long requestId) {
        return this.storeService.removeRequest(requestId);
    }

    private class GetRequestsByCommand
    implements Predicate {
        private String command;

        GetRequestsByCommand(String command) {
            this.command = command;
        }

        public boolean evaluate(Object object) {
            return object instanceof RequestInfo && this.command.equals(((RequestInfo)object).getCommandName());
        }
    }

    private class GetRequestsWitError
    implements Predicate {
        GetRequestsWitError() {
        }

        public boolean evaluate(Object object) {
            return object instanceof RequestInfo && !((RequestInfo)object).getErrorInfo().isEmpty();
        }
    }

    private class GetRequestsByKey
    implements Predicate {
        private String key;

        GetRequestsByKey(String key) {
            this.key = key;
        }

        public boolean evaluate(Object object) {
            return object instanceof RequestInfo && this.key.equals(((RequestInfo)object).getKey());
        }
    }

    private class GetRequestsByStatus
    implements Predicate {
        private List<STATUS> statuses;

        GetRequestsByStatus(STATUS ... status) {
            this.statuses = Arrays.asList(status);
        }

        GetRequestsByStatus(List<STATUS> statuses) {
            this.statuses = statuses;
        }

        public boolean evaluate(Object object) {
            return object instanceof RequestInfo && this.statuses.contains(((RequestInfo)object).getStatus());
        }
    }
}

