/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor;

import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.impl.AvailableJobsExecutor;
import org.jbpm.executor.impl.ClassCacheManager;
import org.jbpm.executor.impl.ExecutorImpl;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.executor.impl.event.ExecutorEventSupportImpl;
import org.jbpm.executor.impl.jpa.ExecutorQueryServiceImpl;
import org.jbpm.executor.impl.jpa.ExecutorRequestAdminServiceImpl;
import org.jbpm.executor.impl.jpa.JPAExecutorStoreService;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.api.executor.Executor;
import org.kie.api.executor.ExecutorQueryService;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.CommandExecutor;

public class ExecutorServiceFactory {
    private static final String mode = System.getProperty("org.jbpm.cdi.executor.mode", "singleton");
    private static ExecutorService serviceInstance;

    public static synchronized ExecutorService newExecutorService(EntityManagerFactory emf) {
        return ExecutorServiceFactory.newExecutorService(emf, new ExecutorEventSupportImpl());
    }

    public static synchronized ExecutorService newExecutorService(EntityManagerFactory emf, ExecutorEventSupportImpl eventSupport) {
        if (mode.equalsIgnoreCase("singleton")) {
            if (serviceInstance == null) {
                serviceInstance = ExecutorServiceFactory.configure(emf, new TransactionalCommandService(emf), eventSupport);
            }
            return serviceInstance;
        }
        return ExecutorServiceFactory.configure(emf, new TransactionalCommandService(emf), eventSupport);
    }

    public static synchronized ExecutorService newExecutorService(EntityManagerFactory emf, TransactionalCommandService commandService, ExecutorEventSupportImpl eventSupport) {
        if (mode.equalsIgnoreCase("singleton")) {
            if (serviceInstance == null) {
                serviceInstance = ExecutorServiceFactory.configure(emf, commandService, eventSupport);
            }
            return serviceInstance;
        }
        return ExecutorServiceFactory.configure(emf, commandService, eventSupport);
    }

    public static synchronized void resetExecutorService(ExecutorService executorService) {
        if (executorService.equals(serviceInstance)) {
            serviceInstance = null;
        }
    }

    public static synchronized void clearExecutorService() {
        serviceInstance = null;
    }

    private static ExecutorService configure(EntityManagerFactory emf, TransactionalCommandService commandService, ExecutorEventSupportImpl eventSupport) {
        ExecutorQueryServiceImpl queryService = new ExecutorQueryServiceImpl(true);
        ExecutorImpl executor = new ExecutorImpl();
        ExecutorRequestAdminServiceImpl adminService = new ExecutorRequestAdminServiceImpl();
        JPAExecutorStoreService storeService = new JPAExecutorStoreService(true);
        storeService.setCommandService((CommandExecutor)commandService);
        storeService.setEmf(emf);
        storeService.setEventSupport(eventSupport);
        AvailableJobsExecutor jobExecutor = new AvailableJobsExecutor();
        ClassCacheManager classCacheManager = new ClassCacheManager();
        jobExecutor.setClassCacheManager(classCacheManager);
        jobExecutor.setQueryService((ExecutorQueryService)queryService);
        jobExecutor.setExecutorStoreService(storeService);
        jobExecutor.setEventSupport(eventSupport);
        jobExecutor.setExecutor((Executor)executor);
        executor.setExecutorStoreService(storeService);
        executor.setEventSupport(eventSupport);
        executor.setJobProcessor(jobExecutor);
        executor.setTransactionManager(commandService.getTransactionManager());
        queryService.setCommandService((CommandExecutor)commandService);
        adminService.setCommandService((CommandExecutor)commandService);
        adminService.setExecutor((Executor)executor);
        ExecutorServiceImpl service = new ExecutorServiceImpl((Executor)executor);
        service.setQueryService((ExecutorQueryService)queryService);
        service.setExecutor((Executor)executor);
        service.setAdminService(adminService);
        service.setEventSupport(eventSupport);
        return service;
    }
}

