/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jpa;

import java.util.Date;
import java.util.List;
import org.jbpm.executor.impl.jpa.ExecutorJPAAuditService;
import org.jbpm.query.jpa.builder.impl.AbstractQueryBuilderImpl;
import org.jbpm.query.jpa.data.QueryWhere;
import org.kie.api.executor.RequestInfo;
import org.kie.api.executor.STATUS;
import org.kie.internal.query.ParametrizedQuery;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.runtime.manager.audit.query.RequestInfoQueryBuilder;

public class RequestInfoQueryBuilderImpl
extends AbstractQueryBuilderImpl<RequestInfoQueryBuilder>
implements RequestInfoQueryBuilder {
    private final ExecutorJPAAuditService jpaAuditService;

    public RequestInfoQueryBuilderImpl(ExecutorJPAAuditService jpaAuditService) {
        this.jpaAuditService = jpaAuditService;
    }

    public RequestInfoQueryBuilder commandName(String ... commandName) {
        this.addObjectParameter(QueryParameterIdentifiers.COMMAND_NAME_LIST, "command name", commandName);
        return this;
    }

    public RequestInfoQueryBuilder deploymentId(String ... deploymentId) {
        this.addObjectParameter(QueryParameterIdentifiers.DEPLOYMENT_ID_LIST, "deployment id", deploymentId);
        return this;
    }

    public RequestInfoQueryBuilder executions(int ... executions) {
        this.addIntParameter(QueryParameterIdentifiers.EXECUTOR_EXECUTIONS_LIST, "executions", executions);
        return this;
    }

    public RequestInfoQueryBuilder id(long ... id) {
        this.addLongParameter(QueryParameterIdentifiers.ID_LIST, "id", id);
        return this;
    }

    public RequestInfoQueryBuilder key(String ... key) {
        this.addObjectParameter(QueryParameterIdentifiers.EXECUTOR_KEY_LIST, "key", key);
        return this;
    }

    public RequestInfoQueryBuilder message(String ... message) {
        this.addObjectParameter(QueryParameterIdentifiers.MESSAGE_LIST, "message", message);
        return this;
    }

    public RequestInfoQueryBuilder owner(String ... owner) {
        this.addObjectParameter(QueryParameterIdentifiers.EXECUTOR_OWNER_LIST, "owner", owner);
        return this;
    }

    public RequestInfoQueryBuilder retries(int ... retries) {
        this.addIntParameter(QueryParameterIdentifiers.EXECUTOR_RETRIES_LIST, "retries", retries);
        return this;
    }

    public RequestInfoQueryBuilder status(STATUS ... status) {
        this.addObjectParameter(QueryParameterIdentifiers.EXECUTOR_STATUS_LIST, "status", status);
        return this;
    }

    public RequestInfoQueryBuilder time(Date ... time) {
        this.addObjectParameter(QueryParameterIdentifiers.EXECUTOR_TIME_LIST, "time", time);
        return this;
    }

    public RequestInfoQueryBuilder timeRange(Date timeMin, Date timeMax) {
        this.addRangeParameters(QueryParameterIdentifiers.EXECUTOR_TIME_LIST, "time", timeMin, timeMax);
        return this;
    }

    public RequestInfoQueryBuilder ascending(RequestInfoQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setAscending(listId);
        return this;
    }

    public RequestInfoQueryBuilder descending(RequestInfoQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setDescending(listId);
        return this;
    }

    private String convertOrderByToListId(RequestInfoQueryBuilder.OrderBy field) {
        String listId;
        switch (field) {
            case deploymentId: {
                listId = QueryParameterIdentifiers.DEPLOYMENT_ID_LIST;
                break;
            }
            case executions: {
                listId = QueryParameterIdentifiers.EXECUTOR_EXECUTIONS_LIST;
                break;
            }
            case id: {
                listId = QueryParameterIdentifiers.ID_LIST;
                break;
            }
            case retries: {
                listId = QueryParameterIdentifiers.EXECUTOR_RETRIES_LIST;
                break;
            }
            case status: {
                listId = QueryParameterIdentifiers.EXECUTOR_STATUS_LIST;
                break;
            }
            case time: {
                listId = QueryParameterIdentifiers.EXECUTOR_TIME_LIST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown 'order-by' field: " + field.toString());
            }
        }
        return listId;
    }

    public ParametrizedQuery<RequestInfo> build() {
        return new ParametrizedQuery<RequestInfo>(){
            private QueryWhere queryData;
            {
                this.queryData = new QueryWhere(RequestInfoQueryBuilderImpl.this.getQueryWhere());
            }

            public List<RequestInfo> getResultList() {
                return RequestInfoQueryBuilderImpl.this.jpaAuditService.queryLogs(this.queryData, org.jbpm.executor.entities.RequestInfo.class, RequestInfo.class);
            }
        };
    }
}

