/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.commands.error;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.EntityManager;
import org.jbpm.executor.commands.error.AutoAckErrorCommand;
import org.jbpm.runtime.manager.impl.jpa.ExecutionErrorInfo;

public class ProcessAutoAckErrorCommand
extends AutoAckErrorCommand {
    private static final String RULE = "Process instances that previously failed but now are in different nodes - meaning node where they were was already completed - or completed/aborted";

    @Override
    protected List<ExecutionErrorInfo> findErrorsToAck(EntityManager em) {
        ArrayList<ExecutionErrorInfo> errorsToAck = new ArrayList<ExecutionErrorInfo>();
        String findProcessErrorsQuery = "select error from ExecutionErrorInfo error where error.acknowledged =:acknowledged and error.processInstanceId in (select pil.id from ProcessInstanceLog pil where status in (:status))";
        List processErrorsToAck = em.createQuery(findProcessErrorsQuery).setParameter("acknowledged", (Object)new Short("0")).setParameter("status", Arrays.asList(2, 3)).getResultList();
        errorsToAck.addAll(processErrorsToAck);
        String findNodeErrorsQuery = "select error from ExecutionErrorInfo error where error.acknowledged =:acknowledged and error.initActivityId in (select nil.nodeInstanceId from NodeInstanceLog nil where nil.processInstanceId = error.processInstanceId and nil.nodeInstanceId = error.initActivityId and nil.type = 1)";
        List nodeErrorsToAck = em.createQuery(findNodeErrorsQuery).setParameter("acknowledged", (Object)new Short("0")).getResultList();
        errorsToAck.addAll(nodeErrorsToAck);
        return errorsToAck;
    }

    @Override
    protected String getAckRule() {
        return RULE;
    }
}

