/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.error;

import java.util.Date;
import org.jbpm.executor.AsyncJobException;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.runtime.manager.impl.error.filters.AbstractExecutionErrorFilter;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.internal.runtime.error.ExecutionError;
import org.kie.internal.runtime.error.ExecutionErrorContext;

public class JobExecutionErrorFilter
extends AbstractExecutionErrorFilter {
    public static final String TYPE = "Job";

    public boolean accept(ExecutionErrorContext errorContext) {
        return this.isCausedBy(errorContext.getCause(), new Class[]{AsyncJobException.class});
    }

    public ExecutionError filter(ExecutionErrorContext errorContext) {
        AsyncJobException exception = (AsyncJobException)this.extract(errorContext.getCause(), AsyncJobException.class);
        String stacktrace = this.getStackTrace(exception);
        NodeInstance nodeInstance = errorContext.getLastExecutedNode();
        return ExecutionError.builder().type(TYPE).initActivityId(this.getInitActivityId(errorContext)).deploymentId(((ProcessInstanceImpl)nodeInstance.getProcessInstance()).getDeploymentId()).processInstanceId(Long.valueOf(nodeInstance.getProcessInstance().getId())).processId(nodeInstance.getProcessInstance().getProcessId()).activityId(Long.valueOf(nodeInstance.getId())).activityName(this.nodeName(nodeInstance)).jobId(exception.getJobId()).message(exception.getMessage()).error(stacktrace).errorDate(new Date()).build();
    }

    public Integer getPriority() {
        return 100;
    }

    public String toString() {
        return "JobExecutionErrorFilter [accepts=AsyncJobException, ignores=]";
    }
}

