/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.jbpm.executor.entities.RequestInfo;
import org.jbpm.executor.impl.AbstractAvailableJobsExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsAvailableJobsExecutor
extends AbstractAvailableJobsExecutor
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(JmsAvailableJobsExecutor.class);

    public void onMessage(Message message) {
        if (message instanceof TextMessage) {
            Long requestId = null;
            TextMessage textMessage = (TextMessage)message;
            try {
                String messageContent = textMessage.getText();
                logger.debug("received Text message with content {}", (Object)messageContent);
                requestId = Long.parseLong(messageContent);
                RequestInfo request = (RequestInfo)this.queryService.getRequestForProcessing(requestId);
                logger.debug("Found following job request for id {} : {}", (Object)requestId, (Object)request);
                if (request != null) {
                    logger.debug("Request with id {} is in valid state, processing...", (Object)requestId);
                    this.executeGivenJob(request);
                }
            }
            catch (JMSException e) {
                logger.error("JMS Error when processing job with id {} due to {}", new Object[]{requestId, e.getMessage(), e});
                throw new RuntimeException("Exception when receiving executor job request", e);
            }
            catch (Throwable e) {
                logger.error("Error when processing job with id {} due to {} will ack JMS message and let exeuctor retry it", new Object[]{requestId, e.getMessage(), e});
            }
        }
    }
}

