/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.executor.impl.concurrent;

import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jbpm.executor.impl.AvailableJobsExecutor;
import org.jbpm.executor.impl.concurrent.PrioritisedRunnable;
import org.jbpm.executor.impl.concurrent.PrioritisedScheduledThreadPoolExecutor;
import org.kie.api.executor.RequestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadAndScheduleRequestsTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LoadAndScheduleRequestsTask.class);
    private ScheduledExecutorService scheduler;
    private AvailableJobsExecutor jobProcessor;
    private Supplier<List<RequestInfo>> taskLoader;

    public LoadAndScheduleRequestsTask(ScheduledExecutorService scheduler, AvailableJobsExecutor jobProcessor, Supplier<List<RequestInfo>> taskLoader) {
        this.scheduler = scheduler;
        this.jobProcessor = jobProcessor;
        this.taskLoader = taskLoader;
    }

    @Override
    public void run() {
        try {
            Date started = new Date();
            List<RequestInfo> loaded = this.taskLoader.get();
            if (!loaded.isEmpty()) {
                logger.info("Found {} jobs that are waiting for execution, scheduling them...", (Object)loaded.size());
                int scheduledCounter = 0;
                for (RequestInfo request : loaded) {
                    PrioritisedRunnable job = new PrioritisedRunnable(request.getId(), request.getPriority(), request.getTime(), this.jobProcessor);
                    long delay = request.getTime().getTime() - System.currentTimeMillis();
                    logger.debug("Scheduling with delay {} for request {} at time {}", new Object[]{delay, request.getId(), request.getTime()});
                    boolean scheduled = ((PrioritisedScheduledThreadPoolExecutor)this.scheduler).scheduleNoDuplicates(job, delay, TimeUnit.MILLISECONDS);
                    if (scheduled) {
                        logger.debug("Request {} has been successfully scheduled at {}", (Object)request.getId(), (Object)request.getTime());
                        ++scheduledCounter;
                        continue;
                    }
                    logger.debug("Request {} has not been scheduled as it's already there", (Object)request.getId());
                }
                logger.info("{} jobs have been successfully scheduled", (Object)scheduledCounter);
            }
            logger.info("Load of jobs from storage started at {} and finished {} with size {}", new Object[]{started, new Date(), loaded.size()});
        }
        catch (Throwable e) {
            logger.error("Unexpected error while synchronizing with data base for jobs", e);
        }
    }
}

