/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.util.HashMap;
import java.util.List;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.jbpm.process.builder.EventBasedNodeBuilder;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.core.ContextResolver;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.DataTransformer;

public class WorkItemNodeBuilder
extends EventBasedNodeBuilder {
    @Override
    public void build(Process process, ProcessDescr processDescr, ProcessBuildContext context, Node node) {
        ProcessDialect dialect;
        List assignments;
        DataTransformer transformer;
        Transformation transformation;
        super.build(process, processDescr, context, node);
        WorkflowProcess wfProcess = (WorkflowProcess)process;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("imports", wfProcess.getImports());
        parameters.put("classloader", context.getConfiguration().getClassLoader());
        for (DataAssociation dataAssociation : ((WorkItemNode)node).getInAssociations()) {
            transformation = dataAssociation.getTransformation();
            if (transformation != null) {
                transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                transformation.setCompiledExpression(transformer.compile(transformation.getExpression(), parameters));
            }
            if ((assignments = dataAssociation.getAssignments()) == null) continue;
            for (Assignment assignment : assignments) {
                dialect = ProcessDialectRegistry.getDialect(assignment.getDialect());
                dialect.getAssignmentBuilder().build(context, assignment, (String)dataAssociation.getSources().get(0), dataAssociation.getTarget(), (ContextResolver)((WorkItemNode)node), true);
            }
        }
        for (DataAssociation dataAssociation : ((WorkItemNode)node).getOutAssociations()) {
            transformation = dataAssociation.getTransformation();
            if (transformation != null) {
                transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                transformation.setCompiledExpression(transformer.compile(transformation.getExpression(), parameters));
            }
            if ((assignments = dataAssociation.getAssignments()) == null) continue;
            for (Assignment assignment : assignments) {
                dialect = ProcessDialectRegistry.getDialect(assignment.getDialect());
                dialect.getAssignmentBuilder().build(context, assignment, (String)dataAssociation.getSources().get(0), dataAssociation.getTarget(), (ContextResolver)((WorkItemNode)node), false);
            }
        }
    }
}

