/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.definition.process.Process;
import org.drools.marshalling.ObjectMarshallingStrategy;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.reteoo.ReteooStatefulSession;
import org.drools.runtime.process.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessRuntimeImpl;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;

public class ProcessInstanceResolverStrategy
implements ObjectMarshallingStrategy {
    public boolean accept(Object object) {
        return object instanceof ProcessInstance;
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        ProcessInstance processInstance = (ProcessInstance)object;
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, os);
        os.writeLong(processInstance.getId());
    }

    public Object read(ObjectInputStream is) throws IOException, ClassNotFoundException {
        long processInstanceId = is.readLong();
        ProcessInstanceManager pim = ProcessInstanceResolverStrategy.retrieveProcessInstanceManager(is);
        ProcessInstance processInstance = pim.getProcessInstance(processInstanceId);
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, is);
        return processInstance;
    }

    public static ProcessInstanceManager retrieveProcessInstanceManager(Object streamContext) {
        ProcessInstanceManager pim = null;
        if (streamContext instanceof MarshallerWriteContext) {
            MarshallerWriteContext context = (MarshallerWriteContext)streamContext;
            pim = ((ProcessRuntimeImpl)((ReteooStatefulSession)context.wm).getProcessRuntime()).getProcessInstanceManager();
        } else if (streamContext instanceof MarshallerReaderContext) {
            MarshallerReaderContext context = (MarshallerReaderContext)streamContext;
            pim = ((ProcessRuntimeImpl)((ReteooStatefulSession)context.wm).getProcessRuntime()).getProcessInstanceManager();
        } else {
            throw new UnsupportedOperationException("Unable to retrieve " + ProcessInstanceManager.class.getSimpleName() + " from " + streamContext.getClass().getName());
        }
        return pim;
    }

    private void connectProcessInstanceToRuntimeAndProcess(ProcessInstance processInstance, Object streamContext) {
        ProcessInstanceImpl processInstanceImpl = (ProcessInstanceImpl)processInstance;
        InternalKnowledgeRuntime kruntime = processInstanceImpl.getKnowledgeRuntime();
        if (kruntime == null) {
            kruntime = ProcessInstanceResolverStrategy.retrieveKnowledgeRuntime(streamContext);
            processInstanceImpl.setKnowledgeRuntime(kruntime);
        }
        if (processInstance.getProcess() == null) {
            Process process = kruntime.getKnowledgeBase().getProcess(processInstance.getProcessId());
            processInstanceImpl.setProcess(process);
        }
    }

    public static InternalKnowledgeRuntime retrieveKnowledgeRuntime(Object streamContext) {
        InternalKnowledgeRuntime kruntime = null;
        if (streamContext instanceof MarshallerWriteContext) {
            MarshallerWriteContext context = (MarshallerWriteContext)streamContext;
            kruntime = ((ReteooStatefulSession)context.wm).getKnowledgeRuntime();
        } else if (streamContext instanceof MarshallerReaderContext) {
            MarshallerReaderContext context = (MarshallerReaderContext)streamContext;
            kruntime = ((ReteooStatefulSession)context.wm).getKnowledgeRuntime();
        } else {
            throw new UnsupportedOperationException("Unable to retrieve " + ProcessInstanceManager.class.getSimpleName() + " from " + streamContext.getClass().getName());
        }
        return kruntime;
    }

    public byte[] marshal(ObjectOutputStream os, Object object) throws IOException {
        ProcessInstance processInstance = (ProcessInstance)object;
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, os);
        return this.longToByteArray(processInstance.getId());
    }

    public Object unmarshal(ObjectInputStream is, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        long processInstanceId = this.byteArrayToLong(object);
        ProcessInstanceManager pim = ProcessInstanceResolverStrategy.retrieveProcessInstanceManager(is);
        ProcessInstance processInstance = pim.getProcessInstance(processInstanceId);
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, is);
        return processInstance;
    }

    private final byte[] longToByteArray(long value) {
        return new byte[]{(byte)(value >>> 56 & 0xFFL), (byte)(value >>> 48 & 0xFFL), (byte)(value >>> 40 & 0xFFL), (byte)(value >>> 32 & 0xFFL), (byte)(value >>> 24 & 0xFFL), (byte)(value >>> 16 & 0xFFL), (byte)(value >>> 8 & 0xFFL), (byte)(value & 0xFFL)};
    }

    private final long byteArrayToLong(byte[] b) {
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + ((long)b[7] & 0xFFL);
    }
}

