/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.process.core.Work;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.context.variable.Mappable;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.StateBasedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemNode
extends StateBasedNode
implements Mappable,
ContextContainer {
    private static final long serialVersionUID = 510L;
    private Work work;
    private List<DataAssociation> inMapping = new LinkedList<DataAssociation>();
    private List<DataAssociation> outMapping = new LinkedList<DataAssociation>();
    private boolean waitForCompletion = true;

    public Work getWork() {
        return this.work;
    }

    public void setWork(Work work) {
        this.work = work;
    }

    @Override
    public void addInMapping(String parameterName, String variableName) {
        this.inMapping.add(new DataAssociation(variableName, parameterName, null, null));
    }

    @Override
    public void setInMappings(Map<String, String> inMapping) {
        this.inMapping = new LinkedList<DataAssociation>();
        for (Map.Entry<String, String> entry : inMapping.entrySet()) {
            this.addInMapping(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getInMapping(String parameterName) {
        return this.getInMappings().get(parameterName);
    }

    @Override
    public Map<String, String> getInMappings() {
        HashMap<String, String> in = new HashMap<String, String>();
        for (DataAssociation a : this.inMapping) {
            if (a.getSources().size() != 1 || a.getAssignments() != null && a.getAssignments().size() != 0 || a.getTransformation() != null) continue;
            in.put(a.getTarget(), a.getSources().get(0));
        }
        return in;
    }

    @Override
    public void addInAssociation(DataAssociation dataAssociation) {
        this.inMapping.add(dataAssociation);
    }

    @Override
    public List<DataAssociation> getInAssociations() {
        return Collections.unmodifiableList(this.inMapping);
    }

    @Override
    public void addOutMapping(String parameterName, String variableName) {
        this.outMapping.add(new DataAssociation(parameterName, variableName, null, null));
    }

    @Override
    public void setOutMappings(Map<String, String> outMapping) {
        this.outMapping = new LinkedList<DataAssociation>();
        for (Map.Entry<String, String> entry : outMapping.entrySet()) {
            this.addOutMapping(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getOutMapping(String parameterName) {
        return this.getOutMappings().get(parameterName);
    }

    @Override
    public Map<String, String> getOutMappings() {
        HashMap<String, String> out = new HashMap<String, String>();
        for (DataAssociation a : this.outMapping) {
            if (a.getSources().size() != 1 || a.getAssignments() != null && a.getAssignments().size() != 0 || a.getTransformation() != null) continue;
            out.put(a.getSources().get(0), a.getTarget());
        }
        return out;
    }

    @Override
    public void addOutAssociation(DataAssociation dataAssociation) {
        this.outMapping.add(dataAssociation);
    }

    @Override
    public List<DataAssociation> getOutAssociations() {
        return Collections.unmodifiableList(this.outMapping);
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && System.getProperty("jbpm.enable.multi.con") == null) {
            throw new IllegalArgumentException("This type of node cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && System.getProperty("jbpm.enable.multi.con") == null) {
            throw new IllegalArgumentException("This type of node cannot have more than one outgoing connection!");
        }
    }

    @Override
    public List<Context> getContexts(String contextType) {
        return ((ContextContainer)this.getNodeContainer()).getContexts(contextType);
    }

    @Override
    public void addContext(Context context) {
        ((ContextContainer)this.getNodeContainer()).addContext(context);
        ((AbstractContext)context).setContextContainer(this);
    }

    @Override
    public Context getContext(String contextType, long id) {
        return ((ContextContainer)this.getNodeContainer()).getContext(contextType, id);
    }

    @Override
    public void setDefaultContext(Context context) {
        ((ContextContainer)this.getNodeContainer()).setDefaultContext(context);
    }

    @Override
    public Context getDefaultContext(String contextType) {
        return ((ContextContainer)this.getNodeContainer()).getDefaultContext(contextType);
    }
}

