/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core;

import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.context.swimlane.SwimlaneContext;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.workflow.core.impl.NodeContainerImpl;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.jbpm.workflow.core.node.StartNode;
import org.kie.definition.process.Node;
import org.kie.definition.process.NodeContainer;

public class RuleFlowProcess
extends WorkflowProcessImpl {
    public static final String RULEFLOW_TYPE = "RuleFlow";
    private static final long serialVersionUID = 510L;

    public RuleFlowProcess() {
        this.setType(RULEFLOW_TYPE);
        VariableScope variableScope = new VariableScope();
        this.addContext(variableScope);
        this.setDefaultContext(variableScope);
        SwimlaneContext swimLaneContext = new SwimlaneContext();
        this.addContext(swimLaneContext);
        this.setDefaultContext(swimLaneContext);
        ExceptionScope exceptionScope = new ExceptionScope();
        this.addContext(exceptionScope);
        this.setDefaultContext(exceptionScope);
    }

    public VariableScope getVariableScope() {
        return (VariableScope)this.getDefaultContext("VariableScope");
    }

    public SwimlaneContext getSwimlaneContext() {
        return (SwimlaneContext)this.getDefaultContext("SwimlaneScope");
    }

    public ExceptionScope getExceptionScope() {
        return (ExceptionScope)this.getDefaultContext("ExceptionScope");
    }

    @Override
    protected NodeContainer createNodeContainer() {
        return new WorkflowProcessNodeContainer();
    }

    public StartNode getStart() {
        Node[] nodes = this.getNodes();
        int startNodeIndex = -1;
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof StartNode)) continue;
            if (((StartNode)nodes[i]).getTriggers() == null || ((StartNode)nodes[i]).getTriggers().isEmpty()) {
                return (StartNode)nodes[i];
            }
            startNodeIndex = i;
        }
        if (startNodeIndex > -1) {
            return (StartNode)nodes[startNodeIndex];
        }
        return null;
    }

    private class WorkflowProcessNodeContainer
    extends NodeContainerImpl {
        private static final long serialVersionUID = 510L;

        private WorkflowProcessNodeContainer() {
        }

        @Override
        protected void validateAddNode(Node node) {
            super.validateAddNode(node);
            StartNode startNode = RuleFlowProcess.this.getStart();
            if (node instanceof StartNode && startNode != null && startNode.getTriggers() == null && (((StartNode)node).getTriggers() == null || ((StartNode)node).getTriggers().isEmpty())) {
                throw new IllegalArgumentException("A RuleFlowProcess cannot have more than one start node!");
            }
        }
    }
}

