/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance;

import java.text.MessageFormat;
import org.kie.runtime.process.NodeInstance;

public class WorkflowRuntimeException
extends RuntimeException {
    private long processInstanceId;
    private String processId;
    private long nodeInstanceId;
    private long nodeId;
    private String nodeName;

    public WorkflowRuntimeException(Exception e) {
        super(e);
    }

    public WorkflowRuntimeException(NodeInstance nodeInstance, Exception e) {
        super(e);
        this.processInstanceId = nodeInstance.getProcessInstance().getId();
        this.processId = nodeInstance.getProcessInstance().getProcessId();
        this.nodeInstanceId = nodeInstance.getId();
        this.nodeId = nodeInstance.getNodeId();
        this.nodeName = nodeInstance.getNodeName();
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public long getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public void setNodeInstanceId(long nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public String getMessage() {
        return MessageFormat.format("[{0}:{4} - {1}:{2}] -- {3}", this.getProcessId(), this.getNodeName(), this.getNodeId(), this.getCause().getMessage(), this.getProcessInstanceId());
    }
}

