/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.kie.definition.process.Connection;

public class RuleSetNode
extends StateBasedNode {
    private static final long serialVersionUID = 510L;
    private String ruleFlowGroup;
    private List<DataAssociation> inMapping = new LinkedList<DataAssociation>();
    private List<DataAssociation> outMapping = new LinkedList<DataAssociation>();
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }

    public String getRuleFlowGroup() {
        return this.ruleFlowGroup;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && System.getProperty("jbpm.enable.multi.con") == null) {
            throw new IllegalArgumentException("This type of node cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && System.getProperty("jbpm.enable.multi.con") == null) {
            throw new IllegalArgumentException("This type of node cannot have more than one outgoing connection!");
        }
    }

    public void addInMapping(String parameterName, String variableName) {
        this.inMapping.add(new DataAssociation(variableName, parameterName, null, null));
    }

    public void setInMappings(Map<String, String> inMapping) {
        this.inMapping = new LinkedList<DataAssociation>();
        for (Map.Entry<String, String> entry : inMapping.entrySet()) {
            this.addInMapping(entry.getKey(), entry.getValue());
        }
    }

    public String getInMapping(String parameterName) {
        return this.getInMappings().get(parameterName);
    }

    public Map<String, String> getInMappings() {
        HashMap<String, String> in = new HashMap<String, String>();
        for (DataAssociation a : this.inMapping) {
            if (a.getSources().size() != 1 || a.getAssignments() != null && a.getAssignments().size() != 0 || a.getTransformation() != null) continue;
            in.put(a.getTarget(), a.getSources().get(0));
        }
        return in;
    }

    public void addInAssociation(DataAssociation dataAssociation) {
        this.inMapping.add(dataAssociation);
    }

    public List<DataAssociation> getInAssociations() {
        return Collections.unmodifiableList(this.inMapping);
    }

    public void addOutMapping(String parameterName, String variableName) {
        this.outMapping.add(new DataAssociation(parameterName, variableName, null, null));
    }

    public void setOutMappings(Map<String, String> outMapping) {
        this.outMapping = new LinkedList<DataAssociation>();
        for (Map.Entry<String, String> entry : outMapping.entrySet()) {
            this.addOutMapping(entry.getKey(), entry.getValue());
        }
    }

    public String getOutMapping(String parameterName) {
        return this.getOutMappings().get(parameterName);
    }

    public Map<String, String> getOutMappings() {
        HashMap<String, String> out = new HashMap<String, String>();
        for (DataAssociation a : this.outMapping) {
            if (a.getSources().size() != 1 || a.getAssignments() != null && a.getAssignments().size() != 0 || a.getTransformation() != null) continue;
            out.put(a.getSources().get(0), a.getTarget());
        }
        return out;
    }

    public void addOutAssociation(DataAssociation dataAssociation) {
        this.outMapping.add(dataAssociation);
    }

    public List<DataAssociation> getOutAssociations() {
        return Collections.unmodifiableList(this.outMapping);
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setParameter(String param, Object value) {
        this.parameters.put(param, value);
    }

    public Object getParameter(String param) {
        return this.parameters.get(param);
    }
}

