/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProtobufMessages;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.marshalling.impl.ProcessInstanceMarshaller;
import org.jbpm.marshalling.impl.ProtobufProcessMarshaller;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.Process;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.EventSubProcessNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.jbpm.workflow.instance.node.MilestoneNodeInstance;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.node.StateNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.runtime.process.NodeInstance;
import org.kie.runtime.process.NodeInstanceContainer;
import org.kie.runtime.rule.FactHandle;

public abstract class AbstractProtobufProcessInstanceMarshaller
implements ProcessInstanceMarshaller {
    @Override
    public JBPMMessages.ProcessInstance writeProcessInstance(MarshallerWriteContext context, org.kie.runtime.process.ProcessInstance processInstance) throws IOException {
        SwimlaneContextInstance swimlaneContextInstance;
        WorkflowProcessInstanceImpl workFlow = (WorkflowProcessInstanceImpl)processInstance;
        JBPMMessages.ProcessInstance.Builder _instance = JBPMMessages.ProcessInstance.newBuilder().setId(workFlow.getId()).setProcessId(workFlow.getProcessId()).setState(workFlow.getState()).setNodeInstanceCounter(workFlow.getNodeInstanceCounter()).setProcessType(workFlow.getProcess().getType());
        if (workFlow.getProcessXml() != null) {
            _instance.setProcessXml(workFlow.getProcessXml());
        }
        if ((swimlaneContextInstance = (SwimlaneContextInstance)workFlow.getContextInstance("SwimlaneScope")) != null) {
            Map<String, String> swimlaneActors = swimlaneContextInstance.getSwimlaneActors();
            for (Map.Entry<String, String> entry : swimlaneActors.entrySet()) {
                _instance.addSwimlaneContext(JBPMMessages.ProcessInstance.SwimlaneContextInstance.newBuilder().setSwimlane(entry.getKey()).setActorId(entry.getValue()).build());
            }
        }
        ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(workFlow.getNodeInstances());
        Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

            @Override
            public int compare(NodeInstance o1, NodeInstance o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        for (NodeInstance nodeInstance : nodeInstances) {
            _instance.addNodeInstance(this.writeNodeInstance(context, nodeInstance));
        }
        List<ContextInstance> exclusiveGroupInstances = workFlow.getContextInstances("ExclusiveGroup");
        if (exclusiveGroupInstances != null) {
            for (ContextInstance contextInstance : exclusiveGroupInstances) {
                JBPMMessages.ProcessInstance.ExclusiveGroupInstance.Builder _exclusive = JBPMMessages.ProcessInstance.ExclusiveGroupInstance.newBuilder();
                ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                Collection<NodeInstance> groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                for (NodeInstance nodeInstance : groupNodeInstances) {
                    _exclusive.addGroupNodeInstanceId(nodeInstance.getId());
                }
                _instance.addExclusiveGroup(_exclusive.build());
            }
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)workFlow.getContextInstance("VariableScope");
        ArrayList<Map.Entry<String, Object>> variables = new ArrayList<Map.Entry<String, Object>>(variableScopeInstance.getVariables().entrySet());
        Collections.sort(variables, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        for (Map.Entry entry : variables) {
            if (entry.getValue() == null) continue;
            _instance.addVariable(ProtobufProcessMarshaller.marshallVariable(context, (String)entry.getKey(), entry.getValue()));
        }
        return _instance.build();
    }

    @Override
    public JBPMMessages.ProcessInstance.NodeInstance writeNodeInstance(MarshallerWriteContext context, NodeInstance nodeInstance) throws IOException {
        JBPMMessages.ProcessInstance.NodeInstance.Builder _node = JBPMMessages.ProcessInstance.NodeInstance.newBuilder().setId(nodeInstance.getId()).setNodeId(nodeInstance.getNodeId());
        _node.setContent(this.writeNodeInstanceContent(_node, nodeInstance, context));
        return _node.build();
    }

    protected JBPMMessages.ProcessInstance.NodeInstanceContent writeNodeInstanceContent(JBPMMessages.ProcessInstance.NodeInstance.Builder _node, NodeInstance nodeInstance, MarshallerWriteContext context) throws IOException {
        JBPMMessages.ProcessInstance.NodeInstanceContent.Builder _content = null;
        if (nodeInstance instanceof RuleSetNodeInstance) {
            Map<String, FactHandle> facts;
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.RULE_SET_NODE);
            List<Long> timerInstances = ((RuleSetNodeInstance)nodeInstance).getTimerInstances();
            JBPMMessages.ProcessInstance.NodeInstanceContent.RuleSetNode.Builder _ruleSet = JBPMMessages.ProcessInstance.NodeInstanceContent.RuleSetNode.newBuilder();
            _ruleSet.setRuleFlowGroup(((RuleSetNodeInstance)nodeInstance).getRuleFlowGroup());
            if (timerInstances != null) {
                for (Long id : timerInstances) {
                    _ruleSet.addTimerInstanceId(id);
                }
            }
            if ((facts = ((RuleSetNodeInstance)nodeInstance).getFactHandles()) != null && facts.size() > 0) {
                for (Map.Entry<String, FactHandle> entry : facts.entrySet()) {
                    JBPMMessages.ProcessInstance.NodeInstanceContent.RuleSetNode.TextMapEntry.Builder _textMapEntry = JBPMMessages.ProcessInstance.NodeInstanceContent.RuleSetNode.TextMapEntry.newBuilder();
                    _textMapEntry.setName(entry.getKey());
                    _textMapEntry.setValue(entry.getValue().toExternalForm());
                    _ruleSet.addMapEntry(_textMapEntry.build());
                }
            }
            _content.setRuleSet(_ruleSet.build());
        } else if (nodeInstance instanceof HumanTaskNodeInstance) {
            JBPMMessages.ProcessInstance.NodeInstanceContent.HumanTaskNode.Builder _task = JBPMMessages.ProcessInstance.NodeInstanceContent.HumanTaskNode.newBuilder().setWorkItemId(((HumanTaskNodeInstance)nodeInstance).getWorkItemId());
            List<Long> timerInstances = ((HumanTaskNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                for (Long id : timerInstances) {
                    _task.addTimerInstanceId(id);
                }
            }
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.HUMAN_TASK_NODE).setHumanTask(_task.build());
        } else if (nodeInstance instanceof WorkItemNodeInstance) {
            JBPMMessages.ProcessInstance.NodeInstanceContent.WorkItemNode.Builder _wi = JBPMMessages.ProcessInstance.NodeInstanceContent.WorkItemNode.newBuilder().setWorkItemId(((WorkItemNodeInstance)nodeInstance).getWorkItemId());
            List<Long> timerInstances = ((WorkItemNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                for (Long id : timerInstances) {
                    _wi.addTimerInstanceId(id);
                }
            }
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.WORK_ITEM_NODE).setWorkItem(_wi.build());
        } else if (nodeInstance instanceof SubProcessNodeInstance) {
            JBPMMessages.ProcessInstance.NodeInstanceContent.SubProcessNode.Builder _sp = JBPMMessages.ProcessInstance.NodeInstanceContent.SubProcessNode.newBuilder().setProcessInstanceId(((SubProcessNodeInstance)nodeInstance).getProcessInstanceId());
            List<Long> timerInstances = ((SubProcessNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                for (Long id : timerInstances) {
                    _sp.addTimerInstanceId(id);
                }
            }
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.SUBPROCESS_NODE).setSubProcess(_sp.build());
        } else if (nodeInstance instanceof MilestoneNodeInstance) {
            JBPMMessages.ProcessInstance.NodeInstanceContent.MilestoneNode.Builder _ms = JBPMMessages.ProcessInstance.NodeInstanceContent.MilestoneNode.newBuilder();
            List<Long> timerInstances = ((MilestoneNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                for (Long id : timerInstances) {
                    _ms.addTimerInstanceId(id);
                }
            }
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.MILESTONE_NODE).setMilestone(_ms.build());
        } else if (nodeInstance instanceof EventNodeInstance) {
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.EVENT_NODE);
        } else if (nodeInstance instanceof TimerNodeInstance) {
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.TIMER_NODE).setTimer(JBPMMessages.ProcessInstance.NodeInstanceContent.TimerNode.newBuilder().setTimerId(((TimerNodeInstance)nodeInstance).getTimerId()).build());
        } else if (nodeInstance instanceof JoinInstance) {
            JBPMMessages.ProcessInstance.NodeInstanceContent.JoinNode.Builder _join = JBPMMessages.ProcessInstance.NodeInstanceContent.JoinNode.newBuilder();
            Map<Long, Integer> triggers = ((JoinInstance)nodeInstance).getTriggers();
            ArrayList<Long> keys = new ArrayList<Long>(triggers.keySet());
            Collections.sort(keys, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return o1.compareTo(o2);
                }
            });
            for (Long key : keys) {
                _join.addTrigger(JBPMMessages.ProcessInstance.NodeInstanceContent.JoinNode.JoinTrigger.newBuilder().setNodeId(key).setCounter(triggers.get(key)).build());
            }
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.JOIN_NODE).setJoin(_join.build());
        } else if (nodeInstance instanceof StateNodeInstance) {
            JBPMMessages.ProcessInstance.NodeInstanceContent.StateNode.Builder _state = JBPMMessages.ProcessInstance.NodeInstanceContent.StateNode.newBuilder();
            List<Long> timerInstances = ((StateNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                for (Long id : timerInstances) {
                    _state.addTimerInstanceId(id);
                }
            }
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.STATE_NODE).setState(_state.build());
        } else if (nodeInstance instanceof CompositeContextNodeInstance) {
            VariableScopeInstance variableScopeInstance;
            JBPMMessages.ProcessInstance.NodeInstanceContent.CompositeContextNode.Builder _composite = JBPMMessages.ProcessInstance.NodeInstanceContent.CompositeContextNode.newBuilder();
            JBPMMessages.ProcessInstance.NodeInstanceType _type = null;
            _type = nodeInstance instanceof DynamicNodeInstance ? JBPMMessages.ProcessInstance.NodeInstanceType.DYNAMIC_NODE : (nodeInstance instanceof EventSubProcessNodeInstance ? JBPMMessages.ProcessInstance.NodeInstanceType.EVENT_SUBPROCESS_NODE : JBPMMessages.ProcessInstance.NodeInstanceType.COMPOSITE_CONTEXT_NODE);
            CompositeContextNodeInstance compositeNodeInstance = (CompositeContextNodeInstance)nodeInstance;
            List<Long> timerInstances = ((CompositeContextNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                for (Long id : timerInstances) {
                    _composite.addTimerInstanceId(id);
                }
            }
            if ((variableScopeInstance = (VariableScopeInstance)compositeNodeInstance.getContextInstance("VariableScope")) != null) {
                ArrayList<Map.Entry<String, Object>> variables = new ArrayList<Map.Entry<String, Object>>(variableScopeInstance.getVariables().entrySet());
                Collections.sort(variables, new Comparator<Map.Entry<String, Object>>(){

                    @Override
                    public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                for (Map.Entry entry : variables) {
                    _composite.addVariable(ProtobufProcessMarshaller.marshallVariable(context, (String)entry.getKey(), entry.getValue()));
                }
            }
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(compositeNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return (int)(o1.getId() - o2.getId());
                }
            });
            for (NodeInstance nodeInstance2 : nodeInstances) {
                _composite.addNodeInstance(this.writeNodeInstance(context, nodeInstance2));
            }
            List<ContextInstance> exclusiveGroupInstances = compositeNodeInstance.getContextInstances("ExclusiveGroup");
            if (exclusiveGroupInstances != null) {
                for (ContextInstance contextInstance : exclusiveGroupInstances) {
                    JBPMMessages.ProcessInstance.ExclusiveGroupInstance.Builder _excl = JBPMMessages.ProcessInstance.ExclusiveGroupInstance.newBuilder();
                    ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                    Collection<NodeInstance> groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                    for (NodeInstance groupNodeInstance : groupNodeInstances) {
                        _excl.addGroupNodeInstanceId(groupNodeInstance.getId());
                    }
                    _composite.addExclusiveGroup(_excl.build());
                }
            }
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(_type).setComposite(_composite.build());
        } else if (nodeInstance instanceof ForEachNodeInstance) {
            JBPMMessages.ProcessInstance.NodeInstanceContent.ForEachNode.Builder _foreach = JBPMMessages.ProcessInstance.NodeInstanceContent.ForEachNode.newBuilder();
            ForEachNodeInstance forEachNodeInstance = (ForEachNodeInstance)nodeInstance;
            ArrayList<NodeInstance> nodeInstances = new ArrayList<NodeInstance>(forEachNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return (int)(o1.getId() - o2.getId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                if (!(subNodeInstance instanceof CompositeContextNodeInstance)) continue;
                _foreach.addNodeInstance(this.writeNodeInstance(context, subNodeInstance));
            }
            _content = JBPMMessages.ProcessInstance.NodeInstanceContent.newBuilder().setType(JBPMMessages.ProcessInstance.NodeInstanceType.FOR_EACH_NODE).setForEach(_foreach.build());
        } else {
            throw new IllegalArgumentException("Unknown node instance type: " + nodeInstance);
        }
        return _content.build();
    }

    @Override
    public org.kie.runtime.process.ProcessInstance readProcessInstance(MarshallerReaderContext context) throws IOException {
        InternalRuleBase ruleBase = context.ruleBase;
        InternalWorkingMemory wm = context.wm;
        JBPMMessages.ProcessInstance _instance = (JBPMMessages.ProcessInstance)context.parameterObject;
        if (_instance == null) {
            ProtobufMessages.Header _header;
            ExtensionRegistry registry = PersisterHelper.buildRegistry((MarshallerReaderContext)context, null);
            try {
                _header = PersisterHelper.readFromStreamWithHeader((MarshallerReaderContext)context, (ExtensionRegistry)registry);
            }
            catch (ClassNotFoundException e) {
                IOException ioe = new IOException("Error deserializing process instance.");
                ioe.initCause(e);
                throw ioe;
            }
            _instance = JBPMMessages.ProcessInstance.parseFrom(_header.getPayload(), (ExtensionRegistryLite)registry);
        }
        WorkflowProcessInstanceImpl processInstance = this.createProcessInstance();
        processInstance.setId(_instance.getId());
        String processId = _instance.getProcessId();
        processInstance.setProcessId(processId);
        String processXml = _instance.getProcessXml();
        org.kie.definition.process.Process process = null;
        if (processXml != null && processXml.trim().length() > 0) {
            processInstance.setProcessXml(processXml);
            process = processInstance.getProcess();
        } else {
            process = ruleBase.getProcess(processId);
            processInstance.setProcess(process);
        }
        processInstance.setState(_instance.getState());
        long nodeInstanceCounter = _instance.getNodeInstanceCounter();
        processInstance.setKnowledgeRuntime(wm.getKnowledgeRuntime());
        if (_instance.getSwimlaneContextCount() > 0) {
            Context swimlaneContext = ((Process)process).getDefaultContext("SwimlaneScope");
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)processInstance.getContextInstance(swimlaneContext);
            for (JBPMMessages.ProcessInstance.SwimlaneContextInstance _swimlane : _instance.getSwimlaneContextList()) {
                swimlaneContextInstance.setActorId(_swimlane.getSwimlane(), _swimlane.getActorId());
            }
        }
        for (JBPMMessages.ProcessInstance.NodeInstance _node : _instance.getNodeInstanceList()) {
            context.parameterObject = _node;
            this.readNodeInstance(context, processInstance, processInstance);
        }
        for (JBPMMessages.ProcessInstance.ExclusiveGroupInstance _excl : _instance.getExclusiveGroupList()) {
            ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
            processInstance.addContextInstance("ExclusiveGroup", exclusiveGroupInstance);
            for (Long nodeInstanceId : _excl.getGroupNodeInstanceIdList()) {
                org.jbpm.workflow.instance.NodeInstance nodeInstance = processInstance.getNodeInstance(nodeInstanceId);
                if (nodeInstance == null) {
                    throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                }
                exclusiveGroupInstance.addNodeInstance(nodeInstance);
            }
        }
        if (_instance.getVariableCount() > 0) {
            Context variableScope = ((Process)process).getDefaultContext("VariableScope");
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance(variableScope);
            for (JBPMMessages.Variable _variable : _instance.getVariableList()) {
                try {
                    Object _value = ProtobufProcessMarshaller.unmarshallVariableValue(context, _variable);
                    variableScopeInstance.internalSetVariable(_variable.getName(), _value);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + _variable.getName());
                }
            }
        }
        processInstance.internalSetNodeInstanceCounter(nodeInstanceCounter);
        processInstance.reconnect();
        return processInstance;
    }

    protected abstract WorkflowProcessInstanceImpl createProcessInstance();

    @Override
    public NodeInstance readNodeInstance(MarshallerReaderContext context, NodeInstanceContainer nodeInstanceContainer, org.kie.runtime.process.WorkflowProcessInstance processInstance) throws IOException {
        JBPMMessages.ProcessInstance.NodeInstance _node = (JBPMMessages.ProcessInstance.NodeInstance)context.parameterObject;
        NodeInstanceImpl nodeInstance = this.readNodeInstanceContent(_node, context, processInstance);
        nodeInstance.setNodeId(_node.getNodeId());
        nodeInstance.setNodeInstanceContainer(nodeInstanceContainer);
        nodeInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        nodeInstance.setId(_node.getId());
        switch (_node.getContent().getType()) {
            case COMPOSITE_CONTEXT_NODE: 
            case DYNAMIC_NODE: {
                if (_node.getContent().getComposite().getVariableCount() > 0) {
                    Context variableScope = ((Process)((ProcessInstance)processInstance).getProcess()).getDefaultContext("VariableScope");
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((CompositeContextNodeInstance)nodeInstance).getContextInstance(variableScope);
                    for (JBPMMessages.Variable _variable : _node.getContent().getComposite().getVariableList()) {
                        try {
                            Object _value = ProtobufProcessMarshaller.unmarshallVariableValue(context, _variable);
                            variableScopeInstance.internalSetVariable(_variable.getName(), _value);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not reload variable " + _variable.getName());
                        }
                    }
                }
                for (JBPMMessages.ProcessInstance.NodeInstance _instance : _node.getContent().getComposite().getNodeInstanceList()) {
                    context.parameterObject = _instance;
                    this.readNodeInstance(context, (CompositeContextNodeInstance)nodeInstance, processInstance);
                }
                for (JBPMMessages.ProcessInstance.ExclusiveGroupInstance _excl : _node.getContent().getComposite().getExclusiveGroupList()) {
                    ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
                    ((ProcessInstance)processInstance).addContextInstance("ExclusiveGroup", exclusiveGroupInstance);
                    for (Long nodeInstanceId : _excl.getGroupNodeInstanceIdList()) {
                        NodeInstance groupNodeInstance = processInstance.getNodeInstance(nodeInstanceId.longValue());
                        if (groupNodeInstance == null) {
                            throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                        }
                        exclusiveGroupInstance.addNodeInstance(groupNodeInstance);
                    }
                }
                break;
            }
            case FOR_EACH_NODE: {
                for (JBPMMessages.ProcessInstance.NodeInstance _instance : _node.getContent().getForEach().getNodeInstanceList()) {
                    context.parameterObject = _instance;
                    this.readNodeInstance(context, (ForEachNodeInstance)nodeInstance, processInstance);
                }
                break;
            }
            case EVENT_SUBPROCESS_NODE: {
                for (JBPMMessages.ProcessInstance.NodeInstance _instance : _node.getContent().getComposite().getNodeInstanceList()) {
                    context.parameterObject = _instance;
                    this.readNodeInstance(context, (EventSubProcessNodeInstance)nodeInstance, processInstance);
                }
                break;
            }
        }
        return nodeInstance;
    }

    protected NodeInstanceImpl readNodeInstanceContent(JBPMMessages.ProcessInstance.NodeInstance _node, MarshallerReaderContext context, org.kie.runtime.process.WorkflowProcessInstance processInstance) throws IOException {
        NodeInstanceImpl nodeInstance = null;
        JBPMMessages.ProcessInstance.NodeInstanceContent _content = _node.getContent();
        switch (_content.getType()) {
            case RULE_SET_NODE: {
                nodeInstance = new RuleSetNodeInstance();
                ((RuleSetNodeInstance)nodeInstance).setRuleFlowGroup(_content.getRuleSet().getRuleFlowGroup());
                if (_content.getRuleSet().getTimerInstanceIdCount() > 0) {
                    ArrayList<Long> timerInstances = new ArrayList<Long>();
                    for (Long _timerId : _content.getRuleSet().getTimerInstanceIdList()) {
                        timerInstances.add(_timerId);
                    }
                    ((RuleSetNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                }
                if (_content.getRuleSet().getMapEntryCount() <= 0) break;
                HashMap<String, FactHandle> factInfo = new HashMap<String, FactHandle>();
                for (JBPMMessages.ProcessInstance.NodeInstanceContent.RuleSetNode.TextMapEntry entry : _content.getRuleSet().getMapEntryList()) {
                    factInfo.put(entry.getName(), (FactHandle)new DefaultFactHandle(entry.getValue()));
                }
                ((RuleSetNodeInstance)nodeInstance).setFactHandles(factInfo);
                break;
            }
            case HUMAN_TASK_NODE: {
                nodeInstance = new HumanTaskNodeInstance();
                ((HumanTaskNodeInstance)nodeInstance).internalSetWorkItemId(_content.getHumanTask().getWorkItemId());
                if (_content.getHumanTask().getTimerInstanceIdCount() <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (Long _timerId : _content.getHumanTask().getTimerInstanceIdList()) {
                    timerInstances.add(_timerId);
                }
                ((HumanTaskNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case WORK_ITEM_NODE: {
                nodeInstance = new WorkItemNodeInstance();
                ((WorkItemNodeInstance)nodeInstance).internalSetWorkItemId(_content.getWorkItem().getWorkItemId());
                if (_content.getWorkItem().getTimerInstanceIdCount() <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (Long _timerId : _content.getWorkItem().getTimerInstanceIdList()) {
                    timerInstances.add(_timerId);
                }
                ((WorkItemNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case SUBPROCESS_NODE: {
                nodeInstance = new SubProcessNodeInstance();
                ((SubProcessNodeInstance)nodeInstance).internalSetProcessInstanceId(_content.getSubProcess().getProcessInstanceId());
                if (_content.getSubProcess().getTimerInstanceIdCount() <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (Long _timerId : _content.getSubProcess().getTimerInstanceIdList()) {
                    timerInstances.add(_timerId);
                }
                ((SubProcessNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case MILESTONE_NODE: {
                nodeInstance = new MilestoneNodeInstance();
                if (_content.getMilestone().getTimerInstanceIdCount() <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (Long _timerId : _content.getMilestone().getTimerInstanceIdList()) {
                    timerInstances.add(_timerId);
                }
                ((MilestoneNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case TIMER_NODE: {
                nodeInstance = new TimerNodeInstance();
                ((TimerNodeInstance)nodeInstance).internalSetTimerId(_content.getTimer().getTimerId());
                break;
            }
            case EVENT_NODE: {
                nodeInstance = new EventNodeInstance();
                break;
            }
            case JOIN_NODE: {
                nodeInstance = new JoinInstance();
                if (_content.getJoin().getTriggerCount() <= 0) break;
                HashMap<Long, Integer> triggers = new HashMap<Long, Integer>();
                for (JBPMMessages.ProcessInstance.NodeInstanceContent.JoinNode.JoinTrigger _join : _content.getJoin().getTriggerList()) {
                    triggers.put(_join.getNodeId(), _join.getCounter());
                }
                ((JoinInstance)nodeInstance).internalSetTriggers(triggers);
                break;
            }
            case COMPOSITE_CONTEXT_NODE: {
                nodeInstance = new CompositeContextNodeInstance();
                if (_content.getComposite().getTimerInstanceIdCount() <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (Long _timerId : _content.getComposite().getTimerInstanceIdList()) {
                    timerInstances.add(_timerId);
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case FOR_EACH_NODE: {
                nodeInstance = new ForEachNodeInstance();
                break;
            }
            case DYNAMIC_NODE: {
                nodeInstance = new DynamicNodeInstance();
                if (_content.getComposite().getTimerInstanceIdCount() <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (Long _timerId : _content.getComposite().getTimerInstanceIdList()) {
                    timerInstances.add(_timerId);
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case STATE_NODE: {
                nodeInstance = new StateNodeInstance();
                if (_content.getState().getTimerInstanceIdCount() <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (Long _timerId : _content.getState().getTimerInstanceIdList()) {
                    timerInstances.add(_timerId);
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case EVENT_SUBPROCESS_NODE: {
                nodeInstance = new EventSubProcessNodeInstance();
                if (_content.getComposite().getTimerInstanceIdCount() <= 0) break;
                ArrayList<Long> timerInstances = new ArrayList<Long>();
                for (Long _timerId : _content.getComposite().getTimerInstanceIdList()) {
                    timerInstances.add(_timerId);
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + (Object)((Object)_content.getType()));
            }
        }
        return nodeInstance;
    }
}

