/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.node.Constrainable;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.kie.definition.process.Connection;

public class MilestoneNode
extends StateBasedNode
implements Constrainable {
    private static final long serialVersionUID = 510L;
    private String constraint;

    @Override
    public void addConstraint(ConnectionRef connection, Constraint constraint) {
        if (connection != null) {
            throw new IllegalArgumentException("A Milestone node only accepts one simple constraint");
        }
        this.constraint = constraint.getConstraint();
    }

    public void setConstraint(String constraint) {
        this.constraint = constraint;
    }

    public String getConstraint() {
        return this.constraint;
    }

    @Override
    public void validateAddIncomingConnection(String type, Connection connection) {
        super.validateAddIncomingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default incoming connection type!");
        }
        if (this.getFrom() != null && System.getProperty("jbpm.enable.multi.con") == null) {
            throw new IllegalArgumentException("This type of node cannot have more than one incoming connection!");
        }
    }

    @Override
    public void validateAddOutgoingConnection(String type, Connection connection) {
        super.validateAddOutgoingConnection(type, connection);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("This type of node only accepts default outgoing connection type!");
        }
        if (this.getTo() != null && System.getProperty("jbpm.enable.multi.con") == null) {
            throw new IllegalArgumentException("This type of node cannot have more than one outgoing connection!");
        }
    }
}

