/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance;

import java.util.HashMap;
import java.util.Map;
import org.drools.common.InternalKnowledgeRuntime;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.definition.process.Process;
import org.kie.definition.process.WorkflowProcess;
import org.kie.runtime.KieRuntime;

public class WorkflowProcessInstanceUpgrader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeProcessInstance(KieRuntime kruntime, long processInstanceId, String processId, Map<String, Long> nodeMapping) {
        WorkflowProcessInstanceImpl processInstance;
        if (nodeMapping == null) {
            nodeMapping = new HashMap<String, Long>();
        }
        if ((processInstance = (WorkflowProcessInstanceImpl)kruntime.getProcessInstance(processInstanceId)) == null) {
            throw new IllegalArgumentException("Could not find process instance " + processInstanceId);
        }
        if (processId == null) {
            throw new IllegalArgumentException("Null process id");
        }
        WorkflowProcess process = (WorkflowProcess)kruntime.getKieBase().getProcess(processId);
        if (process == null) {
            throw new IllegalArgumentException("Could not find process " + processId);
        }
        if (processInstance.getProcessId().equals(processId)) {
            return;
        }
        WorkflowProcessInstanceImpl workflowProcessInstanceImpl = processInstance;
        synchronized (workflowProcessInstanceImpl) {
            Process oldProcess = processInstance.getProcess();
            processInstance.disconnect();
            processInstance.setProcess(oldProcess);
            WorkflowProcessInstanceUpgrader.updateNodeInstances(processInstance, nodeMapping);
            processInstance.setKnowledgeRuntime((InternalKnowledgeRuntime)kruntime);
            processInstance.setProcess((Process)process);
            processInstance.reconnect();
        }
    }

    private static void updateNodeInstances(NodeInstanceContainer nodeInstanceContainer, Map<String, Long> nodeMapping) {
        for (org.kie.runtime.process.NodeInstance nodeInstance : nodeInstanceContainer.getNodeInstances()) {
            String oldNodeId = ((NodeImpl)((NodeInstance)nodeInstance).getNode()).getUniqueId();
            Long newNodeId = nodeMapping.get(oldNodeId);
            if (newNodeId == null) {
                newNodeId = nodeInstance.getNodeId();
            }
            ((NodeInstanceImpl)nodeInstance).setNodeId(newNodeId);
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            WorkflowProcessInstanceUpgrader.updateNodeInstances((NodeInstanceContainer)nodeInstance, nodeMapping);
        }
    }
}

