/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.definition.process.Connection;
import org.kie.definition.process.Node;
import org.kie.runtime.process.NodeInstance;
import org.kie.runtime.process.NodeInstanceContainer;

public class JoinInstance
extends NodeInstanceImpl {
    private static final long serialVersionUID = 510L;
    private Map<Long, Integer> triggers = new HashMap<Long, Integer>();

    protected Join getJoin() {
        return (Join)this.getNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("An ActionNode only accepts default incoming connections!");
        }
        Join join = this.getJoin();
        switch (join.getType()) {
            case 2: {
                this.triggerCompleted();
                return;
            }
            case 1: {
                Integer count = this.triggers.get(from.getNodeId());
                if (count == null) {
                    this.triggers.put(from.getNodeId(), 1);
                } else {
                    this.triggers.put(from.getNodeId(), count + 1);
                }
                if (!this.checkAllActivated()) return;
                this.decreaseAllTriggers();
                this.triggerCompleted();
                return;
            }
            case 3: {
                boolean triggerCompleted = this.triggers.isEmpty();
                this.triggers.put(from.getNodeId(), new Integer(1));
                if (this.checkAllActivated()) {
                    this.resetAllTriggers();
                }
                if (!triggerCompleted) return;
                this.triggerCompleted();
                return;
            }
            case 4: {
                Integer count = this.triggers.get(from.getNodeId());
                if (count == null) {
                    this.triggers.put(from.getNodeId(), 1);
                } else {
                    this.triggers.put(from.getNodeId(), count + 1);
                }
                int counter = 0;
                for (Connection connection : this.getJoin().getDefaultIncomingConnections()) {
                    if (this.triggers.get(connection.getFrom().getId()) == null) continue;
                    ++counter;
                }
                String n = join.getN();
                Integer number = null;
                if (n.startsWith("#{") && n.endsWith("}")) {
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", n = n.substring(2, n.length() - 1));
                    if (variableScopeInstance == null) {
                        throw new IllegalArgumentException("Could not find variable " + n + " when executing join.");
                    }
                    Object value = variableScopeInstance.getVariable(n);
                    if (!(value instanceof Number)) throw new IllegalArgumentException("Variable " + n + " did not return a number when executing join: " + value);
                    number = ((Number)value).intValue();
                } else {
                    number = new Integer(n);
                }
                if (counter < number) return;
                this.resetAllTriggers();
                this.triggerCompleted();
                return;
            }
            case 5: {
                NodeInstanceContainer nodeInstanceContainer = this.getNodeInstanceContainer();
                boolean activePathExists = this.existsActiveDirectFlow(nodeInstanceContainer, this.getJoin());
                if (activePathExists) return;
                this.triggerCompleted();
                return;
            }
            default: {
                throw new IllegalArgumentException("Illegal join type " + join.getType());
            }
        }
    }

    private boolean checkAllActivated() {
        for (Connection connection : this.getJoin().getDefaultIncomingConnections()) {
            if (this.triggers.get(connection.getFrom().getId()) != null) continue;
            return false;
        }
        return true;
    }

    private void decreaseAllTriggers() {
        for (Connection connection : this.getJoin().getDefaultIncomingConnections()) {
            Integer count = this.triggers.get(connection.getFrom().getId());
            if (count == 1) {
                this.triggers.remove(connection.getFrom().getId());
                continue;
            }
            this.triggers.put(connection.getFrom().getId(), count - 1);
        }
    }

    private boolean existsActiveDirectFlow(NodeInstanceContainer nodeInstanceContainer, Node lookFor) {
        boolean activeDirectPathExists = false;
        Collection activeNodeInstances = nodeInstanceContainer.getNodeInstances();
        HashSet<Long> vistedNodes = new HashSet<Long>();
        for (NodeInstance nodeInstance : activeNodeInstances) {
            boolean nestedCheck;
            if (nodeInstance instanceof NodeInstanceContainer && (nestedCheck = this.existsActiveDirectFlow((NodeInstanceContainer)nodeInstance, lookFor))) {
                return true;
            }
            Node node = nodeInstance.getNode();
            vistedNodes.add(node.getId());
            activeDirectPathExists = this.checkNodes(vistedNodes, node, lookFor);
            if (!activeDirectPathExists) continue;
            return true;
        }
        return activeDirectPathExists;
    }

    private boolean checkNodes(Set<Long> vistedNodes, Node currentNode, Node lookFor) {
        List connections = currentNode.getOutgoingConnections("DROOLS_DEFAULT");
        for (Connection conn : connections) {
            Node nextNode = conn.getTo();
            if (nextNode == null || vistedNodes.contains(nextNode.getId())) continue;
            vistedNodes.add(nextNode.getId());
            if (nextNode.getId() == lookFor.getId()) {
                return true;
            }
            boolean nestedCheck = this.checkNodes(vistedNodes, nextNode, lookFor);
            if (!nestedCheck) continue;
            return true;
        }
        return false;
    }

    private void resetAllTriggers() {
        this.triggers.clear();
    }

    public void triggerCompleted() {
        this.triggerCompleted("DROOLS_DEFAULT", this.triggers.isEmpty());
    }

    public Map<Long, Integer> getTriggers() {
        return this.triggers;
    }

    public void internalSetTriggers(Map<Long, Integer> triggers) {
        this.triggers = triggers;
    }
}

