/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.core.command.CommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.time.AcceptsTimerJobFactoryManager;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.instance.timer.TimerManager;
import org.kie.api.command.Command;
import org.kie.internal.command.Context;
import org.kie.internal.runtime.manager.Runtime;
import org.kie.internal.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class GlobalTimerService
implements TimerService,
InternalSchedulerService,
AcceptsTimerJobFactoryManager {
    protected TimerJobFactoryManager jobFactoryManager;
    protected GlobalSchedulerService schedulerService;
    protected RuntimeManager manager;
    protected ConcurrentHashMap<Integer, List<GlobalJobHandle>> timerJobsPerSession = new ConcurrentHashMap();
    private String timerServiceId;

    public GlobalTimerService(RuntimeManager manager, GlobalSchedulerService schedulerService) {
        this.manager = manager;
        this.schedulerService = schedulerService;
        this.schedulerService.initScheduler(this);
        try {
            this.jobFactoryManager = (TimerJobFactoryManager)Class.forName("org.jbpm.persistence.timer.GlobalJPATimerJobFactoryManager").newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        if (ctx instanceof TimerManager.ProcessJobContext) {
            TimerManager.ProcessJobContext processCtx = (TimerManager.ProcessJobContext)ctx;
            List<GlobalJobHandle> jobHandles = this.timerJobsPerSession.get(processCtx.getSessionId());
            if (jobHandles == null) {
                jobHandles = new CopyOnWriteArrayList<GlobalJobHandle>();
                this.timerJobsPerSession.put(processCtx.getSessionId(), jobHandles);
            } else {
                for (GlobalJobHandle handle : jobHandles) {
                    long timerId = handle.getTimerId();
                    if (timerId != processCtx.getTimer().getId()) continue;
                    return handle;
                }
            }
            GlobalJobHandle jobHandle = (GlobalJobHandle)this.schedulerService.scheduleJob(job, ctx, trigger);
            jobHandles.add(jobHandle);
            return jobHandle;
        }
        GlobalJobHandle jobHandle = (GlobalJobHandle)this.schedulerService.scheduleJob(job, ctx, trigger);
        return jobHandle;
    }

    public boolean removeJob(JobHandle jobHandle) {
        int sessionId = ((GlobalJobHandle)jobHandle).getSessionId();
        List<GlobalJobHandle> handles = this.timerJobsPerSession.get(sessionId);
        if (handles == null) {
            return this.schedulerService.removeJob(jobHandle);
        }
        if (handles.contains(jobHandle)) {
            handles.remove(jobHandle);
            if (handles.isEmpty()) {
                this.timerJobsPerSession.remove(sessionId);
            }
            return this.schedulerService.removeJob(jobHandle);
        }
        return false;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public void shutdown() {
    }

    public long getTimeToNextJob() {
        return 0L;
    }

    public Collection<TimerJobInstance> getTimerJobInstances(int id) {
        ArrayList<TimerJobInstance> timers = new ArrayList<TimerJobInstance>();
        List<GlobalJobHandle> jobs = this.timerJobsPerSession.get(id);
        if (jobs != null) {
            for (GlobalJobHandle job : jobs) {
                timers.add(job.getTimerJobInstance());
            }
        }
        return timers;
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        if (!(this.schedulerService instanceof InternalSchedulerService)) {
            throw new UnsupportedOperationException("Unsupported scheduler operation internalSchedule on class " + this.schedulerService.getClass());
        }
        this.schedulerService.internalSchedule(timerJobInstance);
    }

    public void setTimerJobFactoryManager(TimerJobFactoryManager timerJobFactoryManager) {
    }

    public TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.jobFactoryManager;
    }

    public CommandService getCommandService(JobContext jobContext) {
        JobContext ctxorig = jobContext;
        if (ctxorig instanceof SelfRemovalJobContext) {
            ctxorig = ((SelfRemovalJobContext)ctxorig).getJobContext();
        }
        TimerManager.ProcessJobContext ctx = null;
        if (!(ctxorig instanceof TimerManager.ProcessJobContext)) {
            return this.jobFactoryManager.getCommandService();
        }
        ctx = (TimerManager.ProcessJobContext)ctxorig;
        Runtime runtime = this.manager.getRuntime((org.kie.internal.runtime.manager.Context)ProcessInstanceIdContext.get((Long)ctx.getProcessInstanceId()));
        if (runtime.getKieSession() instanceof CommandBasedStatefulKnowledgeSession) {
            CommandBasedStatefulKnowledgeSession cmd = (CommandBasedStatefulKnowledgeSession)runtime.getKieSession();
            ctx.setKnowledgeRuntime((InternalKnowledgeRuntime)((KnowledgeCommandContext)cmd.getCommandService().getContext()).getKieSession());
            return new DisposableCommandService(cmd.getCommandService(), this.manager, runtime);
        }
        if (runtime.getKieSession() instanceof InternalKnowledgeRuntime) {
            ctx.setKnowledgeRuntime((InternalKnowledgeRuntime)runtime.getKieSession());
        }
        return this.jobFactoryManager.getCommandService();
    }

    public String getTimerServiceId() {
        return this.timerServiceId;
    }

    public void setTimerServiceId(String timerServiceId) {
        this.timerServiceId = timerServiceId;
    }

    public static class DisposableCommandService
    implements CommandService {
        private CommandService delegate;
        private RuntimeManager manager;
        private Runtime runtime;

        public DisposableCommandService(CommandService delegate, RuntimeManager manager, Runtime runtime) {
            this.delegate = delegate;
            this.manager = manager;
            this.runtime = runtime;
        }

        public <T> T execute(Command<T> command) {
            return (T)this.delegate.execute(command);
        }

        public Context getContext() {
            return this.delegate.getContext();
        }

        public void dispose() {
            this.manager.disposeRuntime(this.runtime);
        }
    }

    public static class GlobalJobHandle
    extends DefaultJobHandle
    implements JobHandle {
        private static final long serialVersionUID = 510L;

        public GlobalJobHandle(long id) {
            super(id);
        }

        public long getTimerId() {
            JobContext ctx = this.getTimerJobInstance().getJobContext();
            if (ctx instanceof SelfRemovalJobContext) {
                ctx = ((SelfRemovalJobContext)ctx).getJobContext();
            }
            return ((TimerManager.ProcessJobContext)ctx).getTimer().getId();
        }

        public int getSessionId() {
            JobContext ctx = this.getTimerJobInstance().getJobContext();
            if (ctx instanceof SelfRemovalJobContext) {
                ctx = ((SelfRemovalJobContext)ctx).getJobContext();
            }
            return ((TimerManager.ProcessJobContext)ctx).getSessionId();
        }
    }
}

