/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.reteoo.ReteooStatefulSession;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessRuntimeImpl;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.kie.api.definition.process.Process;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.process.ProcessInstance;

public class ProcessInstanceResolverStrategy
implements ObjectMarshallingStrategy {
    public boolean accept(Object object) {
        return object instanceof ProcessInstance;
    }

    public void write(ObjectOutputStream os, Object object) throws IOException {
        ProcessInstance processInstance = (ProcessInstance)object;
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, os);
        os.writeLong(processInstance.getId());
    }

    public Object read(ObjectInputStream is) throws IOException, ClassNotFoundException {
        long processInstanceId = is.readLong();
        ProcessInstanceManager pim = ProcessInstanceResolverStrategy.retrieveProcessInstanceManager(is);
        ProcessInstance processInstance = pim.getProcessInstance(processInstanceId);
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, is);
        return processInstance;
    }

    public static ProcessInstanceManager retrieveProcessInstanceManager(Object streamContext) {
        ProcessInstanceManager pim = null;
        if (streamContext instanceof MarshallerWriteContext) {
            MarshallerWriteContext context = (MarshallerWriteContext)streamContext;
            pim = ((ProcessRuntimeImpl)((ReteooStatefulSession)context.wm).getProcessRuntime()).getProcessInstanceManager();
        } else if (streamContext instanceof MarshallerReaderContext) {
            MarshallerReaderContext context = (MarshallerReaderContext)streamContext;
            pim = ((ProcessRuntimeImpl)((ReteooStatefulSession)context.wm).getProcessRuntime()).getProcessInstanceManager();
        } else {
            throw new UnsupportedOperationException("Unable to retrieve " + ProcessInstanceManager.class.getSimpleName() + " from " + streamContext.getClass().getName());
        }
        return pim;
    }

    private void connectProcessInstanceToRuntimeAndProcess(ProcessInstance processInstance, Object streamContext) {
        ProcessInstanceImpl processInstanceImpl = (ProcessInstanceImpl)processInstance;
        InternalKnowledgeRuntime kruntime = processInstanceImpl.getKnowledgeRuntime();
        if (kruntime == null) {
            kruntime = ProcessInstanceResolverStrategy.retrieveKnowledgeRuntime(streamContext);
            processInstanceImpl.setKnowledgeRuntime(kruntime);
        }
        if (processInstance.getProcess() == null) {
            Process process = kruntime.getKieBase().getProcess(processInstance.getProcessId());
            processInstanceImpl.setProcess(process);
        }
    }

    public static InternalKnowledgeRuntime retrieveKnowledgeRuntime(Object streamContext) {
        InternalKnowledgeRuntime kruntime = null;
        if (streamContext instanceof MarshallerWriteContext) {
            MarshallerWriteContext context = (MarshallerWriteContext)streamContext;
            kruntime = ((ReteooStatefulSession)context.wm).getKnowledgeRuntime();
        } else if (streamContext instanceof MarshallerReaderContext) {
            MarshallerReaderContext context = (MarshallerReaderContext)streamContext;
            kruntime = ((ReteooStatefulSession)context.wm).getKnowledgeRuntime();
        } else {
            throw new UnsupportedOperationException("Unable to retrieve " + ProcessInstanceManager.class.getSimpleName() + " from " + streamContext.getClass().getName());
        }
        return kruntime;
    }

    public byte[] marshal(ObjectMarshallingStrategy.Context context, ObjectOutputStream os, Object object) throws IOException {
        ProcessInstance processInstance = (ProcessInstance)object;
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, os);
        return PersisterHelper.longToByteArray((long)processInstance.getId());
    }

    public Object unmarshal(ObjectMarshallingStrategy.Context context, ObjectInputStream is, byte[] object, ClassLoader classloader) throws IOException, ClassNotFoundException {
        long processInstanceId = PersisterHelper.byteArrayToLong((byte[])object);
        ProcessInstanceManager pim = ProcessInstanceResolverStrategy.retrieveProcessInstanceManager(is);
        ProcessInstance processInstance = pim.getProcessInstance(processInstanceId);
        this.connectProcessInstanceToRuntimeAndProcess(processInstance, is);
        return processInstance;
    }

    public ObjectMarshallingStrategy.Context createContext() {
        return null;
    }
}

