/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl.factory;

import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.process.NodeInstance;

public class CreateNewNodeFactory
implements NodeInstanceFactory {
    public final Class<? extends NodeInstance> cls;

    public CreateNewNodeFactory(Class<? extends NodeInstance> cls) {
        this.cls = cls;
    }

    @Override
    public NodeInstance getNodeInstance(Node node, WorkflowProcessInstance processInstance, org.kie.api.runtime.process.NodeInstanceContainer nodeInstanceContainer) {
        try {
            NodeInstanceImpl nodeInstance = (NodeInstanceImpl)this.cls.newInstance();
            nodeInstance.setNodeId(node.getId());
            nodeInstance.setNodeInstanceContainer(nodeInstanceContainer);
            nodeInstance.setProcessInstance(processInstance);
            String uniqueID = (String)node.getMetaData().get("UniqueId");
            if (uniqueID == null) {
                uniqueID = node.getId() + "";
            }
            int level = ((NodeInstanceContainer)nodeInstanceContainer).getLevelForNode(uniqueID);
            nodeInstance.setLevel(level);
            return nodeInstance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to instantiate node: '" + this.cls.getName() + "':" + e.getMessage());
        }
    }
}

