/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.core.RuntimeDroolsException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.StartProcessHelper;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.VariableScopeResolverFactory;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.internal.runtime.KnowledgeRuntime;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class SubProcessNodeInstance
extends StateBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 510L;
    private long processInstanceId;

    protected SubProcessNode getSubProcessNode() {
        return (SubProcessNode)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        String latestProcessId;
        super.internalTrigger(from, type);
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A SubProcess node only accepts default incoming connections!");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (DataAssociation mapping : this.getSubProcessNode().getInAssociations()) {
            Object parameterValue = null;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getSources().get(0));
            if (variableScopeInstance != null) {
                parameterValue = variableScopeInstance.getVariable(mapping.getSources().get(0));
            } else {
                try {
                    parameterValue = MVEL.eval((String)mapping.getSources().get(0), (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                }
                catch (Throwable t) {
                    System.err.println("Could not find variable scope for variable " + mapping.getSources().get(0));
                    System.err.println("when trying to execute SubProcess node " + this.getSubProcessNode().getName());
                    System.err.println("Continuing without setting parameter.");
                }
            }
            if (parameterValue == null) continue;
            parameters.put(mapping.getTarget(), parameterValue);
        }
        String processId = this.getSubProcessNode().getProcessId();
        if (processId == null) {
            processId = this.getSubProcessNode().getProcessName();
        }
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PARAMETER_MATCHER.matcher(processId);
        while (matcher.find()) {
            String variableValueString;
            Object variableValue;
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null) continue;
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
            if (variableScopeInstance != null) {
                variableValue = variableScopeInstance.getVariable(paramName);
                variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
                continue;
            }
            try {
                variableValue = MVEL.eval((String)paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                variableValueString = variableValue == null ? "" : variableValue.toString();
                replacements.put(paramName, variableValueString);
            }
            catch (Throwable t) {
                System.err.println("Could not find variable scope for variable " + paramName);
                System.err.println("when trying to replace variable in processId for sub process " + this.getNodeName());
                System.err.println("Continuing without setting process id.");
            }
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            processId = processId.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        KieBase kbase = this.getProcessInstance().getKnowledgeRuntime().getKieBase();
        Process process = kbase.getProcess(processId);
        if (process == null && (latestProcessId = StartProcessHelper.findLatestProcessByName(kbase, processId)) != null) {
            processId = latestProcessId;
            process = kbase.getProcess(processId);
        }
        if (process == null) {
            System.err.println("Could not find process " + processId);
            System.err.println("Aborting process");
            this.getProcessInstance().setState(3);
            throw new RuntimeDroolsException("Could not find process " + processId);
        }
        InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
        RuntimeManager manager = (RuntimeManager)kruntime.getEnvironment().get("RuntimeManager");
        if (manager != null) {
            RuntimeEngine runtime = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
            kruntime = (KnowledgeRuntime)runtime.getKieSession();
        }
        ProcessInstance processInstance = (ProcessInstance)kruntime.createProcessInstance(processId, parameters);
        this.processInstanceId = processInstance.getId();
        ((ProcessInstanceImpl)processInstance).setMetaData("ParentProcessInstanceId", this.getProcessInstance().getId());
        ((ProcessInstanceImpl)processInstance).setParentProcessInstanceId(this.getProcessInstance().getId());
        kruntime.startProcessInstance(processInstance.getId());
        if (!this.getSubProcessNode().isWaitForCompletion()) {
            this.triggerCompleted();
        } else if (processInstance.getState() == 2) {
            this.handleOutMappings(processInstance);
            this.triggerCompleted();
        } else {
            this.addProcessListener();
        }
    }

    @Override
    public void cancel() {
        ProcessInstance processInstance;
        super.cancel();
        if (!(this.getSubProcessNode() != null && this.getSubProcessNode().isIndependent() || (processInstance = (ProcessInstance)this.getProcessInstance().getKnowledgeRuntime().getProcessInstance(this.processInstanceId)) == null)) {
            processInstance.setState(3);
        }
    }

    public long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void internalSetProcessInstanceId(long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addProcessListener();
    }

    private void addProcessListener() {
        this.getProcessInstance().addEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (("processInstanceCompleted:" + this.processInstanceId).equals(type)) {
            this.processInstanceCompleted((ProcessInstance)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{"processInstanceCompleted:" + this.processInstanceId};
    }

    public void processInstanceCompleted(ProcessInstance processInstance) {
        this.removeEventListeners();
        this.handleOutMappings(processInstance);
        this.triggerCompleted();
    }

    private void handleOutMappings(ProcessInstance processInstance) {
        VariableScopeInstance subProcessVariableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
        SubProcessNode subProcessNode = this.getSubProcessNode();
        if (subProcessNode != null) {
            for (DataAssociation mapping : subProcessNode.getOutAssociations()) {
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", mapping.getTarget());
                if (variableScopeInstance != null) {
                    Object value = subProcessVariableScopeInstance.getVariable(mapping.getSources().get(0));
                    if (value == null) {
                        try {
                            value = MVEL.eval((String)mapping.getSources().get(0), (VariableResolverFactory)new VariableScopeResolverFactory(subProcessVariableScopeInstance));
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    variableScopeInstance.setVariable(mapping.getTarget(), value);
                    continue;
                }
                System.err.println("Could not find variable scope for variable " + mapping.getTarget());
                System.err.println("when trying to complete SubProcess node " + this.getSubProcessNode().getName());
                System.err.println("Continuing without setting variable.");
            }
        }
    }

    @Override
    public String getNodeName() {
        Node node = this.getNode();
        if (node == null) {
            return "[Dynamic] Sub Process";
        }
        return super.getNodeName();
    }
}

