/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.RuleBase;
import org.drools.core.SessionConfiguration;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.jbpm.process.StatefulProcessSession;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.StatelessKnowledgeSession;

public class ProcessBaseImpl
implements InternalKnowledgeBase {
    private Map<String, Process> processes = new HashMap<String, Process>();
    private Map<String, KnowledgePackage> packages = new HashMap<String, KnowledgePackage>();
    private List<KieBaseEventListener> listeners = new ArrayList<KieBaseEventListener>();

    public void addEventListener(KieBaseEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(KieBaseEventListener listener) {
        this.listeners.remove(listener);
    }

    public Collection<KieBaseEventListener> getKieBaseEventListeners() {
        return this.listeners;
    }

    public void addKnowledgePackage(KnowledgePackage knowledgePackage) {
        this.packages.put(knowledgePackage.getName(), knowledgePackage);
        for (Process process : knowledgePackage.getProcesses()) {
            this.processes.put(process.getId(), process);
        }
    }

    public void addKnowledgePackages(Collection<KnowledgePackage> knowledgePackages) {
        for (KnowledgePackage knowledgePackage : knowledgePackages) {
            this.addKnowledgePackage(knowledgePackage);
        }
    }

    public Collection<KnowledgePackage> getKnowledgePackages() {
        return this.packages.values();
    }

    public StatefulKnowledgeSession newStatefulKnowledgeSession() {
        return this.newStatefulKnowledgeSession((KieSessionConfiguration)new SessionConfiguration(), EnvironmentFactory.newEnvironment());
    }

    public KieSession newKieSession() {
        return this.newKieSession((KieSessionConfiguration)new SessionConfiguration(), EnvironmentFactory.newEnvironment());
    }

    public StatefulKnowledgeSession newStatefulKnowledgeSession(KieSessionConfiguration conf, Environment environment) {
        return new StatefulProcessSession((KnowledgeBase)this, conf, environment);
    }

    public KieSession newKieSession(KieSessionConfiguration conf, Environment environment) {
        return new StatefulProcessSession((KnowledgeBase)this, conf, environment);
    }

    public Collection<StatefulKnowledgeSession> getStatefulKnowledgeSessions() {
        throw new UnsupportedOperationException("Getting stateful sessions not supported");
    }

    public Collection<StatefulKnowledgeSession> getKieSessions() {
        throw new UnsupportedOperationException("Getting stateful sessions not supported");
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession() {
        throw new UnsupportedOperationException("Stateless sessions not supported");
    }

    public StatelessKnowledgeSession newStatelessKieSession() {
        throw new UnsupportedOperationException("Stateless sessions not supported");
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession(KieSessionConfiguration conf) {
        throw new UnsupportedOperationException("Stateless sessions not supported");
    }

    public StatelessKnowledgeSession newStatelessKieSession(KieSessionConfiguration conf) {
        throw new UnsupportedOperationException("Stateless sessions not supported");
    }

    public void removeKnowledgePackage(String packageName) {
        this.packages.remove(packageName);
    }

    public void removeRule(String packageName, String ruleName) {
        throw new UnsupportedOperationException();
    }

    public void removeQuery(String packageName, String queryName) {
        throw new UnsupportedOperationException();
    }

    public void removeFunction(String packageName, String ruleName) {
        throw new UnsupportedOperationException();
    }

    public void removeProcess(String processId) {
        this.processes.remove(processId);
    }

    public FactType getFactType(String packageName, String typeName) {
        throw new UnsupportedOperationException();
    }

    public KnowledgePackage getKnowledgePackage(String packageName) {
        return this.packages.get(packageName);
    }

    public Process getProcess(String processId) {
        return this.processes.get(processId);
    }

    public Collection<Process> getProcesses() {
        return this.processes.values();
    }

    public Rule getRule(String packageName, String ruleName) {
        throw new UnsupportedOperationException();
    }

    public Query getQuery(String packageName, String queryName) {
        throw new UnsupportedOperationException();
    }

    public RuleBase getRuleBase() {
        return null;
    }

    public Set<String> getEntryPointIds() {
        throw new UnsupportedOperationException("Entry points not supported");
    }

    public Collection<KiePackage> getKiePackages() {
        return this.getKiePackages();
    }

    public KiePackage getKiePackage(String packageName) {
        return this.getKnowledgePackage(packageName);
    }

    public void removeKiePackage(String packageName) {
        this.removeKnowledgePackage(packageName);
    }
}

