/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.core.process.core.Work;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.time.TimeUtils;
import org.jbpm.process.core.context.exception.CompensationScope;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.process.core.validation.ProcessValidator;
import org.jbpm.process.core.validation.impl.ProcessValidationErrorImpl;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CatchLinkNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.ThrowLinkNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Connection;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.mvel2.ErrorDetail;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleFlowProcessValidator
implements ProcessValidator {
    public static final String ASSOCIATIONS = "BPMN.Associations";
    private static RuleFlowProcessValidator instance;
    private static final Logger logger;
    private boolean startNodeFound;
    private boolean endNodeFound;

    private RuleFlowProcessValidator() {
    }

    public static RuleFlowProcessValidator getInstance() {
        if (instance == null) {
            instance = new RuleFlowProcessValidator();
        }
        return instance;
    }

    public ProcessValidationError[] validateProcess(RuleFlowProcess process) {
        ArrayList<ProcessValidationError> errors = new ArrayList<ProcessValidationError>();
        if (process.getName() == null) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no name."));
        }
        if (process.getId() == null || "".equals(process.getId())) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no id."));
        }
        if (process.getPackageName() == null || "".equals(process.getPackageName())) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no package name."));
        }
        if (process.getStartNodes().isEmpty() && !process.isDynamic()) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no start node."));
        }
        this.startNodeFound = false;
        this.endNodeFound = false;
        Node[] nodes = process.getNodes();
        this.validateNodes(nodes, errors, process);
        if (!this.startNodeFound && !process.isDynamic()) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no start node."));
        }
        if (!this.endNodeFound) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no end node."));
        }
        this.validateVariables(errors, process);
        this.checkAllNodesConnectedToStart(process, process.isDynamic(), errors, process);
        return errors.toArray(new ProcessValidationError[errors.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private void validateNodes(Node[] nodes, List<ProcessValidationError> errors, RuleFlowProcess process) {
        String isForCompensation = "isForCompensation";
        for (int i = 0; i < nodes.length; ++i) {
            Object compensationObj;
            Node node = nodes[i];
            if (node instanceof StartNode) {
                StartNode startNode = (StartNode)node;
                this.startNodeFound = true;
                if (startNode.getTo() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Start node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                continue;
            }
            if (node instanceof EndNode) {
                EndNode endNode = (EndNode)node;
                this.endNodeFound = true;
                if (endNode.getFrom() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "End node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                this.validateCompensationIntermediateOrEndEvent(endNode, process, errors);
                continue;
            }
            if (node instanceof RuleSetNode) {
                String ruleFlowGroup;
                RuleSetNode ruleSetNode = (RuleSetNode)node;
                if (ruleSetNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (ruleSetNode.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if ((ruleFlowGroup = ruleSetNode.getRuleFlowGroup()) == null || "".equals(ruleFlowGroup)) {
                    errors.add(new ProcessValidationErrorImpl(process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no ruleflow-group."));
                }
                if (ruleSetNode.getTimers() == null) continue;
                for (Timer timer : ruleSetNode.getTimers().keySet()) {
                    this.validateTimer(timer, node, process, errors);
                }
                continue;
            }
            if (node instanceof Split) {
                Split split = (Split)node;
                if (split.getType() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] has no type."));
                }
                if (split.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (split.getDefaultOutgoingConnections().size() < 2) {
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] does not have more than one outgoing connection: " + split.getOutgoingConnections().size() + "."));
                }
                if (split.getType() != 2 && split.getType() != 3) continue;
                for (Connection connection : split.getDefaultOutgoingConnections()) {
                    if ((split.getConstraint(connection) != null || split.isDefault(connection)) && (split.isDefault(connection) || split.getConstraint(connection).getConstraint() != null && split.getConstraint(connection).getConstraint().trim().length() != 0)) continue;
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] does not have a constraint for " + connection.toString() + "."));
                }
                continue;
            }
            if (node instanceof Join) {
                String n;
                Join join = (Join)node;
                if (join.getType() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] has no type."));
                }
                if (join.getDefaultIncomingConnections().size() < 2) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] does not have more than one incoming connection: " + join.getIncomingConnections().size() + "."));
                }
                if (join.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (join.getType() != 4 || (n = join.getN()).startsWith("#{") && n.endsWith("}")) continue;
                try {
                    new Integer(n);
                }
                catch (NumberFormatException numberFormatException) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] has illegal n value: " + n));
                }
                continue;
            }
            if (node instanceof MilestoneNode) {
                MilestoneNode milestone = (MilestoneNode)node;
                if (milestone.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (milestone.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (milestone.getConstraint() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no constraint."));
                }
                if (milestone.getTimers() == null) continue;
                for (Timer timer : milestone.getTimers().keySet()) {
                    this.validateTimer(timer, node, process, errors);
                }
                continue;
            }
            if (node instanceof StateNode) {
                StateNode stateNode = (StateNode)node;
                if (stateNode.getDefaultIncomingConnections().size() != 0 || this.acceptsNoIncomingConnections(node)) continue;
                errors.add(new ProcessValidationErrorImpl(process, "State node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection"));
                continue;
            }
            if (node instanceof SubProcessNode) {
                SubProcessNode subProcess = (SubProcessNode)node;
                if (subProcess.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (!(subProcess.getTo() != null || this.acceptsNoOutgoingConnections(node) || (compensationObj = subProcess.getMetaData(isForCompensation)) != null && ((Boolean)compensationObj).booleanValue())) {
                    errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (subProcess.getProcessId() == null && subProcess.getProcessName() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no process id."));
                }
                if (subProcess.getTimers() != null) {
                    for (Timer timer : subProcess.getTimers().keySet()) {
                        this.validateTimer(timer, node, process, errors);
                    }
                }
                if (subProcess.isIndependent() || subProcess.isWaitForCompletion()) continue;
                errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] you can only set " + "independent to 'false' only when 'Wait for completion' is set to true."));
                continue;
            }
            if (node instanceof ActionNode) {
                ActionNode actionNode = (ActionNode)node;
                if (actionNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (!(actionNode.getTo() != null || this.acceptsNoOutgoingConnections(node) || (compensationObj = actionNode.getMetaData(isForCompensation)) != null && ((Boolean)compensationObj).booleanValue())) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (actionNode.getAction() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no action."));
                    continue;
                }
                if (!(actionNode.getAction() instanceof DroolsConsequenceAction)) continue;
                DroolsConsequenceAction droolsAction = (DroolsConsequenceAction)actionNode.getAction();
                String string = droolsAction.getConsequence();
                if (string == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has empty action."));
                } else if ("mvel".equals(droolsAction.getDialect())) {
                    try {
                        ExpressionCompiler compiler = new ExpressionCompiler(string);
                        compiler.setVerifying(true);
                        ParserContext parserContext = new ParserContext();
                        compiler.compile(parserContext);
                        List mvelErrors = parserContext.getErrorList();
                        if (mvelErrors != null) {
                            for (ErrorDetail error : mvelErrors) {
                                errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has invalid action: " + error.getMessage() + "."));
                            }
                        }
                    }
                    catch (Throwable t) {
                        errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has invalid action: " + t.getMessage() + "."));
                    }
                }
                this.validateCompensationIntermediateOrEndEvent(actionNode, process, errors);
                continue;
            }
            if (node instanceof WorkItemNode) {
                WorkItemNode workItemNode = (WorkItemNode)node;
                if (workItemNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Task node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (!(workItemNode.getTo() != null || this.acceptsNoOutgoingConnections(node) || (compensationObj = workItemNode.getMetaData(isForCompensation)) != null && ((Boolean)compensationObj).booleanValue())) {
                    errors.add(new ProcessValidationErrorImpl(process, "Task node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (workItemNode.getWork() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Task node '" + node.getName() + "' [" + node.getId() + "] has no work specified."));
                } else {
                    Work work = workItemNode.getWork();
                    if (work.getName() == null || work.getName().trim().length() == 0) {
                        errors.add(new ProcessValidationErrorImpl(process, "Task node '" + node.getName() + "' [" + node.getId() + "] has no task type."));
                    }
                }
                if (workItemNode.getTimers() == null) continue;
                for (Timer timer : workItemNode.getTimers().keySet()) {
                    this.validateTimer(timer, node, process, errors);
                }
                continue;
            }
            if (node instanceof ForEachNode) {
                String string;
                ForEachNode forEachNode = (ForEachNode)node;
                String variableName = forEachNode.getVariableName();
                if (variableName == null || "".equals(variableName)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no variable name"));
                }
                if ((string = forEachNode.getCollectionExpression()) == null || "".equals(string)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no collection expression"));
                }
                if (forEachNode.getDefaultIncomingConnections().size() == 0 && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection"));
                }
                if (forEachNode.getDefaultOutgoingConnections().size() == 0 && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection"));
                }
                this.validateNodes(forEachNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof DynamicNode) {
                DynamicNode dynamicNode = (DynamicNode)node;
                if (dynamicNode.getDefaultIncomingConnections().size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Dynamic node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection"));
                }
                if (dynamicNode.getDefaultOutgoingConnections().size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Dynamic node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection"));
                }
                if ("".equals(dynamicNode.getCompletionExpression()) && !dynamicNode.isAutoComplete()) {
                    errors.add(new ProcessValidationErrorImpl(process, "Dynamic node '" + node.getName() + "' [" + node.getId() + "] has no completion condition set"));
                }
                this.validateNodes(dynamicNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof CompositeNode) {
                CompositeNode compositeNode = (CompositeNode)node;
                for (Map.Entry entry : compositeNode.getLinkedIncomingNodes().entrySet()) {
                    if (compositeNode.getIncomingConnections((String)entry.getKey()).size() == 0 && !this.acceptsNoIncomingConnections(node)) {
                        errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection for type " + (String)entry.getKey()));
                    }
                    if (((CompositeNode.NodeAndType)entry.getValue()).getNode() != null || this.acceptsNoOutgoingConnections(node)) continue;
                    errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has invalid linked incoming node for type " + (String)entry.getKey()));
                }
                for (Map.Entry entry : compositeNode.getLinkedOutgoingNodes().entrySet()) {
                    if (compositeNode.getOutgoingConnections((String)entry.getKey()).size() == 0) {
                        errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection for type " + (String)entry.getKey()));
                    }
                    if (((CompositeNode.NodeAndType)entry.getValue()).getNode() != null) continue;
                    errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has invalid linked outgoing node for type " + (String)entry.getKey()));
                }
                if (compositeNode instanceof EventSubProcessNode) {
                    if (compositeNode.getIncomingConnections().size() > 0) {
                        errors.add(new ProcessValidationErrorImpl(process, "Event subprocess '" + node.getName() + "' [" + node.getId() + "] is not allowed to have any incoming connections."));
                    }
                    if (compositeNode.getOutgoingConnections().size() > 0) {
                        errors.add(new ProcessValidationErrorImpl(process, "Event subprocess '" + node.getName() + "' [" + node.getId() + "] is not allowed to have any outgoing connections."));
                    }
                    Node[] eventSubProcessNodes = compositeNode.getNodes();
                    boolean bl = false;
                    for (int j = 0; j < eventSubProcessNodes.length; ++j) {
                        void var9_20;
                        if (!(eventSubProcessNodes[j] instanceof StartNode)) continue;
                        StartNode startNode = (StartNode)eventSubProcessNodes[j];
                        if (++var9_20 == 2) {
                            errors.add(new ProcessValidationErrorImpl(process, "Event subprocess '" + compositeNode.getName() + "' [" + compositeNode.getId() + "] is not allowed to have more than one start node."));
                        }
                        if (startNode.getTriggers() != null && !startNode.getTriggers().isEmpty()) continue;
                        errors.add(new ProcessValidationErrorImpl(process, "Start node '" + startNode.getName() + "' [" + startNode.getId() + "] in Event SubProcess '" + compositeNode.getName() + "' [" + compositeNode.getId() + "] must contain a trigger (event definition)."));
                    }
                } else {
                    if (compositeNode.getIncomingConnections().size() == 0) {
                        errors.add(new ProcessValidationErrorImpl(process, "Embedded subprocess '" + node.getName() + "' [" + node.getId() + "] does not have incoming connection."));
                    }
                    if (compositeNode.getOutgoingConnections().size() == 0) {
                        errors.add(new ProcessValidationErrorImpl(process, "Embedded subprocess '" + node.getName() + "' [" + node.getId() + "] does not have outgoing connection."));
                    }
                }
                this.validateNodes(compositeNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof EventNode) {
                boolean bl;
                EventNode eventNode = (EventNode)node;
                if (eventNode.getEventFilters().size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Event node '" + node.getName() + "' [" + node.getId() + "] should specify an event type"));
                }
                if (eventNode.getDefaultOutgoingConnections().size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Event node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection"));
                    continue;
                }
                List<EventFilter> eventFilters = eventNode.getEventFilters();
                boolean bl2 = false;
                for (EventFilter eventFilter : eventFilters) {
                    if (!((EventTypeFilter)eventFilter).getType().startsWith("Compensation")) continue;
                    bl = true;
                    break;
                }
                if (!bl || !(eventNode instanceof BoundaryEventNode)) continue;
                Connection connection = eventNode.getDefaultOutgoingConnections().get(0);
                Boolean isAssociation = (Boolean)connection.getMetaData().get("association");
                if (isAssociation == null) {
                    isAssociation = false;
                }
                if (eventNode.getDefaultOutgoingConnections().size() == 1 && connection != null && isAssociation.booleanValue()) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Compensation Boundary Event node '" + node.getName() + "' [" + node.getId() + "] is only allowed to have 1 association to 1 compensation activity."));
                continue;
            }
            if (node instanceof FaultNode) {
                this.endNodeFound = true;
                FaultNode faultNode = (FaultNode)node;
                if (faultNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Fault node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (faultNode.getFaultName() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Fault node '" + node.getName() + "' [" + node.getId() + "] has no fault name."));
                continue;
            }
            if (node instanceof TimerNode) {
                TimerNode timerNode = (TimerNode)node;
                if (timerNode.getFrom() == null && !this.acceptsNoIncomingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Timer node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (timerNode.getTo() == null && !this.acceptsNoOutgoingConnections(node)) {
                    errors.add(new ProcessValidationErrorImpl(process, "Timer node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (timerNode.getTimer() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Timer node '" + node.getName() + "' [" + node.getId() + "] has no timer specified."));
                    continue;
                }
                this.validateTimer(timerNode.getTimer(), node, process, errors);
                continue;
            }
            if (node instanceof CatchLinkNode || node instanceof ThrowLinkNode) continue;
            errors.add(new ProcessValidationErrorImpl(process, "Unknown node type '" + node.getClass().getName() + "'"));
        }
    }

    private void checkAllNodesConnectedToStart(NodeContainer container, boolean isDynamic, List<ProcessValidationError> errors, RuleFlowProcess process) {
        HashMap<Node, Boolean> processNodes = new HashMap<Node, Boolean>();
        Node[] nodes = container instanceof CompositeNode ? ((CompositeNode)container).internalGetNodes() : container.getNodes();
        ArrayList<Node> eventNodes = new ArrayList<Node>();
        ArrayList<CompositeNode> compositeNodes = new ArrayList<CompositeNode>();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            processNodes.put(node, Boolean.FALSE);
            if (node instanceof EventNode) {
                eventNodes.add(node);
            }
            if (!(node instanceof CompositeNode)) continue;
            compositeNodes.add((CompositeNode)node);
        }
        if (isDynamic) {
            for (Node node : nodes) {
                if (!node.getIncomingConnections("DROOLS_DEFAULT").isEmpty()) continue;
                this.processNode(node, processNodes);
            }
        } else {
            List<Node> start = RuleFlowProcess.getStartNodes(nodes);
            if (start != null) {
                for (Node s : start) {
                    this.processNode(s, processNodes);
                }
            }
            if (container instanceof CompositeNode) {
                for (CompositeNode.NodeAndType nodeAndTypes : ((CompositeNode)container).getLinkedIncomingNodes().values()) {
                    this.processNode(nodeAndTypes.getNode(), processNodes);
                }
            }
        }
        for (Node eventNode : eventNodes) {
            this.processNode(eventNode, processNodes);
        }
        for (CompositeNode compositeNode : compositeNodes) {
            this.checkAllNodesConnectedToStart(compositeNode, compositeNode instanceof DynamicNode, errors, process);
        }
        for (Node node : processNodes.keySet()) {
            if (!Boolean.FALSE.equals(processNodes.get(node)) || node instanceof StartNode || node instanceof EventSubProcessNode) continue;
            errors.add(new ProcessValidationErrorImpl(process, "Node '" + node.getName() + "' [" + node.getId() + "] has no connection to the start node."));
        }
    }

    private void processNode(Node node, Map<Node, Boolean> nodes) {
        if (!(nodes.containsKey(node) || node instanceof CompositeNode.CompositeNodeEnd || node instanceof ForEachNode.ForEachSplitNode || node instanceof ForEachNode.ForEachJoinNode)) {
            throw new IllegalStateException("A process node is connected with a node that does not belong to the process: " + node.getName());
        }
        Boolean prevValue = nodes.put(node, Boolean.TRUE);
        if (prevValue == Boolean.FALSE || prevValue == null) {
            for (List list : node.getOutgoingConnections().values()) {
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    this.processNode(((Connection)it2.next()).getTo(), nodes);
                }
            }
        }
    }

    private boolean acceptsNoIncomingConnections(Node node) {
        NodeContainer nodeContainer = node.getNodeContainer();
        return nodeContainer instanceof DynamicNode || nodeContainer instanceof WorkflowProcess && ((WorkflowProcess)nodeContainer).isDynamic();
    }

    private boolean acceptsNoOutgoingConnections(Node node) {
        NodeContainer nodeContainer = node.getNodeContainer();
        return nodeContainer instanceof DynamicNode || nodeContainer instanceof WorkflowProcess && ((WorkflowProcess)nodeContainer).isDynamic();
    }

    private void validateTimer(Timer timer, Node node, RuleFlowProcess process, List<ProcessValidationError> errors) {
        if (timer.getDelay() == null && timer.getDate() == null) {
            errors.add(new ProcessValidationErrorImpl(process, "Node '" + node.getName() + "' [" + node.getId() + "] has timer with no delay or date specified."));
        } else if (timer.getDelay() != null && !timer.getDelay().contains("#{")) {
            try {
                switch (timer.getTimeType()) {
                    case 2: {
                        if (timer.getPeriod() != null) {
                            TimeUtils.parseTimeString((String)timer.getDelay());
                            break;
                        }
                        DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                        break;
                    }
                    case 1: {
                        DateTimeUtils.parseDuration(timer.getDelay());
                        break;
                    }
                    case 3: {
                        DateTimeUtils.parseDateAsDuration(timer.getDate());
                        break;
                    }
                }
            }
            catch (RuntimeException e) {
                errors.add(new ProcessValidationErrorImpl(process, "Could not parse delay '" + timer.getDelay() + "' of node '" + node.getName() + "': " + e.getMessage()));
            }
        }
        if (timer.getPeriod() != null && !timer.getPeriod().contains("#{")) {
            try {
                TimeUtils.parseTimeString((String)timer.getPeriod());
            }
            catch (RuntimeException e) {
                errors.add(new ProcessValidationErrorImpl(process, "Could not parse period '" + timer.getPeriod() + "' of node '" + node.getName() + "': " + e.getMessage()));
            }
        }
    }

    @Override
    public ProcessValidationError[] validateProcess(Process process) {
        if (!(process instanceof RuleFlowProcess)) {
            throw new IllegalArgumentException("This validator can only validate ruleflow processes!");
        }
        return this.validateProcess((RuleFlowProcess)process);
    }

    private void validateVariables(List<ProcessValidationError> errors, RuleFlowProcess process) {
        List<Variable> variables = process.getVariableScope().getVariables();
        if (variables != null) {
            for (Variable var : variables) {
                DataType varDataType = var.getType();
                if (varDataType == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Variable '" + var.getName() + "' has no type."));
                }
                String stringType = varDataType.getStringType();
                if (!(varDataType instanceof ObjectDataType) || !stringType.startsWith("java.lang")) continue;
                logger.warn("Process variable {} uses ObjectDataType for default type (java.lang) which could cause problems with setting variables, use dedicated type instead", (Object)var.getName());
            }
        }
    }

    @Override
    public boolean accept(Process process, Resource resource) {
        return "RuleFlow".equals(process.getType());
    }

    protected void validateCompensationIntermediateOrEndEvent(Node node, RuleFlowProcess process, List<ProcessValidationError> errors) {
        if (node.getMetaData().containsKey("Compensation")) {
            CompensationScope compensationScope;
            String activityRef = (String)node.getMetaData().get("Compensation");
            Node refNode = null;
            if (activityRef != null) {
                LinkedList<Node> nodeQueue = new LinkedList<Node>();
                nodeQueue.addAll(Arrays.asList(process.getNodes()));
                while (!nodeQueue.isEmpty()) {
                    Node polledNode = (Node)nodeQueue.poll();
                    if (activityRef.equals(polledNode.getMetaData().get("UniqueId"))) {
                        refNode = polledNode;
                        break;
                    }
                    if (!(node instanceof NodeContainer)) continue;
                    nodeQueue.addAll(Arrays.asList(((NodeContainer)node).getNodes()));
                }
            }
            if (refNode == null) {
                String nodeType = node instanceof ActionNode ? "Intermediate" : "End";
                errors.add(new ProcessValidationErrorImpl(process, "Node '" + node.getName() + "' [" + node.getId() + "] does not reference an activity that exists (" + activityRef + ") in its compensation event definition."));
            }
            if ((compensationScope = (CompensationScope)((NodeImpl)node).resolveContext("CompensationScope", activityRef)) == null) {
                errors.add(new ProcessValidationErrorImpl(process, "Node '" + node.getName() + "' [" + node.getId() + "] references an activity (" + activityRef + ") in its compensation event definition that is not visible to it."));
            }
        }
    }

    @Override
    public boolean compilationSupported() {
        return true;
    }

    static {
        logger = LoggerFactory.getLogger(RuleFlowProcessValidator.class);
    }
}

