/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.kie.api.definition.process.Node;

public class DynamicNode
extends CompositeContextNode {
    private static final long serialVersionUID = 510L;
    private boolean autoComplete = false;
    private String completionExpression;
    private String language;

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
    }

    @Override
    public boolean acceptsEvent(String type, Object event) {
        for (Node node : this.getNodes()) {
            if (!type.equals(node.getName()) || !node.getIncomingConnections().isEmpty()) continue;
            return true;
        }
        return super.acceptsEvent(type, event);
    }

    @Override
    public Node internalGetNode(long id) {
        try {
            return this.getNode(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getCompletionExpression() {
        return this.completionExpression;
    }

    public void setCompletionExpression(String expression) {
        this.completionExpression = expression;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<Node> getAutoStartNodes() {
        List<Node> nodes = Arrays.stream(this.getNodes()).filter(n -> n.getIncomingConnections().isEmpty() && "true".equalsIgnoreCase((String)n.getMetaData().get("customAutoStart"))).collect(Collectors.toList());
        return nodes;
    }
}

