/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.impl.ProcessInstanceImpl;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.ProcessInstanceResolverFactory;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KieInternalServices;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicUtils {
    private static final Logger logger = LoggerFactory.getLogger(DynamicUtils.class);

    public static void addDynamicWorkItem(DynamicNodeInstance dynamicContext, KieRuntime ksession, String workItemName, Map<String, Object> parameters) {
        WorkflowProcessInstance processInstance = dynamicContext.getProcessInstance();
        DynamicUtils.internalAddDynamicWorkItem(processInstance, dynamicContext, ksession, workItemName, parameters);
    }

    public static void addDynamicWorkItem(ProcessInstance dynamicProcessInstance, KieRuntime ksession, String workItemName, Map<String, Object> parameters) {
        DynamicUtils.internalAddDynamicWorkItem((WorkflowProcessInstance)dynamicProcessInstance, null, ksession, workItemName, parameters);
    }

    private static void internalAddDynamicWorkItem(final WorkflowProcessInstance processInstance, final DynamicNodeInstance dynamicContext, KieRuntime ksession, String workItemName, Map<String, Object> parameters) {
        final WorkItemImpl workItem = new WorkItemImpl();
        workItem.setState(1);
        workItem.setProcessInstanceId(processInstance.getId());
        workItem.setDeploymentId((String)ksession.getEnvironment().get("deploymentId"));
        workItem.setName(workItemName);
        workItem.setParameters(parameters);
        for (Map.Entry entry : workItem.getParameters().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String s = (String)entry.getValue();
            Object variableValue = null;
            Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String paramName = matcher.group(1);
                variableValue = processInstance.getVariable(paramName);
                if (variableValue != null) continue;
                try {
                    variableValue = MVELSafeHelper.getEvaluator().eval(paramName, (VariableResolverFactory)new ProcessInstanceResolverFactory(processInstance));
                }
                catch (Throwable t) {
                    logger.error("Could not find variable scope for variable {}", (Object)paramName);
                    logger.error("when trying to replace variable in string for Dynamic Work Item {}", (Object)workItemName);
                    logger.error("Continuing without setting parameter.");
                }
            }
            if (variableValue == null) continue;
            workItem.setParameter((String)entry.getKey(), variableValue);
        }
        final WorkItemNodeInstance workItemNodeInstance = new WorkItemNodeInstance();
        workItemNodeInstance.internalSetWorkItem((WorkItem)workItem);
        workItemNodeInstance.setMetaData("NodeType", workItemName);
        workItem.setNodeInstanceId(workItemNodeInstance.getId());
        if (ksession instanceof StatefulKnowledgeSessionImpl) {
            workItemNodeInstance.setProcessInstance(processInstance);
            workItemNodeInstance.setNodeInstanceContainer((NodeInstanceContainer)(dynamicContext == null ? processInstance : dynamicContext));
            workItemNodeInstance.addEventListeners();
            DynamicUtils.executeWorkItem((StatefulKnowledgeSessionImpl)ksession, workItem, workItemNodeInstance);
        } else if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            ExecutableRunner runner = ((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
            runner.execute((Command)new ExecutableCommand<Void>(){
                private static final long serialVersionUID = 5L;

                public Void execute(Context context) {
                    StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((RegistryContext)context).lookup(KieSession.class);
                    WorkflowProcessInstance realProcessInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstance.getId());
                    workItemNodeInstance.setProcessInstance(realProcessInstance);
                    if (dynamicContext == null) {
                        workItemNodeInstance.setNodeInstanceContainer((NodeInstanceContainer)realProcessInstance);
                    } else {
                        DynamicNodeInstance realDynamicContext = DynamicUtils.findDynamicContext(realProcessInstance, dynamicContext.getUniqueId());
                        workItemNodeInstance.setNodeInstanceContainer(realDynamicContext);
                    }
                    workItemNodeInstance.addEventListeners();
                    DynamicUtils.executeWorkItem((StatefulKnowledgeSessionImpl)ksession, workItem, workItemNodeInstance);
                    return null;
                }
            });
        } else {
            throw new IllegalArgumentException("Unsupported ksession: " + ksession == null ? "null" : ksession.getClass().getName());
        }
    }

    private static void executeWorkItem(StatefulKnowledgeSessionImpl ksession, WorkItemImpl workItem, WorkItemNodeInstance workItemNodeInstance) {
        ProcessEventSupport eventSupport = ((InternalProcessRuntime)ksession.getProcessRuntime()).getProcessEventSupport();
        eventSupport.fireBeforeNodeTriggered((NodeInstance)workItemNodeInstance, (KieRuntime)ksession);
        ((WorkItemManager)ksession.getWorkItemManager()).internalExecuteWorkItem((WorkItem)workItem);
        workItemNodeInstance.internalSetWorkItemId(workItem.getId());
        eventSupport.fireAfterNodeTriggered((NodeInstance)workItemNodeInstance, (KieRuntime)ksession);
    }

    private static DynamicNodeInstance findDynamicContext(WorkflowProcessInstance processInstance, String uniqueId) {
        for (NodeInstance nodeInstance : ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances(true)) {
            if (!uniqueId.equals(((NodeInstanceImpl)nodeInstance).getUniqueId())) continue;
            return (DynamicNodeInstance)nodeInstance;
        }
        throw new IllegalArgumentException("Could not find node instance " + uniqueId);
    }

    public static long addDynamicSubProcess(DynamicNodeInstance dynamicContext, KieRuntime ksession, String processId, Map<String, Object> parameters) {
        WorkflowProcessInstance processInstance = dynamicContext.getProcessInstance();
        return DynamicUtils.internalAddDynamicSubProcess(processInstance, dynamicContext, ksession, processId, parameters);
    }

    public static long addDynamicSubProcess(ProcessInstance processInstance, KieRuntime ksession, String processId, Map<String, Object> parameters) {
        return DynamicUtils.internalAddDynamicSubProcess((WorkflowProcessInstance)processInstance, null, ksession, processId, parameters);
    }

    public static long internalAddDynamicSubProcess(final WorkflowProcessInstance processInstance, final DynamicNodeInstance dynamicContext, KieRuntime ksession, final String processId, final Map<String, Object> parameters) {
        final SubProcessNodeInstance subProcessNodeInstance = new SubProcessNodeInstance();
        subProcessNodeInstance.setNodeInstanceContainer((NodeInstanceContainer)(dynamicContext == null ? processInstance : dynamicContext));
        subProcessNodeInstance.setProcessInstance(processInstance);
        subProcessNodeInstance.setMetaData("NodeType", "SubProcessNode");
        if (ksession instanceof StatefulKnowledgeSessionImpl) {
            return DynamicUtils.executeSubProcess((StatefulKnowledgeSessionImpl)ksession, processId, parameters, processInstance, subProcessNodeInstance);
        }
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            ExecutableRunner commandService = ((CommandBasedStatefulKnowledgeSession)ksession).getRunner();
            return (Long)commandService.execute((Command)new ExecutableCommand<Long>(){
                private static final long serialVersionUID = 5L;

                public Long execute(Context context) {
                    StatefulKnowledgeSession ksession = (StatefulKnowledgeSession)((RegistryContext)context).lookup(KieSession.class);
                    WorkflowProcessInstance realProcessInstance = (WorkflowProcessInstance)ksession.getProcessInstance(processInstance.getId());
                    subProcessNodeInstance.setProcessInstance(realProcessInstance);
                    if (dynamicContext == null) {
                        subProcessNodeInstance.setNodeInstanceContainer((NodeInstanceContainer)realProcessInstance);
                    } else {
                        DynamicNodeInstance realDynamicContext = DynamicUtils.findDynamicContext(realProcessInstance, dynamicContext.getUniqueId());
                        subProcessNodeInstance.setNodeInstanceContainer(realDynamicContext);
                    }
                    return DynamicUtils.executeSubProcess((StatefulKnowledgeSessionImpl)ksession, processId, parameters, processInstance, subProcessNodeInstance);
                }
            });
        }
        throw new IllegalArgumentException("Unsupported ksession: " + ksession == null ? "null" : ksession.getClass().getName());
    }

    private static long executeSubProcess(StatefulKnowledgeSessionImpl ksession, String processId, Map<String, Object> parameters, org.jbpm.process.instance.ProcessInstance processInstance, SubProcessNodeInstance subProcessNodeInstance) {
        Process process = ksession.getKieBase().getProcess(processId);
        if (process == null) {
            logger.error("Could not find process {}", (Object)processId);
            throw new IllegalArgumentException("No process definition found with id: " + processId);
        }
        ProcessEventSupport eventSupport = ((InternalProcessRuntime)ksession.getProcessRuntime()).getProcessEventSupport();
        eventSupport.fireBeforeNodeTriggered((NodeInstance)subProcessNodeInstance, (KieRuntime)ksession);
        org.jbpm.process.instance.ProcessInstance subProcessInstance = null;
        if (((WorkflowProcessInstanceImpl)processInstance).getCorrelationKey() != null) {
            ArrayList<String> businessKeys = new ArrayList<String>();
            businessKeys.add(((WorkflowProcessInstanceImpl)processInstance).getCorrelationKey());
            businessKeys.add(processId);
            businessKeys.add(String.valueOf(System.currentTimeMillis()));
            CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
            CorrelationKey subProcessCorrelationKey = correlationKeyFactory.newCorrelationKey(businessKeys);
            subProcessInstance = (org.jbpm.process.instance.ProcessInstance)ksession.createProcessInstance(processId, subProcessCorrelationKey, parameters);
        } else {
            subProcessInstance = (org.jbpm.process.instance.ProcessInstance)ksession.createProcessInstance(processId, parameters);
        }
        ((ProcessInstanceImpl)subProcessInstance).setMetaData("ParentProcessInstanceId", processInstance.getId());
        ((ProcessInstanceImpl)subProcessInstance).setParentProcessInstanceId(processInstance.getId());
        subProcessInstance = (org.jbpm.process.instance.ProcessInstance)ksession.startProcessInstance(subProcessInstance.getId());
        subProcessNodeInstance.internalSetProcessInstanceId(subProcessInstance.getId());
        eventSupport.fireAfterNodeTriggered((NodeInstance)subProcessNodeInstance, (KieRuntime)ksession);
        if (subProcessInstance.getState() == 2) {
            subProcessNodeInstance.triggerCompleted();
        } else {
            subProcessNodeInstance.addEventListeners();
        }
        return subProcessInstance.getId();
    }
}

