/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.drools.mvel.MVELSafeHelper;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.DataAssociation;
import org.jbpm.workflow.core.node.Transformation;
import org.jbpm.workflow.instance.impl.MapResolverFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.DataTransformer;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessContext;
import org.mvel2.integration.VariableResolverFactory;

public abstract class ExtendedNodeInstanceImpl
extends NodeInstanceImpl {
    private static final long serialVersionUID = 510L;

    public ExtendedNodeImpl getExtendedNode() {
        return (ExtendedNodeImpl)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        this.triggerEvent("onEntry");
    }

    public void triggerCompleted(boolean remove) {
        this.triggerCompleted("DROOLS_DEFAULT", remove);
    }

    @Override
    protected void triggerCompleted(String type, boolean remove) {
        this.triggerEvent("onExit");
        super.triggerCompleted(type, remove);
    }

    protected void triggerEvent(String type) {
        ExtendedNodeImpl extendedNode = this.getExtendedNode();
        if (extendedNode == null) {
            return;
        }
        List<DroolsAction> actions = extendedNode.getActions(type);
        if (actions != null) {
            for (DroolsAction droolsAction : actions) {
                Action action = (Action)droolsAction.getMetaData("Action");
                this.executeAction(action);
            }
        }
    }

    protected void mapOutputSetVariables(NodeInstance nodeInstance, List<DataAssociation> dataOututAssoctiation, Map<String, Object> ouputData) {
        this.mapOutputSetVariables(nodeInstance, dataOututAssoctiation, ouputData, (target, value) -> {});
    }

    protected void mapOutputSetVariables(NodeInstance nodeInstance, List<DataAssociation> dataOututAssoctiation, Map<String, Object> ouputData, BiConsumer<String, Object> parameterSet) {
        for (DataAssociation association : dataOututAssoctiation) {
            if (association.getTransformation() != null) {
                Transformation transformation = association.getTransformation();
                DataTransformer transformer = DataTransformerRegistry.get().find(transformation.getLanguage());
                if (transformer == null) continue;
                Object parameterValue = transformer.transform(transformation.getCompiledExpression(), ouputData);
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                if (variableScopeInstance != null && parameterValue != null) {
                    variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), association.getTarget(), parameterValue);
                    variableScopeInstance.setVariable(association.getTarget(), parameterValue);
                } else {
                    logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
                    logger.warn("when trying to complete Work Item {}", (Object)nodeInstance.getNodeName());
                    logger.warn("Continuing without setting variable.");
                }
                if (parameterValue == null) continue;
                parameterSet.accept(association.getTarget(), parameterValue);
                continue;
            }
            if (association.getAssignments() == null || association.getAssignments().isEmpty()) {
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", association.getTarget());
                if (variableScopeInstance != null) {
                    Variable varDef;
                    DataType dataType;
                    Object value = ouputData.get(association.getSources().get(0));
                    if (value == null) {
                        try {
                            value = MVELSafeHelper.getEvaluator().eval(association.getSources().get(0), (VariableResolverFactory)new MapResolverFactory(ouputData));
                        }
                        catch (Throwable parameterValue) {
                            // empty catch block
                        }
                    }
                    if (!(dataType = (varDef = variableScopeInstance.getVariableScope().findVariable(association.getTarget())).getType()).getStringType().endsWith("java.lang.Object") && !dataType.getStringType().endsWith("Object") && value instanceof String) {
                        value = dataType.readValue((String)value);
                    } else {
                        variableScopeInstance.getVariableScope().validateVariable(this.getProcessInstance().getProcessName(), association.getTarget(), value);
                    }
                    variableScopeInstance.setVariable(association.getTarget(), value);
                    continue;
                }
                logger.warn("Could not find variable scope for variable {}", (Object)association.getTarget());
                logger.warn("when trying to complete Work Item {}", (Object)nodeInstance.getNodeName());
                logger.warn("Continuing without setting variable.");
                continue;
            }
            try {
                Iterator<Assignment> it = association.getAssignments().iterator();
                while (it.hasNext()) {
                    this.handleAssignment(it.next());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void handleAssignment(Assignment assignment) {
        AssignmentAction action = (AssignmentAction)assignment.getMetaData("Action");
        try {
            org.drools.core.spi.ProcessContext context = new org.drools.core.spi.ProcessContext((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
            context.setNodeInstance((NodeInstance)this);
            action.execute(this, (ProcessContext)context);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to execute Assignment", e);
        }
    }
}

