/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.exception;

import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.context.exception.ExceptionHandler;

public class ExceptionScope
extends AbstractContext {
    private static final long serialVersionUID = 510L;
    public static final String EXCEPTION_SCOPE = "ExceptionScope";
    protected Map<String, ExceptionHandler> exceptionHandlers = new HashMap<String, ExceptionHandler>();

    @Override
    public String getType() {
        return EXCEPTION_SCOPE;
    }

    public void setExceptionHandler(String exception, ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.put(exception, exceptionHandler);
    }

    public ExceptionHandler getExceptionHandler(String exception) {
        ExceptionHandler result = this.exceptionHandlers.get(exception);
        if (result == null) {
            result = this.exceptionHandlers.get(null);
        }
        return result;
    }

    public void removeExceptionHandler(String exception) {
        this.exceptionHandlers.remove(exception);
    }

    public Map<String, ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setExceptionHandlers(Map<String, ExceptionHandler> exceptionHandlers) {
        if (exceptionHandlers == null) {
            throw new IllegalArgumentException("Exception handlers are null");
        }
        this.exceptionHandlers = exceptionHandlers;
    }

    @Override
    public Context resolveContext(Object param) {
        if (param instanceof String) {
            return this.getExceptionHandler((String)param) == null ? null : this;
        }
        throw new IllegalArgumentException("ExceptionScopes can only resolve exception names: " + param);
    }
}

