/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalAgenda;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.spi.Activation;
import org.drools.mvel.MVELSafeHelper;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.EndNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.rule.Match;
import org.mvel2.integration.VariableResolverFactory;

public class DynamicNodeInstance
extends CompositeContextNodeInstance
implements AgendaEventListener {
    private static final long serialVersionUID = 510L;

    private String getRuleFlowGroupName() {
        return this.getNodeName();
    }

    protected DynamicNode getDynamicNode() {
        return (DynamicNode)this.getNode();
    }

    @Override
    public String getNodeName() {
        return this.resolveVariable(super.getNodeName());
    }

    @Override
    public void internalTrigger(org.kie.api.runtime.process.NodeInstance from, String type) {
        this.triggerEvent("onEntry");
        this.registerBoundaryEvents();
        if (this.getNodeInstanceContainer().getNodeInstance(this.getId()) == null) {
            return;
        }
        InternalAgenda agenda = (InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda();
        String ruleFlowGroup = this.getRuleFlowGroupName();
        if (ruleFlowGroup != null && !agenda.getRuleFlowGroup(ruleFlowGroup).isActive()) {
            agenda.getRuleFlowGroup(ruleFlowGroup).setAutoDeactivate(false);
            agenda.activateRuleFlowGroup(ruleFlowGroup, this.getProcessInstance().getId(), this.getUniqueId());
        }
        String rule = "RuleFlow-AdHocComplete-" + this.getProcessInstance().getProcessId() + "-" + this.getDynamicNode().getUniqueId();
        boolean isActive = ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).isRuleActiveInRuleFlowGroup(this.getRuleFlowGroupName(), rule, this.getProcessInstance().getId());
        if (isActive) {
            this.triggerCompleted();
        } else {
            this.addActivationListener();
        }
        List<Node> autoStartNodes = this.getDynamicNode().getAutoStartNodes();
        autoStartNodes.forEach(austoStartNode -> this.triggerSelectedNode((Node)austoStartNode, null));
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addActivationListener();
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().getKnowledgeRuntime().removeEventListener((AgendaEventListener)this);
        this.getProcessInstance().removeEventListener(this.getActivationEventType(), this, true);
    }

    private void addActivationListener() {
        this.getProcessInstance().getKnowledgeRuntime().addEventListener((AgendaEventListener)this);
        this.getProcessInstance().addEventListener(this.getActivationEventType(), this, true);
    }

    private String getActivationEventType() {
        return "RuleFlow-AdHocComplete-" + this.getProcessInstance().getProcessId() + "-" + this.getDynamicNode().getUniqueId();
    }

    @Override
    public void nodeInstanceCompleted(NodeInstance nodeInstance, String outType) {
        Node nodeInstanceNode = nodeInstance.getNode();
        if (nodeInstanceNode != null) {
            boolean isForCompensation;
            Object compensationBoolObj = nodeInstanceNode.getMetaData().get("isForCompensation");
            boolean bl = isForCompensation = compensationBoolObj == null ? false : (Boolean)compensationBoolObj;
            if (isForCompensation) {
                return;
            }
        }
        String completionCondition = this.getDynamicNode().getCompletionExpression();
        if (this.isTerminated(nodeInstance)) {
            this.triggerCompleted("DROOLS_DEFAULT");
        } else if (this.getDynamicNode().isAutoComplete() && this.getNodeInstances(false).isEmpty()) {
            this.triggerCompleted("DROOLS_DEFAULT");
        } else if (completionCondition != null && "mvel".equals(this.getDynamicNode().getLanguage())) {
            Object value = MVELSafeHelper.getEvaluator().eval(completionCondition, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
            if (!(value instanceof Boolean)) {
                throw new RuntimeException("Completion condition expression must return boolean values: " + value + " for expression " + completionCondition);
            }
            if (((Boolean)value).booleanValue()) {
                this.triggerCompleted("DROOLS_DEFAULT");
            }
        }
    }

    @Override
    public void triggerCompleted(String outType) {
        ((InternalAgenda)this.getProcessInstance().getKnowledgeRuntime().getAgenda()).deactivateRuleFlowGroup(this.getRuleFlowGroupName());
        super.triggerCompleted(outType);
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (type.startsWith("RuleFlow-AdHocActivate")) {
            if (event instanceof MatchCreatedEvent) {
                Match match = ((MatchCreatedEvent)event).getMatch();
                match.getDeclarationIds().forEach(s -> this.setVariable(s.replaceFirst("\\$", ""), match.getDeclarationValue(s)));
            }
            this.trigger(null, "DROOLS_DEFAULT");
        } else if (this.getActivationEventType().equals(type)) {
            if (event instanceof MatchCreatedEvent) {
                this.matchCreated((MatchCreatedEvent)event);
            }
        } else {
            super.signalEvent(type, event);
            for (Node node : this.getCompositeNode().getNodes()) {
                if (!type.equals(this.resolveVariable(node.getName())) || !node.getIncomingConnections().isEmpty()) continue;
                this.triggerSelectedNode(node, event);
            }
        }
    }

    protected boolean isTerminated(org.kie.api.runtime.process.NodeInstance from) {
        if (from instanceof EndNodeInstance) {
            return ((EndNodeInstance)from).getEndNode().isTerminate();
        }
        return false;
    }

    protected void triggerSelectedNode(Node node, Object event) {
        NodeInstance nodeInstance = this.getNodeInstance(node);
        if (event != null) {
            HashMap<String, Object> dynamicParams = new HashMap<String, Object>();
            if (event instanceof Map) {
                dynamicParams.putAll((Map)event);
            } else {
                dynamicParams.put("Data", event);
            }
            nodeInstance.setDynamicParameters(dynamicParams);
        }
        nodeInstance.trigger(null, "DROOLS_DEFAULT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matchCreated(MatchCreatedEvent event) {
        String ruleFlowGroup = ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup();
        if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
            String ruleName = event.getMatch().getRule().getName();
            String milestoneName = "RuleFlow-AdHocComplete-" + this.getProcessInstance().getProcessId() + "-" + this.getNodeId();
            if (milestoneName.equals(ruleName) && this.checkProcessInstance((Activation)event.getMatch()) && this.checkDeclarationMatch(event.getMatch(), (String)this.getVariable("MatchVariable"))) {
                WorkflowProcessInstance workflowProcessInstance = this.getProcessInstance();
                synchronized (workflowProcessInstance) {
                    this.removeEventListeners();
                    this.triggerCompleted("DROOLS_DEFAULT");
                }
            }
        }
    }

    public void matchCancelled(MatchCancelledEvent event) {
    }

    public void afterMatchFired(AfterMatchFiredEvent event) {
    }

    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    public void beforeMatchFired(BeforeMatchFiredEvent event) {
    }

    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }
}

