/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.context.variable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.context.AbstractContext;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;

public class VariableScope
extends AbstractContext {
    private static boolean variableStrictEnabled = Boolean.parseBoolean(System.getProperty("org.jbpm.variable.strict", "false"));
    public static final String VARIABLE_SCOPE = "VariableScope";
    public static final String CASE_FILE_PREFIX = "caseFile_";
    private static final long serialVersionUID = 510L;
    private List<Variable> variables = new ArrayList<Variable>();

    @Override
    public String getType() {
        return VARIABLE_SCOPE;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        if (variables == null) {
            throw new IllegalArgumentException("Variables is null");
        }
        this.variables = variables;
    }

    public String[] getVariableNames() {
        String[] result = new String[this.variables.size()];
        if (this.variables != null) {
            for (int i = 0; i < this.variables.size(); ++i) {
                result[i] = this.variables.get(i).getName();
            }
        }
        return result;
    }

    public Variable findVariable(String variableName) {
        for (Variable variable : this.getVariables()) {
            if (!variable.getName().equals(variableName)) continue;
            return variable;
        }
        if (variableName.startsWith(CASE_FILE_PREFIX) && variableName.indexOf(".") == -1) {
            Variable caseVariable = new Variable();
            caseVariable.setName(CASE_FILE_PREFIX + variableName);
            caseVariable.setType(new ObjectDataType());
            return caseVariable;
        }
        return null;
    }

    @Override
    public Context resolveContext(Object param) {
        if (param instanceof String) {
            return this.findVariable((String)param) == null ? null : this;
        }
        throw new IllegalArgumentException("VariableScopes can only resolve variable names: " + param);
    }

    public Object validateVariable(String processName, String name, Object value) {
        Variable var = this.findVariable(name);
        if (var == null) {
            if (variableStrictEnabled) {
                throw new IllegalArgumentException("Variable '" + name + "' is not defined in process " + processName);
            }
        } else if (value != null) {
            boolean isRightType;
            DataType type = var.getType();
            boolean bl = isRightType = type == null || type.verifyDataType(value);
            if (!isRightType) {
                if (variableStrictEnabled) {
                    throw new IllegalArgumentException("Variable '" + name + "' has incorrect data type expected:" + var.getType().getStringType() + " actual:" + value.getClass().getName());
                }
                if (value instanceof String) {
                    value = type.valueOf(value.toString());
                }
            }
        }
        return value;
    }

    public boolean isReadOnly(String name) {
        Variable v = this.findVariable(name);
        if (v != null) {
            return v.hasTag("readonly");
        }
        return false;
    }

    public boolean isRequired(String name) {
        Variable v = this.findVariable(name);
        if (v != null) {
            return v.hasTag("required");
        }
        return false;
    }

    public List<String> tags(String name) {
        Variable v = this.findVariable(name);
        if (v != null) {
            return v.getTags();
        }
        return Collections.emptyList();
    }

    public static void setVariableStrictOption(boolean turnedOn) {
        variableStrictEnabled = turnedOn;
    }
}

