/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.util.MVELSafeHelper;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.impl.XmlProcessDumper;
import org.jbpm.process.core.impl.XmlProcessDumperFactory;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.ProcessInstanceResolverFactory;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.rule.Agenda;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessInstanceImpl
implements ProcessInstance,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ProcessInstanceImpl.class);
    private static final long serialVersionUID = 510L;
    private long id;
    private String processId;
    private transient Process process;
    private String processXml;
    private int state = 0;
    private Map<String, ContextInstance> contextInstances = new HashMap<String, ContextInstance>();
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private transient InternalKnowledgeRuntime kruntime;
    private Map<String, Object> metaData = new HashMap<String, Object>();
    private String outcome;
    private long parentProcessInstanceId;
    private String description;

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public void setProcess(Process process) {
        this.processId = process.getId();
        this.process = process;
    }

    public void updateProcess(Process process) {
        this.setProcess(process);
        XmlProcessDumper dumper = XmlProcessDumperFactory.newXmlProcessDumperFactory();
        this.processXml = dumper.dumpProcess(process);
    }

    public String getProcessXml() {
        return this.processXml;
    }

    public void setProcessXml(String processXml) {
        if (processXml != null && processXml.trim().length() > 0) {
            this.processXml = processXml;
        }
    }

    @Override
    public Process getProcess() {
        if (this.process == null) {
            if (this.processXml == null) {
                if (this.kruntime == null) {
                    throw new IllegalStateException("Process instance " + this.id + "[" + this.processId + "] is disconnected.");
                }
                this.process = this.kruntime.getKieBase().getProcess(this.processId);
            } else {
                XmlProcessDumper dumper = XmlProcessDumperFactory.newXmlProcessDumperFactory();
                this.process = dumper.readProcess(this.processXml);
            }
        }
        return this.process;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessName() {
        return this.getProcess().getName();
    }

    @Override
    public void setState(int state) {
        this.internalSetState(state);
    }

    @Override
    public void setState(int state, String outcome) {
        this.outcome = outcome;
        this.internalSetState(state);
    }

    public void internalSetState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public void setKnowledgeRuntime(InternalKnowledgeRuntime kruntime) {
        if (this.kruntime != null) {
            throw new IllegalArgumentException("Runtime can only be set once.");
        }
        this.kruntime = kruntime;
    }

    @Override
    public InternalKnowledgeRuntime getKnowledgeRuntime() {
        return this.kruntime;
    }

    public Agenda getAgenda() {
        if (this.getKnowledgeRuntime() == null) {
            return null;
        }
        return this.getKnowledgeRuntime().getAgenda();
    }

    @Override
    public ContextContainer getContextContainer() {
        return (ContextContainer)this.getProcess();
    }

    public void setContextInstance(String contextId, ContextInstance contextInstance) {
        this.contextInstances.put(contextId, contextInstance);
    }

    @Override
    public ContextInstance getContextInstance(String contextId) {
        ContextInstance contextInstance = this.contextInstances.get(contextId);
        if (contextInstance != null) {
            return contextInstance;
        }
        Context context = ((ContextContainer)this.getProcess()).getDefaultContext(contextId);
        if (context != null) {
            contextInstance = this.getContextInstance(context);
            return contextInstance;
        }
        return null;
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list == null) {
            list = new ArrayList<ContextInstance>();
            this.subContextInstances.put(contextId, list);
        }
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this);
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    public void signalEvent(String type, Object event) {
    }

    @Override
    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String trigger) {
        ProcessInstanceImpl processInstanceImpl = this;
        synchronized (processInstanceImpl) {
            if (this.getState() != 0) {
                throw new IllegalArgumentException("A process instance can only be started once");
            }
            this.setState(1);
            this.internalStart(trigger);
        }
    }

    protected abstract void internalStart(String var1);

    public void disconnect() {
        ((InternalProcessRuntime)this.kruntime.getProcessRuntime()).getProcessInstanceManager().internalRemoveProcessInstance(this);
        this.process = null;
        this.kruntime = null;
    }

    public void reconnect() {
        ((InternalProcessRuntime)this.kruntime.getProcessRuntime()).getProcessInstanceManager().internalAddProcessInstance(this);
    }

    public String[] getEventTypes() {
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ProcessInstance ");
        b.append(this.getId());
        b.append(" [processId=");
        b.append(this.process.getId());
        b.append(",state=");
        b.append(this.state);
        b.append("]");
        return b.toString();
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    @Override
    public String getOutcome() {
        return this.outcome;
    }

    public long getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    @Override
    public void setParentProcessInstanceId(long parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public String getDescription() {
        if (this.description == null) {
            Object metaData;
            this.description = this.process.getName();
            if (this.process != null && (metaData = this.process.getMetaData().get("customDescription")) instanceof String) {
                String customDescription = (String)metaData;
                HashMap<String, String> replacements = new HashMap<String, String>();
                Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(customDescription);
                while (matcher.find()) {
                    String paramName = matcher.group(1);
                    if (replacements.get(paramName) != null) continue;
                    try {
                        String value = (String)MVELSafeHelper.getEvaluator().eval(paramName, (VariableResolverFactory)new ProcessInstanceResolverFactory((WorkflowProcessInstance)((Object)this)));
                        replacements.put(paramName, value);
                    }
                    catch (Throwable t) {
                        logger.error("Could not resolve customDescription, parameter " + paramName, t);
                        logger.error("Continuing without setting description.");
                    }
                }
                for (Map.Entry replacement : replacements.entrySet()) {
                    customDescription = customDescription.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
                }
                this.description = customDescription;
            }
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

