/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import java.util.ArrayList;
import java.util.Set;
import org.jbpm.process.core.ParameterDefinition;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.impl.ParameterDefinitionImpl;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.factory.DialectConverter;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.TypeConverter;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.fluent.Dialect;
import org.kie.api.fluent.NodeContainerBuilder;
import org.kie.api.fluent.WorkItemNodeBuilder;

public class WorkItemNodeFactory<T extends NodeContainerBuilder<T, ?>>
extends NodeFactory<WorkItemNodeBuilder<T>, T>
implements WorkItemNodeBuilder<T> {
    public WorkItemNodeFactory(T nodeContainerFactory, NodeContainer nodeContainer, long id) {
        super(nodeContainerFactory, nodeContainer, new WorkItemNode(), id);
    }

    protected WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    public WorkItemNodeFactory<T> waitForCompletion(boolean waitForCompletion) {
        this.getWorkItemNode().setWaitForCompletion(waitForCompletion);
        return this;
    }

    public WorkItemNodeFactory<T> inMapping(String parameterName, String variableName) {
        this.getWorkItemNode().addInMapping(parameterName, variableName);
        return this;
    }

    public WorkItemNodeFactory<T> outMapping(String parameterName, String variableName) {
        this.getWorkItemNode().addOutMapping(parameterName, variableName);
        return this;
    }

    public WorkItemNodeFactory<T> workName(String name) {
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getWorkItemNode().setWork(work);
        }
        work.setName(name);
        return this;
    }

    public WorkItemNodeFactory<T> workParameter(String name, Object value) {
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getWorkItemNode().setWork(work);
        }
        work.setParameter(name, value);
        return this;
    }

    public WorkItemNodeFactory<T> workParameterDefinition(String name, DataType dataType) {
        Work work = this.getWorkItemNode().getWork();
        if (work == null) {
            work = new WorkImpl();
            this.getWorkItemNode().setWork(work);
        }
        Set<ParameterDefinition> parameterDefinitions = work.getParameterDefinitions();
        parameterDefinitions.add(new ParameterDefinitionImpl(name, dataType));
        work.setParameterDefinitions(parameterDefinitions);
        return this;
    }

    public WorkItemNodeFactory<T> onEntryAction(String dialect, String action) {
        if (this.getWorkItemNode().getActions(dialect) != null) {
            this.getWorkItemNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getWorkItemNode().setActions("onEntry", actions);
        }
        return this;
    }

    public WorkItemNodeFactory<T> onExitAction(String dialect, String action) {
        if (this.getWorkItemNode().getActions(dialect) != null) {
            this.getWorkItemNode().getActions(dialect).add(new DroolsConsequenceAction(dialect, action));
        } else {
            ArrayList<DroolsAction> actions = new ArrayList<DroolsAction>();
            actions.add(new DroolsConsequenceAction(dialect, action));
            this.getWorkItemNode().setActions("onExit", actions);
        }
        return this;
    }

    public WorkItemNodeFactory<T> timer(String delay, String period, String dialect, String action) {
        Timer timer = new Timer();
        timer.setDelay(delay);
        timer.setPeriod(period);
        this.getWorkItemNode().addTimer(timer, new DroolsConsequenceAction(dialect, action));
        return this;
    }

    public WorkItemNodeFactory<T> onEntryAction(Dialect dialect, String action) {
        return this.onEntryAction(DialectConverter.fromDialect(dialect), action);
    }

    public WorkItemNodeFactory<T> onExitAction(Dialect dialect, String action) {
        return this.onExitAction(DialectConverter.fromDialect(dialect), action);
    }

    public WorkItemNodeFactory<T> timer(String delay, String period, Dialect dialect, String action) {
        return this.timer(delay, period, DialectConverter.fromDialect(dialect), action);
    }

    public WorkItemNodeBuilder<T> workParameterDefinition(String name, Class<?> type) {
        return this.workParameterDefinition(name, TypeConverter.fromType(type));
    }
}

