/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.timer.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.runtime.InternalLocalRunner;
import org.drools.core.time.InternalSchedulerService;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.TimerService;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.CommandServiceTimerJobFactoryManager;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.TimerJobFactoryManager;
import org.drools.core.time.impl.TimerJobInstance;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.NamedJobContext;
import org.jbpm.process.core.timer.impl.TimerServiceListener;
import org.jbpm.process.instance.timer.TimerManager;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.Executable;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalTimerService
implements TimerService,
InternalSchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(GlobalTimerService.class);
    protected TimerJobFactoryManager jobFactoryManager;
    protected final GlobalSchedulerService schedulerService;
    protected final RuntimeManager manager;
    protected final ConcurrentHashMap<Long, List<GlobalJobHandle>> timerJobsPerSession = new ConcurrentHashMap();
    protected final ConcurrentSkipListSet<GlobalJobHandle> startTimerJobs = new ConcurrentSkipListSet((o1, o2) -> Long.valueOf(o1.getId()).compareTo(o2.getId()));
    private List<TimerServiceListener> listeners;
    private String timerServiceId;

    public GlobalTimerService(RuntimeManager manager, GlobalSchedulerService schedulerService) {
        this.manager = manager;
        this.schedulerService = schedulerService;
        this.schedulerService.initScheduler(this);
        this.jobFactoryManager = this.initJobFactoryManager();
        this.listeners = new ArrayList<TimerServiceListener>();
    }

    private TimerJobFactoryManager initJobFactoryManager() {
        try {
            return (TimerJobFactoryManager)Class.forName("org.jbpm.persistence.timer.GlobalJPATimerJobFactoryManager").newInstance();
        }
        catch (Exception e) {
            logger.error("Cannot instantiate TimerJobFactoryManager");
            return null;
        }
    }

    public boolean isTransactional() {
        return this.schedulerService.isTransactional();
    }

    public JobHandle scheduleJob(Job job, JobContext ctx, Trigger trigger) {
        if (ctx instanceof TimerManager.StartProcessJobContext) {
            GlobalJobHandle jobHandle = this.registerJobHandle(job, ctx, trigger);
            if (jobHandle != null) {
                this.startTimerJobs.add(jobHandle);
            }
            return jobHandle;
        }
        if (ctx instanceof TimerManager.ProcessJobContext) {
            TimerManager.ProcessJobContext processCtx = (TimerManager.ProcessJobContext)ctx;
            List<GlobalJobHandle> jobHandles = this.timerJobsPerSession.get(processCtx.getSessionId());
            if (jobHandles == null) {
                jobHandles = new CopyOnWriteArrayList<GlobalJobHandle>();
                this.timerJobsPerSession.put(processCtx.getSessionId(), jobHandles);
            } else {
                for (GlobalJobHandle handle : jobHandles) {
                    long timerId = handle.getTimerId();
                    if (timerId != processCtx.getTimer().getId()) continue;
                    return handle;
                }
            }
            GlobalJobHandle jobHandle = this.registerJobHandle(job, ctx, trigger);
            if (jobHandle != null) {
                jobHandles.add(jobHandle);
            }
            return jobHandle;
        }
        return this.registerJobHandle(job, ctx, trigger);
    }

    public boolean removeJob(JobHandle jobHandle) {
        if (jobHandle == null) {
            return false;
        }
        this.schedulerService.invalidate(jobHandle);
        if (this.startTimerJobs.contains(jobHandle)) {
            logger.debug("Start Job timer handle found {} removed", (Object)jobHandle.getId());
            return this.unregisterJobHandle(jobHandle);
        }
        long sessionId = ((GlobalJobHandle)jobHandle).getSessionId();
        List<GlobalJobHandle> handles = this.timerJobsPerSession.get(sessionId);
        if (handles == null) {
            logger.debug("No known job handles for session {}", (Object)sessionId);
            return this.unregisterJobHandle(jobHandle);
        }
        if (handles.contains(jobHandle)) {
            logger.debug("Found match so removing job handle {} from sessions {} handles", (Object)jobHandle, (Object)sessionId);
            handles.remove(jobHandle);
            if (handles.isEmpty()) {
                this.timerJobsPerSession.remove(sessionId);
            }
            return this.unregisterJobHandle(jobHandle);
        }
        logger.debug("No match for job handle {} within handles of session {}", (Object)jobHandle, (Object)sessionId);
        return false;
    }

    private GlobalJobHandle registerJobHandle(Job job, JobContext ctx, Trigger trigger) {
        GlobalJobHandle jobHandle = (GlobalJobHandle)this.schedulerService.scheduleJob(job, ctx, trigger);
        this.listeners.forEach(listener -> listener.fireTimerScheduled(jobHandle));
        return jobHandle;
    }

    private boolean unregisterJobHandle(JobHandle jobHandle) {
        boolean jobRemoved = this.schedulerService.removeJob(jobHandle);
        this.listeners.forEach(listener -> listener.fireTimerCancelled(jobHandle));
        return jobRemoved;
    }

    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public void reset() {
        this.schedulerService.initScheduler(this);
        this.timerJobsPerSession.clear();
        this.startTimerJobs.clear();
        this.jobFactoryManager = this.initJobFactoryManager();
    }

    public void shutdown() {
    }

    public void destroy() {
        Collection<List<GlobalJobHandle>> activeTimers = this.timerJobsPerSession.values();
        for (List<GlobalJobHandle> handles : activeTimers) {
            for (GlobalJobHandle handle2 : handles) {
                this.unregisterJobHandle(handle2);
            }
        }
        this.startTimerJobs.stream().forEach(handle -> this.unregisterJobHandle((JobHandle)handle));
    }

    public long getTimeToNextJob() {
        return 0L;
    }

    public Collection<TimerJobInstance> getTimerJobInstances(long id) {
        ArrayList<TimerJobInstance> timers = new ArrayList<TimerJobInstance>();
        List<GlobalJobHandle> jobs = this.timerJobsPerSession.get(id);
        if (jobs != null) {
            for (GlobalJobHandle job : jobs) {
                if (job == null || !this.schedulerService.isValid(job)) continue;
                timers.add(job.getTimerJobInstance());
            }
        }
        logger.debug("Returning timers {} per session registered for KieSessionId {}", timers, (Object)id);
        return timers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimerJobInstances(long id) {
        ConcurrentHashMap<Long, List<GlobalJobHandle>> concurrentHashMap = this.timerJobsPerSession;
        synchronized (concurrentHashMap) {
            List<GlobalJobHandle> jobs = this.timerJobsPerSession.remove(id);
            logger.debug(" KieSessionId {} jobs removed: {}. Current size of timerJobsPerSession is {}", new Object[]{id, jobs == null ? "none" : jobs, this.timerJobsPerSession.size()});
            if (jobs != null) {
                for (GlobalJobHandle handle : jobs) {
                    this.jobFactoryManager.removeTimerJobInstance(handle.getTimerJobInstance());
                }
            }
        }
    }

    public void internalSchedule(TimerJobInstance timerJobInstance) {
        if (!(this.schedulerService instanceof InternalSchedulerService)) {
            throw new UnsupportedOperationException("Unsupported scheduler operation internalSchedule on class " + this.schedulerService.getClass());
        }
        this.schedulerService.internalSchedule(timerJobInstance);
    }

    public void setTimerJobFactoryManager(TimerJobFactoryManager timerJobFactoryManager) {
        if (this.jobFactoryManager instanceof CommandServiceTimerJobFactoryManager && timerJobFactoryManager instanceof CommandServiceTimerJobFactoryManager && this.getRunner() == null) {
            ((CommandServiceTimerJobFactoryManager)this.jobFactoryManager).setRunner(((CommandServiceTimerJobFactoryManager)timerJobFactoryManager).getRunner());
        }
    }

    public TimerJobFactoryManager getTimerJobFactoryManager() {
        return this.jobFactoryManager;
    }

    public ExecutableRunner getRunner(JobContext jobContext) {
        JobContext ctxorig = jobContext;
        if (ctxorig instanceof SelfRemovalJobContext) {
            ctxorig = ((SelfRemovalJobContext)ctxorig).getJobContext();
        }
        TimerManager.ProcessJobContext ctx = null;
        if (!(ctxorig instanceof TimerManager.ProcessJobContext)) {
            if (ctxorig instanceof NamedJobContext) {
                return this.getRunner(((NamedJobContext)ctxorig).getProcessInstanceId(), ctx);
            }
            return this.getRunner();
        }
        ctx = (TimerManager.ProcessJobContext)ctxorig;
        return this.getRunner(ctx.getProcessInstanceId(), ctx);
    }

    public String getTimerServiceId() {
        return this.timerServiceId;
    }

    public void setTimerServiceId(String timerServiceId) {
        this.timerServiceId = timerServiceId;
    }

    public JobHandle buildJobHandleForContext(NamedJobContext ctx) {
        return this.schedulerService.buildJobHandleForContext(ctx);
    }

    public InternalRuntimeManager getRuntimeManager() {
        return (InternalRuntimeManager)this.manager;
    }

    protected ExecutableRunner getRunner(Long processInstanceId, TimerManager.ProcessJobContext ctx) {
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        if (runtime == null) {
            throw new RuntimeException("No runtime engine found, could not be initialized yet");
        }
        try {
            if (runtime.getKieSession() instanceof CommandBasedStatefulKnowledgeSession) {
                CommandBasedStatefulKnowledgeSession cmd = (CommandBasedStatefulKnowledgeSession)runtime.getKieSession();
                if (ctx != null) {
                    ctx.setKnowledgeRuntime((InternalKnowledgeRuntime)((SingleSessionCommandService)cmd.getRunner()).getKieSession());
                }
                return new DisposableCommandService((ExecutableRunner<RequestContext>)cmd.getRunner(), this.manager, runtime, this.schedulerService.retryEnabled());
            }
            if (runtime.getKieSession() instanceof InternalKnowledgeRuntime && ctx != null) {
                ctx.setKnowledgeRuntime((InternalKnowledgeRuntime)runtime.getKieSession());
            }
            return new DisposableCommandService(this.getRunner(), this.manager, runtime, this.schedulerService.retryEnabled());
        }
        catch (Throwable e) {
            this.manager.disposeRuntimeEngine(runtime);
            throw new RuntimeException(e);
        }
    }

    private ExecutableRunner<RequestContext> getRunner() {
        return this.jobFactoryManager instanceof CommandServiceTimerJobFactoryManager ? ((CommandServiceTimerJobFactoryManager)this.jobFactoryManager).getRunner() : null;
    }

    public ConcurrentHashMap<Long, List<GlobalJobHandle>> getTimerJobsPerSession() {
        return this.timerJobsPerSession;
    }

    public List<TimerServiceListener> getListeners() {
        return this.listeners;
    }

    public void addTimerServiceListener(TimerServiceListener timerServiceListener) {
        this.listeners.add(timerServiceListener);
    }

    public void removeTimerServiceListener(TimerServiceListener timerServiceListener) {
        this.listeners.remove(timerServiceListener);
    }

    public static class DisposableCommandService
    implements InternalLocalRunner {
        private ExecutableRunner<RequestContext> delegate;
        private RuntimeManager manager;
        private RuntimeEngine runtime;
        private boolean retry = false;

        public DisposableCommandService(ExecutableRunner<RequestContext> delegate, RuntimeManager manager, RuntimeEngine runtime, boolean retry) {
            this.delegate = delegate;
            this.manager = manager;
            this.runtime = runtime;
            this.retry = retry;
        }

        public RequestContext execute(Executable executable, RequestContext ctx) {
            try {
                if (this.delegate == null) {
                    ExecutableRunner runner = ExecutableRunner.create();
                    RequestContext context = ((RequestContext)runner.createContext()).with(this.runtime.getKieSession());
                    return (RequestContext)runner.execute(executable, (org.kie.api.runtime.Context)context);
                }
                return (RequestContext)this.delegate.execute(executable);
            }
            catch (RuntimeException e) {
                if (this.retry) {
                    return (RequestContext)this.delegate.execute(executable, (org.kie.api.runtime.Context)ctx);
                }
                throw e;
            }
        }

        public RequestContext createContext() {
            return (RequestContext)this.delegate.createContext();
        }

        public void dispose() {
            this.manager.disposeRuntimeEngine(this.runtime);
        }

        public Environment getEnvironment() {
            return this.runtime.getKieSession().getEnvironment();
        }
    }

    public static class GlobalJobHandle
    extends DefaultJobHandle
    implements JobHandle {
        private static final long serialVersionUID = 510L;

        public GlobalJobHandle(long id) {
            super(id);
        }

        public long getTimerId() {
            JobContext ctx = this.getTimerJobInstance().getJobContext();
            if (ctx instanceof SelfRemovalJobContext) {
                ctx = ((SelfRemovalJobContext)ctx).getJobContext();
            }
            return ((TimerManager.ProcessJobContext)ctx).getTimer().getId();
        }

        public long getSessionId() {
            if (this.getTimerJobInstance() != null) {
                JobContext ctx = this.getTimerJobInstance().getJobContext();
                if (ctx instanceof SelfRemovalJobContext) {
                    ctx = ((SelfRemovalJobContext)ctx).getJobContext();
                }
                if (ctx instanceof TimerManager.ProcessJobContext) {
                    return ((TimerManager.ProcessJobContext)ctx).getSessionId();
                }
            }
            return -1L;
        }

        public String getUuid() {
            return null;
        }
    }
}

